<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Service StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Service
 * @subpackage Structs
 */
class Service extends AbstractStructBase
{
    /**
     * The ApplicationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ApplicationId;
    /**
     * The ApplicationVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationVersion;
    /**
     * The AuditCreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditCreateDate;
    /**
     * The AuditCreateUnitId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditCreateUnitId;
    /**
     * The AuditCreatedBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditCreatedBy;
    /**
     * The AuditDeleted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditDeleted;
    /**
     * The AuditModifiedBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditModifiedBy;
    /**
     * The AuditModifyDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditModifyDate;
    /**
     * The AuditModifyUnitId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditModifyUnitId;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The Code2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code2;
    /**
     * The CodePuantum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodePuantum;
    /**
     * The DeliveryFinishTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryFinishTime;
    /**
     * The DeliveryFriday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryFriday;
    /**
     * The DeliveryMaxPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DeliveryMaxPeriod;
    /**
     * The DeliveryMinPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DeliveryMinPeriod;
    /**
     * The DeliveryMonday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryMonday;
    /**
     * The DeliverySaturday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliverySaturday;
    /**
     * The DeliveryStartTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryStartTime;
    /**
     * The DeliverySunday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliverySunday;
    /**
     * The DeliveryThursday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryThursday;
    /**
     * The DeliveryTuesday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryTuesday;
    /**
     * The DeliveryWednesday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryWednesday;
    /**
     * The DomesticCargo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DomesticCargo;
    /**
     * The FinishDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FinishDate;
    /**
     * The InternationalCargo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InternationalCargo;
    /**
     * The LovServiceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LovServiceType
     */
    public $LovServiceType;
    /**
     * The MaxSellingCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MaxSellingCount;
    /**
     * The MaxVolume
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MaxVolume;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The MinVolume
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MinVolume;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NameEng
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameEng;
    /**
     * The PaymentReceiver
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentReceiver;
    /**
     * The PaymentSender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentSender;
    /**
     * The PuantumCalculationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PuantumCalculationType;
    /**
     * The ReceiveFinishTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReceiveFinishTime;
    /**
     * The ReceiveFriday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReceiveFriday;
    /**
     * The ReceiveMonday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReceiveMonday;
    /**
     * The ReceiveSaturday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReceiveSaturday;
    /**
     * The ReceiveStartTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReceiveStartTime;
    /**
     * The ReceiveSunday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReceiveSunday;
    /**
     * The ReceiveThursday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReceiveThursday;
    /**
     * The ReceiveTuesday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReceiveTuesday;
    /**
     * The ReceiveWednesday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReceiveWednesday;
    /**
     * The ReturnFeeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ReturnFeeRate;
    /**
     * The ReturnMaxVolume
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ReturnMaxVolume;
    /**
     * The ReturnMinVolume
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ReturnMinVolume;
    /**
     * The ReturningCargo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReturningCargo;
    /**
     * The SalesInvoice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalesInvoice;
    /**
     * The ServiceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ServiceId;
    /**
     * The SourceUnitsExcluded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceUnitsExcluded;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StartDate;
    /**
     * The TargetUnitsExcluded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetUnitsExcluded;
    /**
     * The ValidAllCustomers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidAllCustomers;
    /**
     * The ValidAllSectors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidAllSectors;
    /**
     * The ValidAllSourceUnits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidAllSourceUnits;
    /**
     * The ValidAllTargetUnits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidAllTargetUnits;
    /**
     * The ValidTargetSameCities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidTargetSameCities;
    /**
     * The Vatrate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Vatrate;
    /**
     * The WorldwideIns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WorldwideIns;
    /**
     * The WorldwideInsFixedPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $WorldwideInsFixedPrice;
    /**
     * The WorldwideInsLovCurrencyTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $WorldwideInsLovCurrencyTypeId;
    /**
     * The WorldwideInsMaxPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $WorldwideInsMaxPrice;
    /**
     * The WorldwideInsRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $WorldwideInsRate;
    /**
     * Constructor method for Service
     * @uses Service::setApplicationId()
     * @uses Service::setApplicationVersion()
     * @uses Service::setAuditCreateDate()
     * @uses Service::setAuditCreateUnitId()
     * @uses Service::setAuditCreatedBy()
     * @uses Service::setAuditDeleted()
     * @uses Service::setAuditModifiedBy()
     * @uses Service::setAuditModifyDate()
     * @uses Service::setAuditModifyUnitId()
     * @uses Service::setCode()
     * @uses Service::setCode2()
     * @uses Service::setCodePuantum()
     * @uses Service::setDeliveryFinishTime()
     * @uses Service::setDeliveryFriday()
     * @uses Service::setDeliveryMaxPeriod()
     * @uses Service::setDeliveryMinPeriod()
     * @uses Service::setDeliveryMonday()
     * @uses Service::setDeliverySaturday()
     * @uses Service::setDeliveryStartTime()
     * @uses Service::setDeliverySunday()
     * @uses Service::setDeliveryThursday()
     * @uses Service::setDeliveryTuesday()
     * @uses Service::setDeliveryWednesday()
     * @uses Service::setDomesticCargo()
     * @uses Service::setFinishDate()
     * @uses Service::setInternationalCargo()
     * @uses Service::setLovServiceType()
     * @uses Service::setMaxSellingCount()
     * @uses Service::setMaxVolume()
     * @uses Service::setMessage()
     * @uses Service::setMinVolume()
     * @uses Service::setName()
     * @uses Service::setNameEng()
     * @uses Service::setPaymentReceiver()
     * @uses Service::setPaymentSender()
     * @uses Service::setPuantumCalculationType()
     * @uses Service::setReceiveFinishTime()
     * @uses Service::setReceiveFriday()
     * @uses Service::setReceiveMonday()
     * @uses Service::setReceiveSaturday()
     * @uses Service::setReceiveStartTime()
     * @uses Service::setReceiveSunday()
     * @uses Service::setReceiveThursday()
     * @uses Service::setReceiveTuesday()
     * @uses Service::setReceiveWednesday()
     * @uses Service::setReturnFeeRate()
     * @uses Service::setReturnMaxVolume()
     * @uses Service::setReturnMinVolume()
     * @uses Service::setReturningCargo()
     * @uses Service::setSalesInvoice()
     * @uses Service::setServiceId()
     * @uses Service::setSourceUnitsExcluded()
     * @uses Service::setStartDate()
     * @uses Service::setTargetUnitsExcluded()
     * @uses Service::setValidAllCustomers()
     * @uses Service::setValidAllSectors()
     * @uses Service::setValidAllSourceUnits()
     * @uses Service::setValidAllTargetUnits()
     * @uses Service::setValidTargetSameCities()
     * @uses Service::setVatrate()
     * @uses Service::setWorldwideIns()
     * @uses Service::setWorldwideInsFixedPrice()
     * @uses Service::setWorldwideInsLovCurrencyTypeId()
     * @uses Service::setWorldwideInsMaxPrice()
     * @uses Service::setWorldwideInsRate()
     * @param int $applicationId
     * @param string $applicationVersion
     * @param string $auditCreateDate
     * @param int $auditCreateUnitId
     * @param int $auditCreatedBy
     * @param string $auditDeleted
     * @param int $auditModifiedBy
     * @param string $auditModifyDate
     * @param int $auditModifyUnitId
     * @param string $code
     * @param string $code2
     * @param string $codePuantum
     * @param string $deliveryFinishTime
     * @param string $deliveryFriday
     * @param int $deliveryMaxPeriod
     * @param int $deliveryMinPeriod
     * @param string $deliveryMonday
     * @param string $deliverySaturday
     * @param string $deliveryStartTime
     * @param string $deliverySunday
     * @param string $deliveryThursday
     * @param string $deliveryTuesday
     * @param string $deliveryWednesday
     * @param string $domesticCargo
     * @param string $finishDate
     * @param string $internationalCargo
     * @param \StructType\LovServiceType $lovServiceType
     * @param float $maxSellingCount
     * @param float $maxVolume
     * @param string $message
     * @param float $minVolume
     * @param string $name
     * @param string $nameEng
     * @param string $paymentReceiver
     * @param string $paymentSender
     * @param int $puantumCalculationType
     * @param string $receiveFinishTime
     * @param string $receiveFriday
     * @param string $receiveMonday
     * @param string $receiveSaturday
     * @param string $receiveStartTime
     * @param string $receiveSunday
     * @param string $receiveThursday
     * @param string $receiveTuesday
     * @param string $receiveWednesday
     * @param float $returnFeeRate
     * @param float $returnMaxVolume
     * @param float $returnMinVolume
     * @param string $returningCargo
     * @param string $salesInvoice
     * @param string $serviceId
     * @param string $sourceUnitsExcluded
     * @param string $startDate
     * @param string $targetUnitsExcluded
     * @param string $validAllCustomers
     * @param string $validAllSectors
     * @param string $validAllSourceUnits
     * @param string $validAllTargetUnits
     * @param string $validTargetSameCities
     * @param float $vatrate
     * @param string $worldwideIns
     * @param float $worldwideInsFixedPrice
     * @param int $worldwideInsLovCurrencyTypeId
     * @param float $worldwideInsMaxPrice
     * @param int $worldwideInsRate
     */
    public function __construct($applicationId = null, $applicationVersion = null, $auditCreateDate = null, $auditCreateUnitId = null, $auditCreatedBy = null, $auditDeleted = null, $auditModifiedBy = null, $auditModifyDate = null, $auditModifyUnitId = null, $code = null, $code2 = null, $codePuantum = null, $deliveryFinishTime = null, $deliveryFriday = null, $deliveryMaxPeriod = null, $deliveryMinPeriod = null, $deliveryMonday = null, $deliverySaturday = null, $deliveryStartTime = null, $deliverySunday = null, $deliveryThursday = null, $deliveryTuesday = null, $deliveryWednesday = null, $domesticCargo = null, $finishDate = null, $internationalCargo = null, \StructType\LovServiceType $lovServiceType = null, $maxSellingCount = null, $maxVolume = null, $message = null, $minVolume = null, $name = null, $nameEng = null, $paymentReceiver = null, $paymentSender = null, $puantumCalculationType = null, $receiveFinishTime = null, $receiveFriday = null, $receiveMonday = null, $receiveSaturday = null, $receiveStartTime = null, $receiveSunday = null, $receiveThursday = null, $receiveTuesday = null, $receiveWednesday = null, $returnFeeRate = null, $returnMaxVolume = null, $returnMinVolume = null, $returningCargo = null, $salesInvoice = null, $serviceId = null, $sourceUnitsExcluded = null, $startDate = null, $targetUnitsExcluded = null, $validAllCustomers = null, $validAllSectors = null, $validAllSourceUnits = null, $validAllTargetUnits = null, $validTargetSameCities = null, $vatrate = null, $worldwideIns = null, $worldwideInsFixedPrice = null, $worldwideInsLovCurrencyTypeId = null, $worldwideInsMaxPrice = null, $worldwideInsRate = null)
    {
        $this
            ->setApplicationId($applicationId)
            ->setApplicationVersion($applicationVersion)
            ->setAuditCreateDate($auditCreateDate)
            ->setAuditCreateUnitId($auditCreateUnitId)
            ->setAuditCreatedBy($auditCreatedBy)
            ->setAuditDeleted($auditDeleted)
            ->setAuditModifiedBy($auditModifiedBy)
            ->setAuditModifyDate($auditModifyDate)
            ->setAuditModifyUnitId($auditModifyUnitId)
            ->setCode($code)
            ->setCode2($code2)
            ->setCodePuantum($codePuantum)
            ->setDeliveryFinishTime($deliveryFinishTime)
            ->setDeliveryFriday($deliveryFriday)
            ->setDeliveryMaxPeriod($deliveryMaxPeriod)
            ->setDeliveryMinPeriod($deliveryMinPeriod)
            ->setDeliveryMonday($deliveryMonday)
            ->setDeliverySaturday($deliverySaturday)
            ->setDeliveryStartTime($deliveryStartTime)
            ->setDeliverySunday($deliverySunday)
            ->setDeliveryThursday($deliveryThursday)
            ->setDeliveryTuesday($deliveryTuesday)
            ->setDeliveryWednesday($deliveryWednesday)
            ->setDomesticCargo($domesticCargo)
            ->setFinishDate($finishDate)
            ->setInternationalCargo($internationalCargo)
            ->setLovServiceType($lovServiceType)
            ->setMaxSellingCount($maxSellingCount)
            ->setMaxVolume($maxVolume)
            ->setMessage($message)
            ->setMinVolume($minVolume)
            ->setName($name)
            ->setNameEng($nameEng)
            ->setPaymentReceiver($paymentReceiver)
            ->setPaymentSender($paymentSender)
            ->setPuantumCalculationType($puantumCalculationType)
            ->setReceiveFinishTime($receiveFinishTime)
            ->setReceiveFriday($receiveFriday)
            ->setReceiveMonday($receiveMonday)
            ->setReceiveSaturday($receiveSaturday)
            ->setReceiveStartTime($receiveStartTime)
            ->setReceiveSunday($receiveSunday)
            ->setReceiveThursday($receiveThursday)
            ->setReceiveTuesday($receiveTuesday)
            ->setReceiveWednesday($receiveWednesday)
            ->setReturnFeeRate($returnFeeRate)
            ->setReturnMaxVolume($returnMaxVolume)
            ->setReturnMinVolume($returnMinVolume)
            ->setReturningCargo($returningCargo)
            ->setSalesInvoice($salesInvoice)
            ->setServiceId($serviceId)
            ->setSourceUnitsExcluded($sourceUnitsExcluded)
            ->setStartDate($startDate)
            ->setTargetUnitsExcluded($targetUnitsExcluded)
            ->setValidAllCustomers($validAllCustomers)
            ->setValidAllSectors($validAllSectors)
            ->setValidAllSourceUnits($validAllSourceUnits)
            ->setValidAllTargetUnits($validAllTargetUnits)
            ->setValidTargetSameCities($validTargetSameCities)
            ->setVatrate($vatrate)
            ->setWorldwideIns($worldwideIns)
            ->setWorldwideInsFixedPrice($worldwideInsFixedPrice)
            ->setWorldwideInsLovCurrencyTypeId($worldwideInsLovCurrencyTypeId)
            ->setWorldwideInsMaxPrice($worldwideInsMaxPrice)
            ->setWorldwideInsRate($worldwideInsRate);
    }
    /**
     * Get ApplicationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getApplicationId()
    {
        return isset($this->ApplicationId) ? $this->ApplicationId : null;
    }
    /**
     * Set ApplicationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $applicationId
     * @return \StructType\Service
     */
    public function setApplicationId($applicationId = null)
    {
        // validation for constraint: int
        if (!is_null($applicationId) && !(is_int($applicationId) || ctype_digit($applicationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($applicationId, true), gettype($applicationId)), __LINE__);
        }
        if (is_null($applicationId) || (is_array($applicationId) && empty($applicationId))) {
            unset($this->ApplicationId);
        } else {
            $this->ApplicationId = $applicationId;
        }
        return $this;
    }
    /**
     * Get ApplicationVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationVersion()
    {
        return isset($this->ApplicationVersion) ? $this->ApplicationVersion : null;
    }
    /**
     * Set ApplicationVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationVersion
     * @return \StructType\Service
     */
    public function setApplicationVersion($applicationVersion = null)
    {
        // validation for constraint: string
        if (!is_null($applicationVersion) && !is_string($applicationVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationVersion, true), gettype($applicationVersion)), __LINE__);
        }
        if (is_null($applicationVersion) || (is_array($applicationVersion) && empty($applicationVersion))) {
            unset($this->ApplicationVersion);
        } else {
            $this->ApplicationVersion = $applicationVersion;
        }
        return $this;
    }
    /**
     * Get AuditCreateDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditCreateDate()
    {
        return isset($this->AuditCreateDate) ? $this->AuditCreateDate : null;
    }
    /**
     * Set AuditCreateDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditCreateDate
     * @return \StructType\Service
     */
    public function setAuditCreateDate($auditCreateDate = null)
    {
        // validation for constraint: string
        if (!is_null($auditCreateDate) && !is_string($auditCreateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditCreateDate, true), gettype($auditCreateDate)), __LINE__);
        }
        if (is_null($auditCreateDate) || (is_array($auditCreateDate) && empty($auditCreateDate))) {
            unset($this->AuditCreateDate);
        } else {
            $this->AuditCreateDate = $auditCreateDate;
        }
        return $this;
    }
    /**
     * Get AuditCreateUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditCreateUnitId()
    {
        return isset($this->AuditCreateUnitId) ? $this->AuditCreateUnitId : null;
    }
    /**
     * Set AuditCreateUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditCreateUnitId
     * @return \StructType\Service
     */
    public function setAuditCreateUnitId($auditCreateUnitId = null)
    {
        // validation for constraint: int
        if (!is_null($auditCreateUnitId) && !(is_int($auditCreateUnitId) || ctype_digit($auditCreateUnitId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditCreateUnitId, true), gettype($auditCreateUnitId)), __LINE__);
        }
        if (is_null($auditCreateUnitId) || (is_array($auditCreateUnitId) && empty($auditCreateUnitId))) {
            unset($this->AuditCreateUnitId);
        } else {
            $this->AuditCreateUnitId = $auditCreateUnitId;
        }
        return $this;
    }
    /**
     * Get AuditCreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditCreatedBy()
    {
        return isset($this->AuditCreatedBy) ? $this->AuditCreatedBy : null;
    }
    /**
     * Set AuditCreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditCreatedBy
     * @return \StructType\Service
     */
    public function setAuditCreatedBy($auditCreatedBy = null)
    {
        // validation for constraint: int
        if (!is_null($auditCreatedBy) && !(is_int($auditCreatedBy) || ctype_digit($auditCreatedBy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditCreatedBy, true), gettype($auditCreatedBy)), __LINE__);
        }
        if (is_null($auditCreatedBy) || (is_array($auditCreatedBy) && empty($auditCreatedBy))) {
            unset($this->AuditCreatedBy);
        } else {
            $this->AuditCreatedBy = $auditCreatedBy;
        }
        return $this;
    }
    /**
     * Get AuditDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditDeleted()
    {
        return isset($this->AuditDeleted) ? $this->AuditDeleted : null;
    }
    /**
     * Set AuditDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditDeleted
     * @return \StructType\Service
     */
    public function setAuditDeleted($auditDeleted = null)
    {
        // validation for constraint: string
        if (!is_null($auditDeleted) && !is_string($auditDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditDeleted, true), gettype($auditDeleted)), __LINE__);
        }
        if (is_null($auditDeleted) || (is_array($auditDeleted) && empty($auditDeleted))) {
            unset($this->AuditDeleted);
        } else {
            $this->AuditDeleted = $auditDeleted;
        }
        return $this;
    }
    /**
     * Get AuditModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditModifiedBy()
    {
        return isset($this->AuditModifiedBy) ? $this->AuditModifiedBy : null;
    }
    /**
     * Set AuditModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditModifiedBy
     * @return \StructType\Service
     */
    public function setAuditModifiedBy($auditModifiedBy = null)
    {
        // validation for constraint: int
        if (!is_null($auditModifiedBy) && !(is_int($auditModifiedBy) || ctype_digit($auditModifiedBy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditModifiedBy, true), gettype($auditModifiedBy)), __LINE__);
        }
        if (is_null($auditModifiedBy) || (is_array($auditModifiedBy) && empty($auditModifiedBy))) {
            unset($this->AuditModifiedBy);
        } else {
            $this->AuditModifiedBy = $auditModifiedBy;
        }
        return $this;
    }
    /**
     * Get AuditModifyDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditModifyDate()
    {
        return isset($this->AuditModifyDate) ? $this->AuditModifyDate : null;
    }
    /**
     * Set AuditModifyDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditModifyDate
     * @return \StructType\Service
     */
    public function setAuditModifyDate($auditModifyDate = null)
    {
        // validation for constraint: string
        if (!is_null($auditModifyDate) && !is_string($auditModifyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditModifyDate, true), gettype($auditModifyDate)), __LINE__);
        }
        if (is_null($auditModifyDate) || (is_array($auditModifyDate) && empty($auditModifyDate))) {
            unset($this->AuditModifyDate);
        } else {
            $this->AuditModifyDate = $auditModifyDate;
        }
        return $this;
    }
    /**
     * Get AuditModifyUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditModifyUnitId()
    {
        return isset($this->AuditModifyUnitId) ? $this->AuditModifyUnitId : null;
    }
    /**
     * Set AuditModifyUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditModifyUnitId
     * @return \StructType\Service
     */
    public function setAuditModifyUnitId($auditModifyUnitId = null)
    {
        // validation for constraint: int
        if (!is_null($auditModifyUnitId) && !(is_int($auditModifyUnitId) || ctype_digit($auditModifyUnitId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditModifyUnitId, true), gettype($auditModifyUnitId)), __LINE__);
        }
        if (is_null($auditModifyUnitId) || (is_array($auditModifyUnitId) && empty($auditModifyUnitId))) {
            unset($this->AuditModifyUnitId);
        } else {
            $this->AuditModifyUnitId = $auditModifyUnitId;
        }
        return $this;
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \StructType\Service
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get Code2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode2()
    {
        return isset($this->Code2) ? $this->Code2 : null;
    }
    /**
     * Set Code2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code2
     * @return \StructType\Service
     */
    public function setCode2($code2 = null)
    {
        // validation for constraint: string
        if (!is_null($code2) && !is_string($code2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code2, true), gettype($code2)), __LINE__);
        }
        if (is_null($code2) || (is_array($code2) && empty($code2))) {
            unset($this->Code2);
        } else {
            $this->Code2 = $code2;
        }
        return $this;
    }
    /**
     * Get CodePuantum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodePuantum()
    {
        return isset($this->CodePuantum) ? $this->CodePuantum : null;
    }
    /**
     * Set CodePuantum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codePuantum
     * @return \StructType\Service
     */
    public function setCodePuantum($codePuantum = null)
    {
        // validation for constraint: string
        if (!is_null($codePuantum) && !is_string($codePuantum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codePuantum, true), gettype($codePuantum)), __LINE__);
        }
        if (is_null($codePuantum) || (is_array($codePuantum) && empty($codePuantum))) {
            unset($this->CodePuantum);
        } else {
            $this->CodePuantum = $codePuantum;
        }
        return $this;
    }
    /**
     * Get DeliveryFinishTime value
     * @return string|null
     */
    public function getDeliveryFinishTime()
    {
        return $this->DeliveryFinishTime;
    }
    /**
     * Set DeliveryFinishTime value
     * @param string $deliveryFinishTime
     * @return \StructType\Service
     */
    public function setDeliveryFinishTime($deliveryFinishTime = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryFinishTime) && !is_string($deliveryFinishTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryFinishTime, true), gettype($deliveryFinishTime)), __LINE__);
        }
        $this->DeliveryFinishTime = $deliveryFinishTime;
        return $this;
    }
    /**
     * Get DeliveryFriday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryFriday()
    {
        return isset($this->DeliveryFriday) ? $this->DeliveryFriday : null;
    }
    /**
     * Set DeliveryFriday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryFriday
     * @return \StructType\Service
     */
    public function setDeliveryFriday($deliveryFriday = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryFriday) && !is_string($deliveryFriday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryFriday, true), gettype($deliveryFriday)), __LINE__);
        }
        if (is_null($deliveryFriday) || (is_array($deliveryFriday) && empty($deliveryFriday))) {
            unset($this->DeliveryFriday);
        } else {
            $this->DeliveryFriday = $deliveryFriday;
        }
        return $this;
    }
    /**
     * Get DeliveryMaxPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDeliveryMaxPeriod()
    {
        return isset($this->DeliveryMaxPeriod) ? $this->DeliveryMaxPeriod : null;
    }
    /**
     * Set DeliveryMaxPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $deliveryMaxPeriod
     * @return \StructType\Service
     */
    public function setDeliveryMaxPeriod($deliveryMaxPeriod = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryMaxPeriod) && !(is_int($deliveryMaxPeriod) || ctype_digit($deliveryMaxPeriod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryMaxPeriod, true), gettype($deliveryMaxPeriod)), __LINE__);
        }
        if (is_null($deliveryMaxPeriod) || (is_array($deliveryMaxPeriod) && empty($deliveryMaxPeriod))) {
            unset($this->DeliveryMaxPeriod);
        } else {
            $this->DeliveryMaxPeriod = $deliveryMaxPeriod;
        }
        return $this;
    }
    /**
     * Get DeliveryMinPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDeliveryMinPeriod()
    {
        return isset($this->DeliveryMinPeriod) ? $this->DeliveryMinPeriod : null;
    }
    /**
     * Set DeliveryMinPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $deliveryMinPeriod
     * @return \StructType\Service
     */
    public function setDeliveryMinPeriod($deliveryMinPeriod = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryMinPeriod) && !(is_int($deliveryMinPeriod) || ctype_digit($deliveryMinPeriod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryMinPeriod, true), gettype($deliveryMinPeriod)), __LINE__);
        }
        if (is_null($deliveryMinPeriod) || (is_array($deliveryMinPeriod) && empty($deliveryMinPeriod))) {
            unset($this->DeliveryMinPeriod);
        } else {
            $this->DeliveryMinPeriod = $deliveryMinPeriod;
        }
        return $this;
    }
    /**
     * Get DeliveryMonday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryMonday()
    {
        return isset($this->DeliveryMonday) ? $this->DeliveryMonday : null;
    }
    /**
     * Set DeliveryMonday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryMonday
     * @return \StructType\Service
     */
    public function setDeliveryMonday($deliveryMonday = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryMonday) && !is_string($deliveryMonday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryMonday, true), gettype($deliveryMonday)), __LINE__);
        }
        if (is_null($deliveryMonday) || (is_array($deliveryMonday) && empty($deliveryMonday))) {
            unset($this->DeliveryMonday);
        } else {
            $this->DeliveryMonday = $deliveryMonday;
        }
        return $this;
    }
    /**
     * Get DeliverySaturday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliverySaturday()
    {
        return isset($this->DeliverySaturday) ? $this->DeliverySaturday : null;
    }
    /**
     * Set DeliverySaturday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliverySaturday
     * @return \StructType\Service
     */
    public function setDeliverySaturday($deliverySaturday = null)
    {
        // validation for constraint: string
        if (!is_null($deliverySaturday) && !is_string($deliverySaturday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliverySaturday, true), gettype($deliverySaturday)), __LINE__);
        }
        if (is_null($deliverySaturday) || (is_array($deliverySaturday) && empty($deliverySaturday))) {
            unset($this->DeliverySaturday);
        } else {
            $this->DeliverySaturday = $deliverySaturday;
        }
        return $this;
    }
    /**
     * Get DeliveryStartTime value
     * @return string|null
     */
    public function getDeliveryStartTime()
    {
        return $this->DeliveryStartTime;
    }
    /**
     * Set DeliveryStartTime value
     * @param string $deliveryStartTime
     * @return \StructType\Service
     */
    public function setDeliveryStartTime($deliveryStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryStartTime) && !is_string($deliveryStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryStartTime, true), gettype($deliveryStartTime)), __LINE__);
        }
        $this->DeliveryStartTime = $deliveryStartTime;
        return $this;
    }
    /**
     * Get DeliverySunday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliverySunday()
    {
        return isset($this->DeliverySunday) ? $this->DeliverySunday : null;
    }
    /**
     * Set DeliverySunday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliverySunday
     * @return \StructType\Service
     */
    public function setDeliverySunday($deliverySunday = null)
    {
        // validation for constraint: string
        if (!is_null($deliverySunday) && !is_string($deliverySunday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliverySunday, true), gettype($deliverySunday)), __LINE__);
        }
        if (is_null($deliverySunday) || (is_array($deliverySunday) && empty($deliverySunday))) {
            unset($this->DeliverySunday);
        } else {
            $this->DeliverySunday = $deliverySunday;
        }
        return $this;
    }
    /**
     * Get DeliveryThursday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryThursday()
    {
        return isset($this->DeliveryThursday) ? $this->DeliveryThursday : null;
    }
    /**
     * Set DeliveryThursday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryThursday
     * @return \StructType\Service
     */
    public function setDeliveryThursday($deliveryThursday = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryThursday) && !is_string($deliveryThursday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryThursday, true), gettype($deliveryThursday)), __LINE__);
        }
        if (is_null($deliveryThursday) || (is_array($deliveryThursday) && empty($deliveryThursday))) {
            unset($this->DeliveryThursday);
        } else {
            $this->DeliveryThursday = $deliveryThursday;
        }
        return $this;
    }
    /**
     * Get DeliveryTuesday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryTuesday()
    {
        return isset($this->DeliveryTuesday) ? $this->DeliveryTuesday : null;
    }
    /**
     * Set DeliveryTuesday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryTuesday
     * @return \StructType\Service
     */
    public function setDeliveryTuesday($deliveryTuesday = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryTuesday) && !is_string($deliveryTuesday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryTuesday, true), gettype($deliveryTuesday)), __LINE__);
        }
        if (is_null($deliveryTuesday) || (is_array($deliveryTuesday) && empty($deliveryTuesday))) {
            unset($this->DeliveryTuesday);
        } else {
            $this->DeliveryTuesday = $deliveryTuesday;
        }
        return $this;
    }
    /**
     * Get DeliveryWednesday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryWednesday()
    {
        return isset($this->DeliveryWednesday) ? $this->DeliveryWednesday : null;
    }
    /**
     * Set DeliveryWednesday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryWednesday
     * @return \StructType\Service
     */
    public function setDeliveryWednesday($deliveryWednesday = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryWednesday) && !is_string($deliveryWednesday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryWednesday, true), gettype($deliveryWednesday)), __LINE__);
        }
        if (is_null($deliveryWednesday) || (is_array($deliveryWednesday) && empty($deliveryWednesday))) {
            unset($this->DeliveryWednesday);
        } else {
            $this->DeliveryWednesday = $deliveryWednesday;
        }
        return $this;
    }
    /**
     * Get DomesticCargo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDomesticCargo()
    {
        return isset($this->DomesticCargo) ? $this->DomesticCargo : null;
    }
    /**
     * Set DomesticCargo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $domesticCargo
     * @return \StructType\Service
     */
    public function setDomesticCargo($domesticCargo = null)
    {
        // validation for constraint: string
        if (!is_null($domesticCargo) && !is_string($domesticCargo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domesticCargo, true), gettype($domesticCargo)), __LINE__);
        }
        if (is_null($domesticCargo) || (is_array($domesticCargo) && empty($domesticCargo))) {
            unset($this->DomesticCargo);
        } else {
            $this->DomesticCargo = $domesticCargo;
        }
        return $this;
    }
    /**
     * Get FinishDate value
     * @return string|null
     */
    public function getFinishDate()
    {
        return $this->FinishDate;
    }
    /**
     * Set FinishDate value
     * @param string $finishDate
     * @return \StructType\Service
     */
    public function setFinishDate($finishDate = null)
    {
        // validation for constraint: string
        if (!is_null($finishDate) && !is_string($finishDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($finishDate, true), gettype($finishDate)), __LINE__);
        }
        $this->FinishDate = $finishDate;
        return $this;
    }
    /**
     * Get InternationalCargo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInternationalCargo()
    {
        return isset($this->InternationalCargo) ? $this->InternationalCargo : null;
    }
    /**
     * Set InternationalCargo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $internationalCargo
     * @return \StructType\Service
     */
    public function setInternationalCargo($internationalCargo = null)
    {
        // validation for constraint: string
        if (!is_null($internationalCargo) && !is_string($internationalCargo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internationalCargo, true), gettype($internationalCargo)), __LINE__);
        }
        if (is_null($internationalCargo) || (is_array($internationalCargo) && empty($internationalCargo))) {
            unset($this->InternationalCargo);
        } else {
            $this->InternationalCargo = $internationalCargo;
        }
        return $this;
    }
    /**
     * Get LovServiceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LovServiceType|null
     */
    public function getLovServiceType()
    {
        return isset($this->LovServiceType) ? $this->LovServiceType : null;
    }
    /**
     * Set LovServiceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\LovServiceType $lovServiceType
     * @return \StructType\Service
     */
    public function setLovServiceType(\StructType\LovServiceType $lovServiceType = null)
    {
        if (is_null($lovServiceType) || (is_array($lovServiceType) && empty($lovServiceType))) {
            unset($this->LovServiceType);
        } else {
            $this->LovServiceType = $lovServiceType;
        }
        return $this;
    }
    /**
     * Get MaxSellingCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMaxSellingCount()
    {
        return isset($this->MaxSellingCount) ? $this->MaxSellingCount : null;
    }
    /**
     * Set MaxSellingCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $maxSellingCount
     * @return \StructType\Service
     */
    public function setMaxSellingCount($maxSellingCount = null)
    {
        // validation for constraint: float
        if (!is_null($maxSellingCount) && !(is_float($maxSellingCount) || is_numeric($maxSellingCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxSellingCount, true), gettype($maxSellingCount)), __LINE__);
        }
        if (is_null($maxSellingCount) || (is_array($maxSellingCount) && empty($maxSellingCount))) {
            unset($this->MaxSellingCount);
        } else {
            $this->MaxSellingCount = $maxSellingCount;
        }
        return $this;
    }
    /**
     * Get MaxVolume value
     * @return float|null
     */
    public function getMaxVolume()
    {
        return $this->MaxVolume;
    }
    /**
     * Set MaxVolume value
     * @param float $maxVolume
     * @return \StructType\Service
     */
    public function setMaxVolume($maxVolume = null)
    {
        // validation for constraint: float
        if (!is_null($maxVolume) && !(is_float($maxVolume) || is_numeric($maxVolume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxVolume, true), gettype($maxVolume)), __LINE__);
        }
        $this->MaxVolume = $maxVolume;
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \StructType\Service
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get MinVolume value
     * @return float|null
     */
    public function getMinVolume()
    {
        return $this->MinVolume;
    }
    /**
     * Set MinVolume value
     * @param float $minVolume
     * @return \StructType\Service
     */
    public function setMinVolume($minVolume = null)
    {
        // validation for constraint: float
        if (!is_null($minVolume) && !(is_float($minVolume) || is_numeric($minVolume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minVolume, true), gettype($minVolume)), __LINE__);
        }
        $this->MinVolume = $minVolume;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\Service
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NameEng value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameEng()
    {
        return isset($this->NameEng) ? $this->NameEng : null;
    }
    /**
     * Set NameEng value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameEng
     * @return \StructType\Service
     */
    public function setNameEng($nameEng = null)
    {
        // validation for constraint: string
        if (!is_null($nameEng) && !is_string($nameEng)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameEng, true), gettype($nameEng)), __LINE__);
        }
        if (is_null($nameEng) || (is_array($nameEng) && empty($nameEng))) {
            unset($this->NameEng);
        } else {
            $this->NameEng = $nameEng;
        }
        return $this;
    }
    /**
     * Get PaymentReceiver value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentReceiver()
    {
        return isset($this->PaymentReceiver) ? $this->PaymentReceiver : null;
    }
    /**
     * Set PaymentReceiver value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentReceiver
     * @return \StructType\Service
     */
    public function setPaymentReceiver($paymentReceiver = null)
    {
        // validation for constraint: string
        if (!is_null($paymentReceiver) && !is_string($paymentReceiver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentReceiver, true), gettype($paymentReceiver)), __LINE__);
        }
        if (is_null($paymentReceiver) || (is_array($paymentReceiver) && empty($paymentReceiver))) {
            unset($this->PaymentReceiver);
        } else {
            $this->PaymentReceiver = $paymentReceiver;
        }
        return $this;
    }
    /**
     * Get PaymentSender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentSender()
    {
        return isset($this->PaymentSender) ? $this->PaymentSender : null;
    }
    /**
     * Set PaymentSender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentSender
     * @return \StructType\Service
     */
    public function setPaymentSender($paymentSender = null)
    {
        // validation for constraint: string
        if (!is_null($paymentSender) && !is_string($paymentSender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentSender, true), gettype($paymentSender)), __LINE__);
        }
        if (is_null($paymentSender) || (is_array($paymentSender) && empty($paymentSender))) {
            unset($this->PaymentSender);
        } else {
            $this->PaymentSender = $paymentSender;
        }
        return $this;
    }
    /**
     * Get PuantumCalculationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPuantumCalculationType()
    {
        return isset($this->PuantumCalculationType) ? $this->PuantumCalculationType : null;
    }
    /**
     * Set PuantumCalculationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $puantumCalculationType
     * @return \StructType\Service
     */
    public function setPuantumCalculationType($puantumCalculationType = null)
    {
        // validation for constraint: int
        if (!is_null($puantumCalculationType) && !(is_int($puantumCalculationType) || ctype_digit($puantumCalculationType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($puantumCalculationType, true), gettype($puantumCalculationType)), __LINE__);
        }
        if (is_null($puantumCalculationType) || (is_array($puantumCalculationType) && empty($puantumCalculationType))) {
            unset($this->PuantumCalculationType);
        } else {
            $this->PuantumCalculationType = $puantumCalculationType;
        }
        return $this;
    }
    /**
     * Get ReceiveFinishTime value
     * @return string|null
     */
    public function getReceiveFinishTime()
    {
        return $this->ReceiveFinishTime;
    }
    /**
     * Set ReceiveFinishTime value
     * @param string $receiveFinishTime
     * @return \StructType\Service
     */
    public function setReceiveFinishTime($receiveFinishTime = null)
    {
        // validation for constraint: string
        if (!is_null($receiveFinishTime) && !is_string($receiveFinishTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiveFinishTime, true), gettype($receiveFinishTime)), __LINE__);
        }
        $this->ReceiveFinishTime = $receiveFinishTime;
        return $this;
    }
    /**
     * Get ReceiveFriday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReceiveFriday()
    {
        return isset($this->ReceiveFriday) ? $this->ReceiveFriday : null;
    }
    /**
     * Set ReceiveFriday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $receiveFriday
     * @return \StructType\Service
     */
    public function setReceiveFriday($receiveFriday = null)
    {
        // validation for constraint: string
        if (!is_null($receiveFriday) && !is_string($receiveFriday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiveFriday, true), gettype($receiveFriday)), __LINE__);
        }
        if (is_null($receiveFriday) || (is_array($receiveFriday) && empty($receiveFriday))) {
            unset($this->ReceiveFriday);
        } else {
            $this->ReceiveFriday = $receiveFriday;
        }
        return $this;
    }
    /**
     * Get ReceiveMonday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReceiveMonday()
    {
        return isset($this->ReceiveMonday) ? $this->ReceiveMonday : null;
    }
    /**
     * Set ReceiveMonday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $receiveMonday
     * @return \StructType\Service
     */
    public function setReceiveMonday($receiveMonday = null)
    {
        // validation for constraint: string
        if (!is_null($receiveMonday) && !is_string($receiveMonday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiveMonday, true), gettype($receiveMonday)), __LINE__);
        }
        if (is_null($receiveMonday) || (is_array($receiveMonday) && empty($receiveMonday))) {
            unset($this->ReceiveMonday);
        } else {
            $this->ReceiveMonday = $receiveMonday;
        }
        return $this;
    }
    /**
     * Get ReceiveSaturday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReceiveSaturday()
    {
        return isset($this->ReceiveSaturday) ? $this->ReceiveSaturday : null;
    }
    /**
     * Set ReceiveSaturday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $receiveSaturday
     * @return \StructType\Service
     */
    public function setReceiveSaturday($receiveSaturday = null)
    {
        // validation for constraint: string
        if (!is_null($receiveSaturday) && !is_string($receiveSaturday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiveSaturday, true), gettype($receiveSaturday)), __LINE__);
        }
        if (is_null($receiveSaturday) || (is_array($receiveSaturday) && empty($receiveSaturday))) {
            unset($this->ReceiveSaturday);
        } else {
            $this->ReceiveSaturday = $receiveSaturday;
        }
        return $this;
    }
    /**
     * Get ReceiveStartTime value
     * @return string|null
     */
    public function getReceiveStartTime()
    {
        return $this->ReceiveStartTime;
    }
    /**
     * Set ReceiveStartTime value
     * @param string $receiveStartTime
     * @return \StructType\Service
     */
    public function setReceiveStartTime($receiveStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($receiveStartTime) && !is_string($receiveStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiveStartTime, true), gettype($receiveStartTime)), __LINE__);
        }
        $this->ReceiveStartTime = $receiveStartTime;
        return $this;
    }
    /**
     * Get ReceiveSunday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReceiveSunday()
    {
        return isset($this->ReceiveSunday) ? $this->ReceiveSunday : null;
    }
    /**
     * Set ReceiveSunday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $receiveSunday
     * @return \StructType\Service
     */
    public function setReceiveSunday($receiveSunday = null)
    {
        // validation for constraint: string
        if (!is_null($receiveSunday) && !is_string($receiveSunday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiveSunday, true), gettype($receiveSunday)), __LINE__);
        }
        if (is_null($receiveSunday) || (is_array($receiveSunday) && empty($receiveSunday))) {
            unset($this->ReceiveSunday);
        } else {
            $this->ReceiveSunday = $receiveSunday;
        }
        return $this;
    }
    /**
     * Get ReceiveThursday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReceiveThursday()
    {
        return isset($this->ReceiveThursday) ? $this->ReceiveThursday : null;
    }
    /**
     * Set ReceiveThursday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $receiveThursday
     * @return \StructType\Service
     */
    public function setReceiveThursday($receiveThursday = null)
    {
        // validation for constraint: string
        if (!is_null($receiveThursday) && !is_string($receiveThursday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiveThursday, true), gettype($receiveThursday)), __LINE__);
        }
        if (is_null($receiveThursday) || (is_array($receiveThursday) && empty($receiveThursday))) {
            unset($this->ReceiveThursday);
        } else {
            $this->ReceiveThursday = $receiveThursday;
        }
        return $this;
    }
    /**
     * Get ReceiveTuesday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReceiveTuesday()
    {
        return isset($this->ReceiveTuesday) ? $this->ReceiveTuesday : null;
    }
    /**
     * Set ReceiveTuesday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $receiveTuesday
     * @return \StructType\Service
     */
    public function setReceiveTuesday($receiveTuesday = null)
    {
        // validation for constraint: string
        if (!is_null($receiveTuesday) && !is_string($receiveTuesday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiveTuesday, true), gettype($receiveTuesday)), __LINE__);
        }
        if (is_null($receiveTuesday) || (is_array($receiveTuesday) && empty($receiveTuesday))) {
            unset($this->ReceiveTuesday);
        } else {
            $this->ReceiveTuesday = $receiveTuesday;
        }
        return $this;
    }
    /**
     * Get ReceiveWednesday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReceiveWednesday()
    {
        return isset($this->ReceiveWednesday) ? $this->ReceiveWednesday : null;
    }
    /**
     * Set ReceiveWednesday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $receiveWednesday
     * @return \StructType\Service
     */
    public function setReceiveWednesday($receiveWednesday = null)
    {
        // validation for constraint: string
        if (!is_null($receiveWednesday) && !is_string($receiveWednesday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiveWednesday, true), gettype($receiveWednesday)), __LINE__);
        }
        if (is_null($receiveWednesday) || (is_array($receiveWednesday) && empty($receiveWednesday))) {
            unset($this->ReceiveWednesday);
        } else {
            $this->ReceiveWednesday = $receiveWednesday;
        }
        return $this;
    }
    /**
     * Get ReturnFeeRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getReturnFeeRate()
    {
        return isset($this->ReturnFeeRate) ? $this->ReturnFeeRate : null;
    }
    /**
     * Set ReturnFeeRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $returnFeeRate
     * @return \StructType\Service
     */
    public function setReturnFeeRate($returnFeeRate = null)
    {
        // validation for constraint: float
        if (!is_null($returnFeeRate) && !(is_float($returnFeeRate) || is_numeric($returnFeeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($returnFeeRate, true), gettype($returnFeeRate)), __LINE__);
        }
        if (is_null($returnFeeRate) || (is_array($returnFeeRate) && empty($returnFeeRate))) {
            unset($this->ReturnFeeRate);
        } else {
            $this->ReturnFeeRate = $returnFeeRate;
        }
        return $this;
    }
    /**
     * Get ReturnMaxVolume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getReturnMaxVolume()
    {
        return isset($this->ReturnMaxVolume) ? $this->ReturnMaxVolume : null;
    }
    /**
     * Set ReturnMaxVolume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $returnMaxVolume
     * @return \StructType\Service
     */
    public function setReturnMaxVolume($returnMaxVolume = null)
    {
        // validation for constraint: float
        if (!is_null($returnMaxVolume) && !(is_float($returnMaxVolume) || is_numeric($returnMaxVolume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($returnMaxVolume, true), gettype($returnMaxVolume)), __LINE__);
        }
        if (is_null($returnMaxVolume) || (is_array($returnMaxVolume) && empty($returnMaxVolume))) {
            unset($this->ReturnMaxVolume);
        } else {
            $this->ReturnMaxVolume = $returnMaxVolume;
        }
        return $this;
    }
    /**
     * Get ReturnMinVolume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getReturnMinVolume()
    {
        return isset($this->ReturnMinVolume) ? $this->ReturnMinVolume : null;
    }
    /**
     * Set ReturnMinVolume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $returnMinVolume
     * @return \StructType\Service
     */
    public function setReturnMinVolume($returnMinVolume = null)
    {
        // validation for constraint: float
        if (!is_null($returnMinVolume) && !(is_float($returnMinVolume) || is_numeric($returnMinVolume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($returnMinVolume, true), gettype($returnMinVolume)), __LINE__);
        }
        if (is_null($returnMinVolume) || (is_array($returnMinVolume) && empty($returnMinVolume))) {
            unset($this->ReturnMinVolume);
        } else {
            $this->ReturnMinVolume = $returnMinVolume;
        }
        return $this;
    }
    /**
     * Get ReturningCargo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReturningCargo()
    {
        return isset($this->ReturningCargo) ? $this->ReturningCargo : null;
    }
    /**
     * Set ReturningCargo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $returningCargo
     * @return \StructType\Service
     */
    public function setReturningCargo($returningCargo = null)
    {
        // validation for constraint: string
        if (!is_null($returningCargo) && !is_string($returningCargo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returningCargo, true), gettype($returningCargo)), __LINE__);
        }
        if (is_null($returningCargo) || (is_array($returningCargo) && empty($returningCargo))) {
            unset($this->ReturningCargo);
        } else {
            $this->ReturningCargo = $returningCargo;
        }
        return $this;
    }
    /**
     * Get SalesInvoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesInvoice()
    {
        return isset($this->SalesInvoice) ? $this->SalesInvoice : null;
    }
    /**
     * Set SalesInvoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesInvoice
     * @return \StructType\Service
     */
    public function setSalesInvoice($salesInvoice = null)
    {
        // validation for constraint: string
        if (!is_null($salesInvoice) && !is_string($salesInvoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesInvoice, true), gettype($salesInvoice)), __LINE__);
        }
        if (is_null($salesInvoice) || (is_array($salesInvoice) && empty($salesInvoice))) {
            unset($this->SalesInvoice);
        } else {
            $this->SalesInvoice = $salesInvoice;
        }
        return $this;
    }
    /**
     * Get ServiceId value
     * @return string|null
     */
    public function getServiceId()
    {
        return $this->ServiceId;
    }
    /**
     * Set ServiceId value
     * @param string $serviceId
     * @return \StructType\Service
     */
    public function setServiceId($serviceId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceId) && !is_string($serviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceId, true), gettype($serviceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($serviceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $serviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($serviceId, true)), __LINE__);
        }
        $this->ServiceId = $serviceId;
        return $this;
    }
    /**
     * Get SourceUnitsExcluded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceUnitsExcluded()
    {
        return isset($this->SourceUnitsExcluded) ? $this->SourceUnitsExcluded : null;
    }
    /**
     * Set SourceUnitsExcluded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceUnitsExcluded
     * @return \StructType\Service
     */
    public function setSourceUnitsExcluded($sourceUnitsExcluded = null)
    {
        // validation for constraint: string
        if (!is_null($sourceUnitsExcluded) && !is_string($sourceUnitsExcluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceUnitsExcluded, true), gettype($sourceUnitsExcluded)), __LINE__);
        }
        if (is_null($sourceUnitsExcluded) || (is_array($sourceUnitsExcluded) && empty($sourceUnitsExcluded))) {
            unset($this->SourceUnitsExcluded);
        } else {
            $this->SourceUnitsExcluded = $sourceUnitsExcluded;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\Service
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get TargetUnitsExcluded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetUnitsExcluded()
    {
        return isset($this->TargetUnitsExcluded) ? $this->TargetUnitsExcluded : null;
    }
    /**
     * Set TargetUnitsExcluded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetUnitsExcluded
     * @return \StructType\Service
     */
    public function setTargetUnitsExcluded($targetUnitsExcluded = null)
    {
        // validation for constraint: string
        if (!is_null($targetUnitsExcluded) && !is_string($targetUnitsExcluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetUnitsExcluded, true), gettype($targetUnitsExcluded)), __LINE__);
        }
        if (is_null($targetUnitsExcluded) || (is_array($targetUnitsExcluded) && empty($targetUnitsExcluded))) {
            unset($this->TargetUnitsExcluded);
        } else {
            $this->TargetUnitsExcluded = $targetUnitsExcluded;
        }
        return $this;
    }
    /**
     * Get ValidAllCustomers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidAllCustomers()
    {
        return isset($this->ValidAllCustomers) ? $this->ValidAllCustomers : null;
    }
    /**
     * Set ValidAllCustomers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validAllCustomers
     * @return \StructType\Service
     */
    public function setValidAllCustomers($validAllCustomers = null)
    {
        // validation for constraint: string
        if (!is_null($validAllCustomers) && !is_string($validAllCustomers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validAllCustomers, true), gettype($validAllCustomers)), __LINE__);
        }
        if (is_null($validAllCustomers) || (is_array($validAllCustomers) && empty($validAllCustomers))) {
            unset($this->ValidAllCustomers);
        } else {
            $this->ValidAllCustomers = $validAllCustomers;
        }
        return $this;
    }
    /**
     * Get ValidAllSectors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidAllSectors()
    {
        return isset($this->ValidAllSectors) ? $this->ValidAllSectors : null;
    }
    /**
     * Set ValidAllSectors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validAllSectors
     * @return \StructType\Service
     */
    public function setValidAllSectors($validAllSectors = null)
    {
        // validation for constraint: string
        if (!is_null($validAllSectors) && !is_string($validAllSectors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validAllSectors, true), gettype($validAllSectors)), __LINE__);
        }
        if (is_null($validAllSectors) || (is_array($validAllSectors) && empty($validAllSectors))) {
            unset($this->ValidAllSectors);
        } else {
            $this->ValidAllSectors = $validAllSectors;
        }
        return $this;
    }
    /**
     * Get ValidAllSourceUnits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidAllSourceUnits()
    {
        return isset($this->ValidAllSourceUnits) ? $this->ValidAllSourceUnits : null;
    }
    /**
     * Set ValidAllSourceUnits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validAllSourceUnits
     * @return \StructType\Service
     */
    public function setValidAllSourceUnits($validAllSourceUnits = null)
    {
        // validation for constraint: string
        if (!is_null($validAllSourceUnits) && !is_string($validAllSourceUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validAllSourceUnits, true), gettype($validAllSourceUnits)), __LINE__);
        }
        if (is_null($validAllSourceUnits) || (is_array($validAllSourceUnits) && empty($validAllSourceUnits))) {
            unset($this->ValidAllSourceUnits);
        } else {
            $this->ValidAllSourceUnits = $validAllSourceUnits;
        }
        return $this;
    }
    /**
     * Get ValidAllTargetUnits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidAllTargetUnits()
    {
        return isset($this->ValidAllTargetUnits) ? $this->ValidAllTargetUnits : null;
    }
    /**
     * Set ValidAllTargetUnits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validAllTargetUnits
     * @return \StructType\Service
     */
    public function setValidAllTargetUnits($validAllTargetUnits = null)
    {
        // validation for constraint: string
        if (!is_null($validAllTargetUnits) && !is_string($validAllTargetUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validAllTargetUnits, true), gettype($validAllTargetUnits)), __LINE__);
        }
        if (is_null($validAllTargetUnits) || (is_array($validAllTargetUnits) && empty($validAllTargetUnits))) {
            unset($this->ValidAllTargetUnits);
        } else {
            $this->ValidAllTargetUnits = $validAllTargetUnits;
        }
        return $this;
    }
    /**
     * Get ValidTargetSameCities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidTargetSameCities()
    {
        return isset($this->ValidTargetSameCities) ? $this->ValidTargetSameCities : null;
    }
    /**
     * Set ValidTargetSameCities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validTargetSameCities
     * @return \StructType\Service
     */
    public function setValidTargetSameCities($validTargetSameCities = null)
    {
        // validation for constraint: string
        if (!is_null($validTargetSameCities) && !is_string($validTargetSameCities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validTargetSameCities, true), gettype($validTargetSameCities)), __LINE__);
        }
        if (is_null($validTargetSameCities) || (is_array($validTargetSameCities) && empty($validTargetSameCities))) {
            unset($this->ValidTargetSameCities);
        } else {
            $this->ValidTargetSameCities = $validTargetSameCities;
        }
        return $this;
    }
    /**
     * Get Vatrate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVatrate()
    {
        return isset($this->Vatrate) ? $this->Vatrate : null;
    }
    /**
     * Set Vatrate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $vatrate
     * @return \StructType\Service
     */
    public function setVatrate($vatrate = null)
    {
        // validation for constraint: float
        if (!is_null($vatrate) && !(is_float($vatrate) || is_numeric($vatrate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vatrate, true), gettype($vatrate)), __LINE__);
        }
        if (is_null($vatrate) || (is_array($vatrate) && empty($vatrate))) {
            unset($this->Vatrate);
        } else {
            $this->Vatrate = $vatrate;
        }
        return $this;
    }
    /**
     * Get WorldwideIns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorldwideIns()
    {
        return isset($this->WorldwideIns) ? $this->WorldwideIns : null;
    }
    /**
     * Set WorldwideIns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $worldwideIns
     * @return \StructType\Service
     */
    public function setWorldwideIns($worldwideIns = null)
    {
        // validation for constraint: string
        if (!is_null($worldwideIns) && !is_string($worldwideIns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($worldwideIns, true), gettype($worldwideIns)), __LINE__);
        }
        if (is_null($worldwideIns) || (is_array($worldwideIns) && empty($worldwideIns))) {
            unset($this->WorldwideIns);
        } else {
            $this->WorldwideIns = $worldwideIns;
        }
        return $this;
    }
    /**
     * Get WorldwideInsFixedPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getWorldwideInsFixedPrice()
    {
        return isset($this->WorldwideInsFixedPrice) ? $this->WorldwideInsFixedPrice : null;
    }
    /**
     * Set WorldwideInsFixedPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $worldwideInsFixedPrice
     * @return \StructType\Service
     */
    public function setWorldwideInsFixedPrice($worldwideInsFixedPrice = null)
    {
        // validation for constraint: float
        if (!is_null($worldwideInsFixedPrice) && !(is_float($worldwideInsFixedPrice) || is_numeric($worldwideInsFixedPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($worldwideInsFixedPrice, true), gettype($worldwideInsFixedPrice)), __LINE__);
        }
        if (is_null($worldwideInsFixedPrice) || (is_array($worldwideInsFixedPrice) && empty($worldwideInsFixedPrice))) {
            unset($this->WorldwideInsFixedPrice);
        } else {
            $this->WorldwideInsFixedPrice = $worldwideInsFixedPrice;
        }
        return $this;
    }
    /**
     * Get WorldwideInsLovCurrencyTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWorldwideInsLovCurrencyTypeId()
    {
        return isset($this->WorldwideInsLovCurrencyTypeId) ? $this->WorldwideInsLovCurrencyTypeId : null;
    }
    /**
     * Set WorldwideInsLovCurrencyTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $worldwideInsLovCurrencyTypeId
     * @return \StructType\Service
     */
    public function setWorldwideInsLovCurrencyTypeId($worldwideInsLovCurrencyTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($worldwideInsLovCurrencyTypeId) && !(is_int($worldwideInsLovCurrencyTypeId) || ctype_digit($worldwideInsLovCurrencyTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($worldwideInsLovCurrencyTypeId, true), gettype($worldwideInsLovCurrencyTypeId)), __LINE__);
        }
        if (is_null($worldwideInsLovCurrencyTypeId) || (is_array($worldwideInsLovCurrencyTypeId) && empty($worldwideInsLovCurrencyTypeId))) {
            unset($this->WorldwideInsLovCurrencyTypeId);
        } else {
            $this->WorldwideInsLovCurrencyTypeId = $worldwideInsLovCurrencyTypeId;
        }
        return $this;
    }
    /**
     * Get WorldwideInsMaxPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getWorldwideInsMaxPrice()
    {
        return isset($this->WorldwideInsMaxPrice) ? $this->WorldwideInsMaxPrice : null;
    }
    /**
     * Set WorldwideInsMaxPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $worldwideInsMaxPrice
     * @return \StructType\Service
     */
    public function setWorldwideInsMaxPrice($worldwideInsMaxPrice = null)
    {
        // validation for constraint: float
        if (!is_null($worldwideInsMaxPrice) && !(is_float($worldwideInsMaxPrice) || is_numeric($worldwideInsMaxPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($worldwideInsMaxPrice, true), gettype($worldwideInsMaxPrice)), __LINE__);
        }
        if (is_null($worldwideInsMaxPrice) || (is_array($worldwideInsMaxPrice) && empty($worldwideInsMaxPrice))) {
            unset($this->WorldwideInsMaxPrice);
        } else {
            $this->WorldwideInsMaxPrice = $worldwideInsMaxPrice;
        }
        return $this;
    }
    /**
     * Get WorldwideInsRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWorldwideInsRate()
    {
        return isset($this->WorldwideInsRate) ? $this->WorldwideInsRate : null;
    }
    /**
     * Set WorldwideInsRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $worldwideInsRate
     * @return \StructType\Service
     */
    public function setWorldwideInsRate($worldwideInsRate = null)
    {
        // validation for constraint: int
        if (!is_null($worldwideInsRate) && !(is_int($worldwideInsRate) || ctype_digit($worldwideInsRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($worldwideInsRate, true), gettype($worldwideInsRate)), __LINE__);
        }
        if (is_null($worldwideInsRate) || (is_array($worldwideInsRate) && empty($worldwideInsRate))) {
            unset($this->WorldwideInsRate);
        } else {
            $this->WorldwideInsRate = $worldwideInsRate;
        }
        return $this;
    }
}
