<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MPExtProductModel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MPExtProductModel
 * @subpackage Structs
 */
class MPExtProductModel extends AbstractStructBase
{
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Count;
    /**
     * The ServiceCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceCode;
    /**
     * Constructor method for MPExtProductModel
     * @uses MPExtProductModel::setCount()
     * @uses MPExtProductModel::setServiceCode()
     * @param string $count
     * @param string $serviceCode
     */
    public function __construct($count = null, $serviceCode = null)
    {
        $this
            ->setCount($count)
            ->setServiceCode($serviceCode);
    }
    /**
     * Get Count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCount()
    {
        return isset($this->Count) ? $this->Count : null;
    }
    /**
     * Set Count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $count
     * @return \StructType\MPExtProductModel
     */
    public function setCount($count = null)
    {
        // validation for constraint: string
        if (!is_null($count) && !is_string($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        if (is_null($count) || (is_array($count) && empty($count))) {
            unset($this->Count);
        } else {
            $this->Count = $count;
        }
        return $this;
    }
    /**
     * Get ServiceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceCode()
    {
        return isset($this->ServiceCode) ? $this->ServiceCode : null;
    }
    /**
     * Set ServiceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceCode
     * @return \StructType\MPExtProductModel
     */
    public function setServiceCode($serviceCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceCode) && !is_string($serviceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceCode, true), gettype($serviceCode)), __LINE__);
        }
        if (is_null($serviceCode) || (is_array($serviceCode) && empty($serviceCode))) {
            unset($this->ServiceCode);
        } else {
            $this->ServiceCode = $serviceCode;
        }
        return $this;
    }
}
