<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetOrderListByDate StructType
 * @subpackage Structs
 */
class GetOrderListByDate extends AbstractStructBase
{
    /**
     * The date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $date;
    /**
     * The customerInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerInfo
     */
    public $customerInfo;
    /**
     * Constructor method for GetOrderListByDate
     * @uses GetOrderListByDate::setDate()
     * @uses GetOrderListByDate::setCustomerInfo()
     * @param string $date
     * @param \StructType\CustomerInfo $customerInfo
     */
    public function __construct($date = null, \StructType\CustomerInfo $customerInfo = null)
    {
        $this
            ->setDate($date)
            ->setCustomerInfo($customerInfo);
    }
    /**
     * Get date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDate()
    {
        return isset($this->date) ? $this->date : null;
    }
    /**
     * Set date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $date
     * @return \StructType\GetOrderListByDate
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->date);
        } else {
            $this->date = $date;
        }
        return $this;
    }
    /**
     * Get customerInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerInfo|null
     */
    public function getCustomerInfo()
    {
        return isset($this->customerInfo) ? $this->customerInfo : null;
    }
    /**
     * Set customerInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CustomerInfo $customerInfo
     * @return \StructType\GetOrderListByDate
     */
    public function setCustomerInfo(\StructType\CustomerInfo $customerInfo = null)
    {
        if (is_null($customerInfo) || (is_array($customerInfo) && empty($customerInfo))) {
            unset($this->customerInfo);
        } else {
            $this->customerInfo = $customerInfo;
        }
        return $this;
    }
}
