<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArasMPOrderGetOrderListByOrderCode StructType
 * @subpackage Structs
 */
class ArasMPOrderGetOrderListByOrderCode extends AbstractStructBase
{
    /**
     * The orderCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $orderCode;
    /**
     * The customerInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerInfo
     */
    public $customerInfo;
    /**
     * Constructor method for ArasMPOrderGetOrderListByOrderCode
     * @uses ArasMPOrderGetOrderListByOrderCode::setOrderCode()
     * @uses ArasMPOrderGetOrderListByOrderCode::setCustomerInfo()
     * @param string $orderCode
     * @param \StructType\CustomerInfo $customerInfo
     */
    public function __construct($orderCode = null, \StructType\CustomerInfo $customerInfo = null)
    {
        $this
            ->setOrderCode($orderCode)
            ->setCustomerInfo($customerInfo);
    }
    /**
     * Get orderCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderCode()
    {
        return isset($this->orderCode) ? $this->orderCode : null;
    }
    /**
     * Set orderCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderCode
     * @return \StructType\ArasMPOrderGetOrderListByOrderCode
     */
    public function setOrderCode($orderCode = null)
    {
        // validation for constraint: string
        if (!is_null($orderCode) && !is_string($orderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderCode, true), gettype($orderCode)), __LINE__);
        }
        if (is_null($orderCode) || (is_array($orderCode) && empty($orderCode))) {
            unset($this->orderCode);
        } else {
            $this->orderCode = $orderCode;
        }
        return $this;
    }
    /**
     * Get customerInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerInfo|null
     */
    public function getCustomerInfo()
    {
        return isset($this->customerInfo) ? $this->customerInfo : null;
    }
    /**
     * Set customerInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CustomerInfo $customerInfo
     * @return \StructType\ArasMPOrderGetOrderListByOrderCode
     */
    public function setCustomerInfo(\StructType\CustomerInfo $customerInfo = null)
    {
        if (is_null($customerInfo) || (is_array($customerInfo) && empty($customerInfo))) {
            unset($this->customerInfo);
        } else {
            $this->customerInfo = $customerInfo;
        }
        return $this;
    }
}
