<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for MPG ServiceType
 * @subpackage Services
 */
class MPG extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MPGetOrderListByDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MPGetOrderListByDate $parameters
     * @return \StructType\MPGetOrderListByDateResponse|bool
     */
    public function MPGetOrderListByDate(\StructType\MPGetOrderListByDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MPGetOrderListByDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MPGetOrderListByDateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
