<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://integrationtest.araskargo.com.tr/mpordertest/IntegrationService.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://integrationtest.araskargo.com.tr/mpordertest/IntegrationService.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Save ServiceType
 */
$save = new \ServiceType\Save($options);
/**
 * Sample call for SaveOrder operation/method
 */
if ($save->SaveOrder(new \StructType\SaveOrder()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for SaveOrderHeader operation/method
 */
if ($save->SaveOrderHeader(new \StructType\SaveOrderHeader()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for SaveOrderHeaderMPOrder operation/method
 */
if ($save->SaveOrderHeaderMPOrder(new \StructType\SaveOrderHeaderMPOrder()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Samples for Aras ServiceType
 */
$aras = new \ServiceType\Aras($options);
/**
 * Sample call for ArasMPOrder operation/method
 */
if ($aras->ArasMPOrder(new \StructType\ArasMPOrder()) !== false) {
    print_r($aras->getResult());
} else {
    print_r($aras->getLastError());
}
/**
 * Sample call for ArasMPOrderUpdate operation/method
 */
if ($aras->ArasMPOrderUpdate(new \StructType\ArasMPOrderUpdate()) !== false) {
    print_r($aras->getResult());
} else {
    print_r($aras->getLastError());
}
/**
 * Sample call for ArasMPOrderDelete operation/method
 */
if ($aras->ArasMPOrderDelete(new \StructType\ArasMPOrderDelete()) !== false) {
    print_r($aras->getResult());
} else {
    print_r($aras->getLastError());
}
/**
 * Sample call for ArasMPOrderGetOrderListByOrderCode operation/method
 */
if ($aras->ArasMPOrderGetOrderListByOrderCode(new \StructType\ArasMPOrderGetOrderListByOrderCode()) !== false) {
    print_r($aras->getResult());
} else {
    print_r($aras->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for UpdateOrder operation/method
 */
if ($update->UpdateOrder(new \StructType\UpdateOrder()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for DeleteOrder operation/method
 */
if ($delete->DeleteOrder(new \StructType\DeleteOrder()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetOrderListByDate operation/method
 */
if ($get->GetOrderListByDate(new \StructType\GetOrderListByDate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrderListByOrderCode operation/method
 */
if ($get->GetOrderListByOrderCode(new \StructType\GetOrderListByOrderCode()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for MPG ServiceType
 */
$mPG = new \ServiceType\MPG($options);
/**
 * Sample call for MPGetOrderListByDate operation/method
 */
if ($mPG->MPGetOrderListByDate(new \StructType\MPGetOrderListByDate()) !== false) {
    print_r($mPG->getResult());
} else {
    print_r($mPG->getLastError());
}
