<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HintTown StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:HintTown
 * @subpackage Structs
 */
class HintTown extends AbstractStructBase
{
    /**
     * The ApplicationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ApplicationId;
    /**
     * The ApplicationVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationVersion;
    /**
     * The AuditCreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditCreateDate;
    /**
     * The AuditCreateUnitId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditCreateUnitId;
    /**
     * The AuditCreatedBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditCreatedBy;
    /**
     * The AuditDeleted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditDeleted;
    /**
     * The AuditModifiedBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditModifiedBy;
    /**
     * The AuditModifyDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditModifyDate;
    /**
     * The AuditModifyUnitId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditModifyUnitId;
    /**
     * The DM_OldCityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DM_OldCityId;
    /**
     * The DM_OldTownId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DM_OldTownId;
    /**
     * The HintCity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HintCity
     */
    public $HintCity;
    /**
     * The HintCountry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HintCountry
     */
    public $HintCountry;
    /**
     * The HintTownId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HintTownId;
    /**
     * The Town
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Town;
    /**
     * Constructor method for HintTown
     * @uses HintTown::setApplicationId()
     * @uses HintTown::setApplicationVersion()
     * @uses HintTown::setAuditCreateDate()
     * @uses HintTown::setAuditCreateUnitId()
     * @uses HintTown::setAuditCreatedBy()
     * @uses HintTown::setAuditDeleted()
     * @uses HintTown::setAuditModifiedBy()
     * @uses HintTown::setAuditModifyDate()
     * @uses HintTown::setAuditModifyUnitId()
     * @uses HintTown::setDM_OldCityId()
     * @uses HintTown::setDM_OldTownId()
     * @uses HintTown::setHintCity()
     * @uses HintTown::setHintCountry()
     * @uses HintTown::setHintTownId()
     * @uses HintTown::setTown()
     * @param int $applicationId
     * @param string $applicationVersion
     * @param string $auditCreateDate
     * @param int $auditCreateUnitId
     * @param int $auditCreatedBy
     * @param string $auditDeleted
     * @param int $auditModifiedBy
     * @param string $auditModifyDate
     * @param int $auditModifyUnitId
     * @param string $dM_OldCityId
     * @param string $dM_OldTownId
     * @param \StructType\HintCity $hintCity
     * @param \StructType\HintCountry $hintCountry
     * @param string $hintTownId
     * @param string $town
     */
    public function __construct($applicationId = null, $applicationVersion = null, $auditCreateDate = null, $auditCreateUnitId = null, $auditCreatedBy = null, $auditDeleted = null, $auditModifiedBy = null, $auditModifyDate = null, $auditModifyUnitId = null, $dM_OldCityId = null, $dM_OldTownId = null, \StructType\HintCity $hintCity = null, \StructType\HintCountry $hintCountry = null, $hintTownId = null, $town = null)
    {
        $this
            ->setApplicationId($applicationId)
            ->setApplicationVersion($applicationVersion)
            ->setAuditCreateDate($auditCreateDate)
            ->setAuditCreateUnitId($auditCreateUnitId)
            ->setAuditCreatedBy($auditCreatedBy)
            ->setAuditDeleted($auditDeleted)
            ->setAuditModifiedBy($auditModifiedBy)
            ->setAuditModifyDate($auditModifyDate)
            ->setAuditModifyUnitId($auditModifyUnitId)
            ->setDM_OldCityId($dM_OldCityId)
            ->setDM_OldTownId($dM_OldTownId)
            ->setHintCity($hintCity)
            ->setHintCountry($hintCountry)
            ->setHintTownId($hintTownId)
            ->setTown($town);
    }
    /**
     * Get ApplicationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getApplicationId()
    {
        return isset($this->ApplicationId) ? $this->ApplicationId : null;
    }
    /**
     * Set ApplicationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $applicationId
     * @return \StructType\HintTown
     */
    public function setApplicationId($applicationId = null)
    {
        // validation for constraint: int
        if (!is_null($applicationId) && !(is_int($applicationId) || ctype_digit($applicationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($applicationId, true), gettype($applicationId)), __LINE__);
        }
        if (is_null($applicationId) || (is_array($applicationId) && empty($applicationId))) {
            unset($this->ApplicationId);
        } else {
            $this->ApplicationId = $applicationId;
        }
        return $this;
    }
    /**
     * Get ApplicationVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationVersion()
    {
        return isset($this->ApplicationVersion) ? $this->ApplicationVersion : null;
    }
    /**
     * Set ApplicationVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationVersion
     * @return \StructType\HintTown
     */
    public function setApplicationVersion($applicationVersion = null)
    {
        // validation for constraint: string
        if (!is_null($applicationVersion) && !is_string($applicationVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationVersion, true), gettype($applicationVersion)), __LINE__);
        }
        if (is_null($applicationVersion) || (is_array($applicationVersion) && empty($applicationVersion))) {
            unset($this->ApplicationVersion);
        } else {
            $this->ApplicationVersion = $applicationVersion;
        }
        return $this;
    }
    /**
     * Get AuditCreateDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditCreateDate()
    {
        return isset($this->AuditCreateDate) ? $this->AuditCreateDate : null;
    }
    /**
     * Set AuditCreateDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditCreateDate
     * @return \StructType\HintTown
     */
    public function setAuditCreateDate($auditCreateDate = null)
    {
        // validation for constraint: string
        if (!is_null($auditCreateDate) && !is_string($auditCreateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditCreateDate, true), gettype($auditCreateDate)), __LINE__);
        }
        if (is_null($auditCreateDate) || (is_array($auditCreateDate) && empty($auditCreateDate))) {
            unset($this->AuditCreateDate);
        } else {
            $this->AuditCreateDate = $auditCreateDate;
        }
        return $this;
    }
    /**
     * Get AuditCreateUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditCreateUnitId()
    {
        return isset($this->AuditCreateUnitId) ? $this->AuditCreateUnitId : null;
    }
    /**
     * Set AuditCreateUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditCreateUnitId
     * @return \StructType\HintTown
     */
    public function setAuditCreateUnitId($auditCreateUnitId = null)
    {
        // validation for constraint: int
        if (!is_null($auditCreateUnitId) && !(is_int($auditCreateUnitId) || ctype_digit($auditCreateUnitId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditCreateUnitId, true), gettype($auditCreateUnitId)), __LINE__);
        }
        if (is_null($auditCreateUnitId) || (is_array($auditCreateUnitId) && empty($auditCreateUnitId))) {
            unset($this->AuditCreateUnitId);
        } else {
            $this->AuditCreateUnitId = $auditCreateUnitId;
        }
        return $this;
    }
    /**
     * Get AuditCreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditCreatedBy()
    {
        return isset($this->AuditCreatedBy) ? $this->AuditCreatedBy : null;
    }
    /**
     * Set AuditCreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditCreatedBy
     * @return \StructType\HintTown
     */
    public function setAuditCreatedBy($auditCreatedBy = null)
    {
        // validation for constraint: int
        if (!is_null($auditCreatedBy) && !(is_int($auditCreatedBy) || ctype_digit($auditCreatedBy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditCreatedBy, true), gettype($auditCreatedBy)), __LINE__);
        }
        if (is_null($auditCreatedBy) || (is_array($auditCreatedBy) && empty($auditCreatedBy))) {
            unset($this->AuditCreatedBy);
        } else {
            $this->AuditCreatedBy = $auditCreatedBy;
        }
        return $this;
    }
    /**
     * Get AuditDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditDeleted()
    {
        return isset($this->AuditDeleted) ? $this->AuditDeleted : null;
    }
    /**
     * Set AuditDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditDeleted
     * @return \StructType\HintTown
     */
    public function setAuditDeleted($auditDeleted = null)
    {
        // validation for constraint: string
        if (!is_null($auditDeleted) && !is_string($auditDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditDeleted, true), gettype($auditDeleted)), __LINE__);
        }
        if (is_null($auditDeleted) || (is_array($auditDeleted) && empty($auditDeleted))) {
            unset($this->AuditDeleted);
        } else {
            $this->AuditDeleted = $auditDeleted;
        }
        return $this;
    }
    /**
     * Get AuditModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditModifiedBy()
    {
        return isset($this->AuditModifiedBy) ? $this->AuditModifiedBy : null;
    }
    /**
     * Set AuditModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditModifiedBy
     * @return \StructType\HintTown
     */
    public function setAuditModifiedBy($auditModifiedBy = null)
    {
        // validation for constraint: int
        if (!is_null($auditModifiedBy) && !(is_int($auditModifiedBy) || ctype_digit($auditModifiedBy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditModifiedBy, true), gettype($auditModifiedBy)), __LINE__);
        }
        if (is_null($auditModifiedBy) || (is_array($auditModifiedBy) && empty($auditModifiedBy))) {
            unset($this->AuditModifiedBy);
        } else {
            $this->AuditModifiedBy = $auditModifiedBy;
        }
        return $this;
    }
    /**
     * Get AuditModifyDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditModifyDate()
    {
        return isset($this->AuditModifyDate) ? $this->AuditModifyDate : null;
    }
    /**
     * Set AuditModifyDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditModifyDate
     * @return \StructType\HintTown
     */
    public function setAuditModifyDate($auditModifyDate = null)
    {
        // validation for constraint: string
        if (!is_null($auditModifyDate) && !is_string($auditModifyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditModifyDate, true), gettype($auditModifyDate)), __LINE__);
        }
        if (is_null($auditModifyDate) || (is_array($auditModifyDate) && empty($auditModifyDate))) {
            unset($this->AuditModifyDate);
        } else {
            $this->AuditModifyDate = $auditModifyDate;
        }
        return $this;
    }
    /**
     * Get AuditModifyUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditModifyUnitId()
    {
        return isset($this->AuditModifyUnitId) ? $this->AuditModifyUnitId : null;
    }
    /**
     * Set AuditModifyUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditModifyUnitId
     * @return \StructType\HintTown
     */
    public function setAuditModifyUnitId($auditModifyUnitId = null)
    {
        // validation for constraint: int
        if (!is_null($auditModifyUnitId) && !(is_int($auditModifyUnitId) || ctype_digit($auditModifyUnitId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditModifyUnitId, true), gettype($auditModifyUnitId)), __LINE__);
        }
        if (is_null($auditModifyUnitId) || (is_array($auditModifyUnitId) && empty($auditModifyUnitId))) {
            unset($this->AuditModifyUnitId);
        } else {
            $this->AuditModifyUnitId = $auditModifyUnitId;
        }
        return $this;
    }
    /**
     * Get DM_OldCityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDM_OldCityId()
    {
        return isset($this->DM_OldCityId) ? $this->DM_OldCityId : null;
    }
    /**
     * Set DM_OldCityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dM_OldCityId
     * @return \StructType\HintTown
     */
    public function setDM_OldCityId($dM_OldCityId = null)
    {
        // validation for constraint: string
        if (!is_null($dM_OldCityId) && !is_string($dM_OldCityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dM_OldCityId, true), gettype($dM_OldCityId)), __LINE__);
        }
        if (is_null($dM_OldCityId) || (is_array($dM_OldCityId) && empty($dM_OldCityId))) {
            unset($this->DM_OldCityId);
        } else {
            $this->DM_OldCityId = $dM_OldCityId;
        }
        return $this;
    }
    /**
     * Get DM_OldTownId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDM_OldTownId()
    {
        return isset($this->DM_OldTownId) ? $this->DM_OldTownId : null;
    }
    /**
     * Set DM_OldTownId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dM_OldTownId
     * @return \StructType\HintTown
     */
    public function setDM_OldTownId($dM_OldTownId = null)
    {
        // validation for constraint: string
        if (!is_null($dM_OldTownId) && !is_string($dM_OldTownId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dM_OldTownId, true), gettype($dM_OldTownId)), __LINE__);
        }
        if (is_null($dM_OldTownId) || (is_array($dM_OldTownId) && empty($dM_OldTownId))) {
            unset($this->DM_OldTownId);
        } else {
            $this->DM_OldTownId = $dM_OldTownId;
        }
        return $this;
    }
    /**
     * Get HintCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HintCity|null
     */
    public function getHintCity()
    {
        return isset($this->HintCity) ? $this->HintCity : null;
    }
    /**
     * Set HintCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\HintCity $hintCity
     * @return \StructType\HintTown
     */
    public function setHintCity(\StructType\HintCity $hintCity = null)
    {
        if (is_null($hintCity) || (is_array($hintCity) && empty($hintCity))) {
            unset($this->HintCity);
        } else {
            $this->HintCity = $hintCity;
        }
        return $this;
    }
    /**
     * Get HintCountry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HintCountry|null
     */
    public function getHintCountry()
    {
        return isset($this->HintCountry) ? $this->HintCountry : null;
    }
    /**
     * Set HintCountry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\HintCountry $hintCountry
     * @return \StructType\HintTown
     */
    public function setHintCountry(\StructType\HintCountry $hintCountry = null)
    {
        if (is_null($hintCountry) || (is_array($hintCountry) && empty($hintCountry))) {
            unset($this->HintCountry);
        } else {
            $this->HintCountry = $hintCountry;
        }
        return $this;
    }
    /**
     * Get HintTownId value
     * @return string|null
     */
    public function getHintTownId()
    {
        return $this->HintTownId;
    }
    /**
     * Set HintTownId value
     * @param string $hintTownId
     * @return \StructType\HintTown
     */
    public function setHintTownId($hintTownId = null)
    {
        // validation for constraint: string
        if (!is_null($hintTownId) && !is_string($hintTownId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hintTownId, true), gettype($hintTownId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hintTownId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hintTownId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hintTownId, true)), __LINE__);
        }
        $this->HintTownId = $hintTownId;
        return $this;
    }
    /**
     * Get Town value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTown()
    {
        return isset($this->Town) ? $this->Town : null;
    }
    /**
     * Set Town value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $town
     * @return \StructType\HintTown
     */
    public function setTown($town = null)
    {
        // validation for constraint: string
        if (!is_null($town) && !is_string($town)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($town, true), gettype($town)), __LINE__);
        }
        if (is_null($town) || (is_array($town) && empty($town))) {
            unset($this->Town);
        } else {
            $this->Town = $town;
        }
        return $this;
    }
}
