<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetOrderListByDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderListByDate $parameters
     * @return \StructType\GetOrderListByDateResponse|bool
     */
    public function GetOrderListByDate(\StructType\GetOrderListByDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderListByDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderListByOrderCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderListByOrderCode $parameters
     * @return \StructType\GetOrderListByOrderCodeResponse|bool
     */
    public function GetOrderListByOrderCode(\StructType\GetOrderListByOrderCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderListByOrderCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetOrderListByDateResponse|\StructType\GetOrderListByOrderCodeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
