<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderInfoResponseModel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OrderInfoResponseModel
 * @subpackage Structs
 */
class OrderInfoResponseModel extends AbstractStructBase
{
    /**
     * The OrderInfoViewModel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderInfoViewModel
     */
    public $OrderInfoViewModel;
    /**
     * The ResultInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ResultInfo
     */
    public $ResultInfo;
    /**
     * Constructor method for OrderInfoResponseModel
     * @uses OrderInfoResponseModel::setOrderInfoViewModel()
     * @uses OrderInfoResponseModel::setResultInfo()
     * @param \StructType\OrderInfoViewModel $orderInfoViewModel
     * @param \StructType\ResultInfo $resultInfo
     */
    public function __construct(\StructType\OrderInfoViewModel $orderInfoViewModel = null, \StructType\ResultInfo $resultInfo = null)
    {
        $this
            ->setOrderInfoViewModel($orderInfoViewModel)
            ->setResultInfo($resultInfo);
    }
    /**
     * Get OrderInfoViewModel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderInfoViewModel|null
     */
    public function getOrderInfoViewModel()
    {
        return isset($this->OrderInfoViewModel) ? $this->OrderInfoViewModel : null;
    }
    /**
     * Set OrderInfoViewModel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OrderInfoViewModel $orderInfoViewModel
     * @return \StructType\OrderInfoResponseModel
     */
    public function setOrderInfoViewModel(\StructType\OrderInfoViewModel $orderInfoViewModel = null)
    {
        if (is_null($orderInfoViewModel) || (is_array($orderInfoViewModel) && empty($orderInfoViewModel))) {
            unset($this->OrderInfoViewModel);
        } else {
            $this->OrderInfoViewModel = $orderInfoViewModel;
        }
        return $this;
    }
    /**
     * Get ResultInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ResultInfo|null
     */
    public function getResultInfo()
    {
        return isset($this->ResultInfo) ? $this->ResultInfo : null;
    }
    /**
     * Set ResultInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ResultInfo $resultInfo
     * @return \StructType\OrderInfoResponseModel
     */
    public function setResultInfo(\StructType\ResultInfo $resultInfo = null)
    {
        if (is_null($resultInfo) || (is_array($resultInfo) && empty($resultInfo))) {
            unset($this->ResultInfo);
        } else {
            $this->ResultInfo = $resultInfo;
        }
        return $this;
    }
}
