<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderHeaderModel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OrderHeaderModel
 * @subpackage Structs
 */
class OrderHeaderModel extends AbstractStructBase
{
    /**
     * The CustomerIntegrationModel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerIntegrationModel
     */
    public $CustomerIntegrationModel;
    /**
     * The OrderInfoHeader
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderInfoHeader
     */
    public $OrderInfoHeader;
    /**
     * The OrderInfoHeaderServiceList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfOrderInfoHeaderService
     */
    public $OrderInfoHeaderServiceList;
    /**
     * Constructor method for OrderHeaderModel
     * @uses OrderHeaderModel::setCustomerIntegrationModel()
     * @uses OrderHeaderModel::setOrderInfoHeader()
     * @uses OrderHeaderModel::setOrderInfoHeaderServiceList()
     * @param \StructType\CustomerIntegrationModel $customerIntegrationModel
     * @param \StructType\OrderInfoHeader $orderInfoHeader
     * @param \ArrayType\ArrayOfOrderInfoHeaderService $orderInfoHeaderServiceList
     */
    public function __construct(\StructType\CustomerIntegrationModel $customerIntegrationModel = null, \StructType\OrderInfoHeader $orderInfoHeader = null, \ArrayType\ArrayOfOrderInfoHeaderService $orderInfoHeaderServiceList = null)
    {
        $this
            ->setCustomerIntegrationModel($customerIntegrationModel)
            ->setOrderInfoHeader($orderInfoHeader)
            ->setOrderInfoHeaderServiceList($orderInfoHeaderServiceList);
    }
    /**
     * Get CustomerIntegrationModel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerIntegrationModel|null
     */
    public function getCustomerIntegrationModel()
    {
        return isset($this->CustomerIntegrationModel) ? $this->CustomerIntegrationModel : null;
    }
    /**
     * Set CustomerIntegrationModel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CustomerIntegrationModel $customerIntegrationModel
     * @return \StructType\OrderHeaderModel
     */
    public function setCustomerIntegrationModel(\StructType\CustomerIntegrationModel $customerIntegrationModel = null)
    {
        if (is_null($customerIntegrationModel) || (is_array($customerIntegrationModel) && empty($customerIntegrationModel))) {
            unset($this->CustomerIntegrationModel);
        } else {
            $this->CustomerIntegrationModel = $customerIntegrationModel;
        }
        return $this;
    }
    /**
     * Get OrderInfoHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderInfoHeader|null
     */
    public function getOrderInfoHeader()
    {
        return isset($this->OrderInfoHeader) ? $this->OrderInfoHeader : null;
    }
    /**
     * Set OrderInfoHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OrderInfoHeader $orderInfoHeader
     * @return \StructType\OrderHeaderModel
     */
    public function setOrderInfoHeader(\StructType\OrderInfoHeader $orderInfoHeader = null)
    {
        if (is_null($orderInfoHeader) || (is_array($orderInfoHeader) && empty($orderInfoHeader))) {
            unset($this->OrderInfoHeader);
        } else {
            $this->OrderInfoHeader = $orderInfoHeader;
        }
        return $this;
    }
    /**
     * Get OrderInfoHeaderServiceList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfOrderInfoHeaderService|null
     */
    public function getOrderInfoHeaderServiceList()
    {
        return isset($this->OrderInfoHeaderServiceList) ? $this->OrderInfoHeaderServiceList : null;
    }
    /**
     * Set OrderInfoHeaderServiceList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfOrderInfoHeaderService $orderInfoHeaderServiceList
     * @return \StructType\OrderHeaderModel
     */
    public function setOrderInfoHeaderServiceList(\ArrayType\ArrayOfOrderInfoHeaderService $orderInfoHeaderServiceList = null)
    {
        if (is_null($orderInfoHeaderServiceList) || (is_array($orderInfoHeaderServiceList) && empty($orderInfoHeaderServiceList))) {
            unset($this->OrderInfoHeaderServiceList);
        } else {
            $this->OrderInfoHeaderServiceList = $orderInfoHeaderServiceList;
        }
        return $this;
    }
}
