<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerIntegrationModel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerIntegrationModel
 * @subpackage Structs
 */
class CustomerIntegrationModel extends AbstractStructBase
{
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AccountModel
     */
    public $Account;
    /**
     * The AccountAddressId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountAddressId;
    /**
     * The AccountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountName;
    /**
     * The AuditCreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditCreateDate;
    /**
     * The AuditCreatedBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditCreatedBy;
    /**
     * The AuditDeleted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditDeleted;
    /**
     * The AuditModifiedBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditModifiedBy;
    /**
     * The AuditModifyDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditModifyDate;
    /**
     * The CanUseWaybill
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CanUseWaybill;
    /**
     * The CanUseWaybillWeekend
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CanUseWaybillWeekend;
    /**
     * The ContactMail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContactMail;
    /**
     * The ContactName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContactName;
    /**
     * The ContactPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContactPhone;
    /**
     * The ContactPhone2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContactPhone2;
    /**
     * The ContactTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContactTitle;
    /**
     * The CustomerCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomerCode;
    /**
     * The CustomerIntegrationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CustomerIntegrationId;
    /**
     * The EndpointUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndpointUrl;
    /**
     * The IsAtAccepted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsAtAccepted;
    /**
     * The IsNotMeasuredAccepted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsNotMeasuredAccepted;
    /**
     * The IsPiecedAccepted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsPiecedAccepted;
    /**
     * The IsSequentialOperation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsSequentialOperation;
    /**
     * The IsVolumeAccepted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsVolumeAccepted;
    /**
     * The IsVolumeOptionalAccepted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsVolumeOptionalAccepted;
    /**
     * The LinkOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LinkOrder;
    /**
     * The LovIntegrationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LovIntegrationType
     */
    public $LovIntegrationType;
    /**
     * The LovSubIntegrationTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LovSubIntegrationTypeId;
    /**
     * The Param1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Param1;
    /**
     * The Param2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Param2;
    /**
     * The Param3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Param3;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The UnitCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UnitCode;
    /**
     * The UseAutoParser
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UseAutoParser;
    /**
     * The Username
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Username;
    /**
     * The WebMethodName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WebMethodName;
    /**
     * Constructor method for CustomerIntegrationModel
     * @uses CustomerIntegrationModel::setAccount()
     * @uses CustomerIntegrationModel::setAccountAddressId()
     * @uses CustomerIntegrationModel::setAccountName()
     * @uses CustomerIntegrationModel::setAuditCreateDate()
     * @uses CustomerIntegrationModel::setAuditCreatedBy()
     * @uses CustomerIntegrationModel::setAuditDeleted()
     * @uses CustomerIntegrationModel::setAuditModifiedBy()
     * @uses CustomerIntegrationModel::setAuditModifyDate()
     * @uses CustomerIntegrationModel::setCanUseWaybill()
     * @uses CustomerIntegrationModel::setCanUseWaybillWeekend()
     * @uses CustomerIntegrationModel::setContactMail()
     * @uses CustomerIntegrationModel::setContactName()
     * @uses CustomerIntegrationModel::setContactPhone()
     * @uses CustomerIntegrationModel::setContactPhone2()
     * @uses CustomerIntegrationModel::setContactTitle()
     * @uses CustomerIntegrationModel::setCustomerCode()
     * @uses CustomerIntegrationModel::setCustomerIntegrationId()
     * @uses CustomerIntegrationModel::setEndpointUrl()
     * @uses CustomerIntegrationModel::setIsAtAccepted()
     * @uses CustomerIntegrationModel::setIsNotMeasuredAccepted()
     * @uses CustomerIntegrationModel::setIsPiecedAccepted()
     * @uses CustomerIntegrationModel::setIsSequentialOperation()
     * @uses CustomerIntegrationModel::setIsVolumeAccepted()
     * @uses CustomerIntegrationModel::setIsVolumeOptionalAccepted()
     * @uses CustomerIntegrationModel::setLinkOrder()
     * @uses CustomerIntegrationModel::setLovIntegrationType()
     * @uses CustomerIntegrationModel::setLovSubIntegrationTypeId()
     * @uses CustomerIntegrationModel::setParam1()
     * @uses CustomerIntegrationModel::setParam2()
     * @uses CustomerIntegrationModel::setParam3()
     * @uses CustomerIntegrationModel::setPassword()
     * @uses CustomerIntegrationModel::setUnitCode()
     * @uses CustomerIntegrationModel::setUseAutoParser()
     * @uses CustomerIntegrationModel::setUsername()
     * @uses CustomerIntegrationModel::setWebMethodName()
     * @param \StructType\AccountModel $account
     * @param string $accountAddressId
     * @param string $accountName
     * @param string $auditCreateDate
     * @param int $auditCreatedBy
     * @param string $auditDeleted
     * @param int $auditModifiedBy
     * @param string $auditModifyDate
     * @param string $canUseWaybill
     * @param string $canUseWaybillWeekend
     * @param string $contactMail
     * @param string $contactName
     * @param string $contactPhone
     * @param string $contactPhone2
     * @param string $contactTitle
     * @param string $customerCode
     * @param string $customerIntegrationId
     * @param string $endpointUrl
     * @param string $isAtAccepted
     * @param string $isNotMeasuredAccepted
     * @param string $isPiecedAccepted
     * @param string $isSequentialOperation
     * @param string $isVolumeAccepted
     * @param string $isVolumeOptionalAccepted
     * @param int $linkOrder
     * @param \StructType\LovIntegrationType $lovIntegrationType
     * @param int $lovSubIntegrationTypeId
     * @param string $param1
     * @param string $param2
     * @param string $param3
     * @param string $password
     * @param string $unitCode
     * @param string $useAutoParser
     * @param string $username
     * @param string $webMethodName
     */
    public function __construct(\StructType\AccountModel $account = null, $accountAddressId = null, $accountName = null, $auditCreateDate = null, $auditCreatedBy = null, $auditDeleted = null, $auditModifiedBy = null, $auditModifyDate = null, $canUseWaybill = null, $canUseWaybillWeekend = null, $contactMail = null, $contactName = null, $contactPhone = null, $contactPhone2 = null, $contactTitle = null, $customerCode = null, $customerIntegrationId = null, $endpointUrl = null, $isAtAccepted = null, $isNotMeasuredAccepted = null, $isPiecedAccepted = null, $isSequentialOperation = null, $isVolumeAccepted = null, $isVolumeOptionalAccepted = null, $linkOrder = null, \StructType\LovIntegrationType $lovIntegrationType = null, $lovSubIntegrationTypeId = null, $param1 = null, $param2 = null, $param3 = null, $password = null, $unitCode = null, $useAutoParser = null, $username = null, $webMethodName = null)
    {
        $this
            ->setAccount($account)
            ->setAccountAddressId($accountAddressId)
            ->setAccountName($accountName)
            ->setAuditCreateDate($auditCreateDate)
            ->setAuditCreatedBy($auditCreatedBy)
            ->setAuditDeleted($auditDeleted)
            ->setAuditModifiedBy($auditModifiedBy)
            ->setAuditModifyDate($auditModifyDate)
            ->setCanUseWaybill($canUseWaybill)
            ->setCanUseWaybillWeekend($canUseWaybillWeekend)
            ->setContactMail($contactMail)
            ->setContactName($contactName)
            ->setContactPhone($contactPhone)
            ->setContactPhone2($contactPhone2)
            ->setContactTitle($contactTitle)
            ->setCustomerCode($customerCode)
            ->setCustomerIntegrationId($customerIntegrationId)
            ->setEndpointUrl($endpointUrl)
            ->setIsAtAccepted($isAtAccepted)
            ->setIsNotMeasuredAccepted($isNotMeasuredAccepted)
            ->setIsPiecedAccepted($isPiecedAccepted)
            ->setIsSequentialOperation($isSequentialOperation)
            ->setIsVolumeAccepted($isVolumeAccepted)
            ->setIsVolumeOptionalAccepted($isVolumeOptionalAccepted)
            ->setLinkOrder($linkOrder)
            ->setLovIntegrationType($lovIntegrationType)
            ->setLovSubIntegrationTypeId($lovSubIntegrationTypeId)
            ->setParam1($param1)
            ->setParam2($param2)
            ->setParam3($param3)
            ->setPassword($password)
            ->setUnitCode($unitCode)
            ->setUseAutoParser($useAutoParser)
            ->setUsername($username)
            ->setWebMethodName($webMethodName);
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AccountModel|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AccountModel $account
     * @return \StructType\CustomerIntegrationModel
     */
    public function setAccount(\StructType\AccountModel $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get AccountAddressId value
     * @return string|null
     */
    public function getAccountAddressId()
    {
        return $this->AccountAddressId;
    }
    /**
     * Set AccountAddressId value
     * @param string $accountAddressId
     * @return \StructType\CustomerIntegrationModel
     */
    public function setAccountAddressId($accountAddressId = null)
    {
        // validation for constraint: string
        if (!is_null($accountAddressId) && !is_string($accountAddressId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountAddressId, true), gettype($accountAddressId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountAddressId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountAddressId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountAddressId, true)), __LINE__);
        }
        $this->AccountAddressId = $accountAddressId;
        return $this;
    }
    /**
     * Get AccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountName()
    {
        return isset($this->AccountName) ? $this->AccountName : null;
    }
    /**
     * Set AccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountName
     * @return \StructType\CustomerIntegrationModel
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        if (is_null($accountName) || (is_array($accountName) && empty($accountName))) {
            unset($this->AccountName);
        } else {
            $this->AccountName = $accountName;
        }
        return $this;
    }
    /**
     * Get AuditCreateDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditCreateDate()
    {
        return isset($this->AuditCreateDate) ? $this->AuditCreateDate : null;
    }
    /**
     * Set AuditCreateDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditCreateDate
     * @return \StructType\CustomerIntegrationModel
     */
    public function setAuditCreateDate($auditCreateDate = null)
    {
        // validation for constraint: string
        if (!is_null($auditCreateDate) && !is_string($auditCreateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditCreateDate, true), gettype($auditCreateDate)), __LINE__);
        }
        if (is_null($auditCreateDate) || (is_array($auditCreateDate) && empty($auditCreateDate))) {
            unset($this->AuditCreateDate);
        } else {
            $this->AuditCreateDate = $auditCreateDate;
        }
        return $this;
    }
    /**
     * Get AuditCreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditCreatedBy()
    {
        return isset($this->AuditCreatedBy) ? $this->AuditCreatedBy : null;
    }
    /**
     * Set AuditCreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditCreatedBy
     * @return \StructType\CustomerIntegrationModel
     */
    public function setAuditCreatedBy($auditCreatedBy = null)
    {
        // validation for constraint: int
        if (!is_null($auditCreatedBy) && !(is_int($auditCreatedBy) || ctype_digit($auditCreatedBy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditCreatedBy, true), gettype($auditCreatedBy)), __LINE__);
        }
        if (is_null($auditCreatedBy) || (is_array($auditCreatedBy) && empty($auditCreatedBy))) {
            unset($this->AuditCreatedBy);
        } else {
            $this->AuditCreatedBy = $auditCreatedBy;
        }
        return $this;
    }
    /**
     * Get AuditDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditDeleted()
    {
        return isset($this->AuditDeleted) ? $this->AuditDeleted : null;
    }
    /**
     * Set AuditDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditDeleted
     * @return \StructType\CustomerIntegrationModel
     */
    public function setAuditDeleted($auditDeleted = null)
    {
        // validation for constraint: string
        if (!is_null($auditDeleted) && !is_string($auditDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditDeleted, true), gettype($auditDeleted)), __LINE__);
        }
        if (is_null($auditDeleted) || (is_array($auditDeleted) && empty($auditDeleted))) {
            unset($this->AuditDeleted);
        } else {
            $this->AuditDeleted = $auditDeleted;
        }
        return $this;
    }
    /**
     * Get AuditModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditModifiedBy()
    {
        return isset($this->AuditModifiedBy) ? $this->AuditModifiedBy : null;
    }
    /**
     * Set AuditModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditModifiedBy
     * @return \StructType\CustomerIntegrationModel
     */
    public function setAuditModifiedBy($auditModifiedBy = null)
    {
        // validation for constraint: int
        if (!is_null($auditModifiedBy) && !(is_int($auditModifiedBy) || ctype_digit($auditModifiedBy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditModifiedBy, true), gettype($auditModifiedBy)), __LINE__);
        }
        if (is_null($auditModifiedBy) || (is_array($auditModifiedBy) && empty($auditModifiedBy))) {
            unset($this->AuditModifiedBy);
        } else {
            $this->AuditModifiedBy = $auditModifiedBy;
        }
        return $this;
    }
    /**
     * Get AuditModifyDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditModifyDate()
    {
        return isset($this->AuditModifyDate) ? $this->AuditModifyDate : null;
    }
    /**
     * Set AuditModifyDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditModifyDate
     * @return \StructType\CustomerIntegrationModel
     */
    public function setAuditModifyDate($auditModifyDate = null)
    {
        // validation for constraint: string
        if (!is_null($auditModifyDate) && !is_string($auditModifyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditModifyDate, true), gettype($auditModifyDate)), __LINE__);
        }
        if (is_null($auditModifyDate) || (is_array($auditModifyDate) && empty($auditModifyDate))) {
            unset($this->AuditModifyDate);
        } else {
            $this->AuditModifyDate = $auditModifyDate;
        }
        return $this;
    }
    /**
     * Get CanUseWaybill value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCanUseWaybill()
    {
        return isset($this->CanUseWaybill) ? $this->CanUseWaybill : null;
    }
    /**
     * Set CanUseWaybill value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $canUseWaybill
     * @return \StructType\CustomerIntegrationModel
     */
    public function setCanUseWaybill($canUseWaybill = null)
    {
        // validation for constraint: string
        if (!is_null($canUseWaybill) && !is_string($canUseWaybill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($canUseWaybill, true), gettype($canUseWaybill)), __LINE__);
        }
        if (is_null($canUseWaybill) || (is_array($canUseWaybill) && empty($canUseWaybill))) {
            unset($this->CanUseWaybill);
        } else {
            $this->CanUseWaybill = $canUseWaybill;
        }
        return $this;
    }
    /**
     * Get CanUseWaybillWeekend value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCanUseWaybillWeekend()
    {
        return isset($this->CanUseWaybillWeekend) ? $this->CanUseWaybillWeekend : null;
    }
    /**
     * Set CanUseWaybillWeekend value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $canUseWaybillWeekend
     * @return \StructType\CustomerIntegrationModel
     */
    public function setCanUseWaybillWeekend($canUseWaybillWeekend = null)
    {
        // validation for constraint: string
        if (!is_null($canUseWaybillWeekend) && !is_string($canUseWaybillWeekend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($canUseWaybillWeekend, true), gettype($canUseWaybillWeekend)), __LINE__);
        }
        if (is_null($canUseWaybillWeekend) || (is_array($canUseWaybillWeekend) && empty($canUseWaybillWeekend))) {
            unset($this->CanUseWaybillWeekend);
        } else {
            $this->CanUseWaybillWeekend = $canUseWaybillWeekend;
        }
        return $this;
    }
    /**
     * Get ContactMail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactMail()
    {
        return isset($this->ContactMail) ? $this->ContactMail : null;
    }
    /**
     * Set ContactMail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactMail
     * @return \StructType\CustomerIntegrationModel
     */
    public function setContactMail($contactMail = null)
    {
        // validation for constraint: string
        if (!is_null($contactMail) && !is_string($contactMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactMail, true), gettype($contactMail)), __LINE__);
        }
        if (is_null($contactMail) || (is_array($contactMail) && empty($contactMail))) {
            unset($this->ContactMail);
        } else {
            $this->ContactMail = $contactMail;
        }
        return $this;
    }
    /**
     * Get ContactName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactName()
    {
        return isset($this->ContactName) ? $this->ContactName : null;
    }
    /**
     * Set ContactName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactName
     * @return \StructType\CustomerIntegrationModel
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactName, true), gettype($contactName)), __LINE__);
        }
        if (is_null($contactName) || (is_array($contactName) && empty($contactName))) {
            unset($this->ContactName);
        } else {
            $this->ContactName = $contactName;
        }
        return $this;
    }
    /**
     * Get ContactPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactPhone()
    {
        return isset($this->ContactPhone) ? $this->ContactPhone : null;
    }
    /**
     * Set ContactPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactPhone
     * @return \StructType\CustomerIntegrationModel
     */
    public function setContactPhone($contactPhone = null)
    {
        // validation for constraint: string
        if (!is_null($contactPhone) && !is_string($contactPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactPhone, true), gettype($contactPhone)), __LINE__);
        }
        if (is_null($contactPhone) || (is_array($contactPhone) && empty($contactPhone))) {
            unset($this->ContactPhone);
        } else {
            $this->ContactPhone = $contactPhone;
        }
        return $this;
    }
    /**
     * Get ContactPhone2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactPhone2()
    {
        return isset($this->ContactPhone2) ? $this->ContactPhone2 : null;
    }
    /**
     * Set ContactPhone2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactPhone2
     * @return \StructType\CustomerIntegrationModel
     */
    public function setContactPhone2($contactPhone2 = null)
    {
        // validation for constraint: string
        if (!is_null($contactPhone2) && !is_string($contactPhone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactPhone2, true), gettype($contactPhone2)), __LINE__);
        }
        if (is_null($contactPhone2) || (is_array($contactPhone2) && empty($contactPhone2))) {
            unset($this->ContactPhone2);
        } else {
            $this->ContactPhone2 = $contactPhone2;
        }
        return $this;
    }
    /**
     * Get ContactTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactTitle()
    {
        return isset($this->ContactTitle) ? $this->ContactTitle : null;
    }
    /**
     * Set ContactTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactTitle
     * @return \StructType\CustomerIntegrationModel
     */
    public function setContactTitle($contactTitle = null)
    {
        // validation for constraint: string
        if (!is_null($contactTitle) && !is_string($contactTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactTitle, true), gettype($contactTitle)), __LINE__);
        }
        if (is_null($contactTitle) || (is_array($contactTitle) && empty($contactTitle))) {
            unset($this->ContactTitle);
        } else {
            $this->ContactTitle = $contactTitle;
        }
        return $this;
    }
    /**
     * Get CustomerCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerCode()
    {
        return isset($this->CustomerCode) ? $this->CustomerCode : null;
    }
    /**
     * Set CustomerCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerCode
     * @return \StructType\CustomerIntegrationModel
     */
    public function setCustomerCode($customerCode = null)
    {
        // validation for constraint: string
        if (!is_null($customerCode) && !is_string($customerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerCode, true), gettype($customerCode)), __LINE__);
        }
        if (is_null($customerCode) || (is_array($customerCode) && empty($customerCode))) {
            unset($this->CustomerCode);
        } else {
            $this->CustomerCode = $customerCode;
        }
        return $this;
    }
    /**
     * Get CustomerIntegrationId value
     * @return string|null
     */
    public function getCustomerIntegrationId()
    {
        return $this->CustomerIntegrationId;
    }
    /**
     * Set CustomerIntegrationId value
     * @param string $customerIntegrationId
     * @return \StructType\CustomerIntegrationModel
     */
    public function setCustomerIntegrationId($customerIntegrationId = null)
    {
        // validation for constraint: string
        if (!is_null($customerIntegrationId) && !is_string($customerIntegrationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerIntegrationId, true), gettype($customerIntegrationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($customerIntegrationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $customerIntegrationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($customerIntegrationId, true)), __LINE__);
        }
        $this->CustomerIntegrationId = $customerIntegrationId;
        return $this;
    }
    /**
     * Get EndpointUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndpointUrl()
    {
        return isset($this->EndpointUrl) ? $this->EndpointUrl : null;
    }
    /**
     * Set EndpointUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endpointUrl
     * @return \StructType\CustomerIntegrationModel
     */
    public function setEndpointUrl($endpointUrl = null)
    {
        // validation for constraint: string
        if (!is_null($endpointUrl) && !is_string($endpointUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endpointUrl, true), gettype($endpointUrl)), __LINE__);
        }
        if (is_null($endpointUrl) || (is_array($endpointUrl) && empty($endpointUrl))) {
            unset($this->EndpointUrl);
        } else {
            $this->EndpointUrl = $endpointUrl;
        }
        return $this;
    }
    /**
     * Get IsAtAccepted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsAtAccepted()
    {
        return isset($this->IsAtAccepted) ? $this->IsAtAccepted : null;
    }
    /**
     * Set IsAtAccepted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isAtAccepted
     * @return \StructType\CustomerIntegrationModel
     */
    public function setIsAtAccepted($isAtAccepted = null)
    {
        // validation for constraint: string
        if (!is_null($isAtAccepted) && !is_string($isAtAccepted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isAtAccepted, true), gettype($isAtAccepted)), __LINE__);
        }
        if (is_null($isAtAccepted) || (is_array($isAtAccepted) && empty($isAtAccepted))) {
            unset($this->IsAtAccepted);
        } else {
            $this->IsAtAccepted = $isAtAccepted;
        }
        return $this;
    }
    /**
     * Get IsNotMeasuredAccepted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsNotMeasuredAccepted()
    {
        return isset($this->IsNotMeasuredAccepted) ? $this->IsNotMeasuredAccepted : null;
    }
    /**
     * Set IsNotMeasuredAccepted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isNotMeasuredAccepted
     * @return \StructType\CustomerIntegrationModel
     */
    public function setIsNotMeasuredAccepted($isNotMeasuredAccepted = null)
    {
        // validation for constraint: string
        if (!is_null($isNotMeasuredAccepted) && !is_string($isNotMeasuredAccepted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isNotMeasuredAccepted, true), gettype($isNotMeasuredAccepted)), __LINE__);
        }
        if (is_null($isNotMeasuredAccepted) || (is_array($isNotMeasuredAccepted) && empty($isNotMeasuredAccepted))) {
            unset($this->IsNotMeasuredAccepted);
        } else {
            $this->IsNotMeasuredAccepted = $isNotMeasuredAccepted;
        }
        return $this;
    }
    /**
     * Get IsPiecedAccepted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsPiecedAccepted()
    {
        return isset($this->IsPiecedAccepted) ? $this->IsPiecedAccepted : null;
    }
    /**
     * Set IsPiecedAccepted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isPiecedAccepted
     * @return \StructType\CustomerIntegrationModel
     */
    public function setIsPiecedAccepted($isPiecedAccepted = null)
    {
        // validation for constraint: string
        if (!is_null($isPiecedAccepted) && !is_string($isPiecedAccepted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isPiecedAccepted, true), gettype($isPiecedAccepted)), __LINE__);
        }
        if (is_null($isPiecedAccepted) || (is_array($isPiecedAccepted) && empty($isPiecedAccepted))) {
            unset($this->IsPiecedAccepted);
        } else {
            $this->IsPiecedAccepted = $isPiecedAccepted;
        }
        return $this;
    }
    /**
     * Get IsSequentialOperation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsSequentialOperation()
    {
        return isset($this->IsSequentialOperation) ? $this->IsSequentialOperation : null;
    }
    /**
     * Set IsSequentialOperation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isSequentialOperation
     * @return \StructType\CustomerIntegrationModel
     */
    public function setIsSequentialOperation($isSequentialOperation = null)
    {
        // validation for constraint: string
        if (!is_null($isSequentialOperation) && !is_string($isSequentialOperation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isSequentialOperation, true), gettype($isSequentialOperation)), __LINE__);
        }
        if (is_null($isSequentialOperation) || (is_array($isSequentialOperation) && empty($isSequentialOperation))) {
            unset($this->IsSequentialOperation);
        } else {
            $this->IsSequentialOperation = $isSequentialOperation;
        }
        return $this;
    }
    /**
     * Get IsVolumeAccepted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsVolumeAccepted()
    {
        return isset($this->IsVolumeAccepted) ? $this->IsVolumeAccepted : null;
    }
    /**
     * Set IsVolumeAccepted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isVolumeAccepted
     * @return \StructType\CustomerIntegrationModel
     */
    public function setIsVolumeAccepted($isVolumeAccepted = null)
    {
        // validation for constraint: string
        if (!is_null($isVolumeAccepted) && !is_string($isVolumeAccepted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isVolumeAccepted, true), gettype($isVolumeAccepted)), __LINE__);
        }
        if (is_null($isVolumeAccepted) || (is_array($isVolumeAccepted) && empty($isVolumeAccepted))) {
            unset($this->IsVolumeAccepted);
        } else {
            $this->IsVolumeAccepted = $isVolumeAccepted;
        }
        return $this;
    }
    /**
     * Get IsVolumeOptionalAccepted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsVolumeOptionalAccepted()
    {
        return isset($this->IsVolumeOptionalAccepted) ? $this->IsVolumeOptionalAccepted : null;
    }
    /**
     * Set IsVolumeOptionalAccepted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isVolumeOptionalAccepted
     * @return \StructType\CustomerIntegrationModel
     */
    public function setIsVolumeOptionalAccepted($isVolumeOptionalAccepted = null)
    {
        // validation for constraint: string
        if (!is_null($isVolumeOptionalAccepted) && !is_string($isVolumeOptionalAccepted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isVolumeOptionalAccepted, true), gettype($isVolumeOptionalAccepted)), __LINE__);
        }
        if (is_null($isVolumeOptionalAccepted) || (is_array($isVolumeOptionalAccepted) && empty($isVolumeOptionalAccepted))) {
            unset($this->IsVolumeOptionalAccepted);
        } else {
            $this->IsVolumeOptionalAccepted = $isVolumeOptionalAccepted;
        }
        return $this;
    }
    /**
     * Get LinkOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLinkOrder()
    {
        return isset($this->LinkOrder) ? $this->LinkOrder : null;
    }
    /**
     * Set LinkOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $linkOrder
     * @return \StructType\CustomerIntegrationModel
     */
    public function setLinkOrder($linkOrder = null)
    {
        // validation for constraint: int
        if (!is_null($linkOrder) && !(is_int($linkOrder) || ctype_digit($linkOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($linkOrder, true), gettype($linkOrder)), __LINE__);
        }
        if (is_null($linkOrder) || (is_array($linkOrder) && empty($linkOrder))) {
            unset($this->LinkOrder);
        } else {
            $this->LinkOrder = $linkOrder;
        }
        return $this;
    }
    /**
     * Get LovIntegrationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LovIntegrationType|null
     */
    public function getLovIntegrationType()
    {
        return isset($this->LovIntegrationType) ? $this->LovIntegrationType : null;
    }
    /**
     * Set LovIntegrationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\LovIntegrationType $lovIntegrationType
     * @return \StructType\CustomerIntegrationModel
     */
    public function setLovIntegrationType(\StructType\LovIntegrationType $lovIntegrationType = null)
    {
        if (is_null($lovIntegrationType) || (is_array($lovIntegrationType) && empty($lovIntegrationType))) {
            unset($this->LovIntegrationType);
        } else {
            $this->LovIntegrationType = $lovIntegrationType;
        }
        return $this;
    }
    /**
     * Get LovSubIntegrationTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLovSubIntegrationTypeId()
    {
        return isset($this->LovSubIntegrationTypeId) ? $this->LovSubIntegrationTypeId : null;
    }
    /**
     * Set LovSubIntegrationTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lovSubIntegrationTypeId
     * @return \StructType\CustomerIntegrationModel
     */
    public function setLovSubIntegrationTypeId($lovSubIntegrationTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($lovSubIntegrationTypeId) && !(is_int($lovSubIntegrationTypeId) || ctype_digit($lovSubIntegrationTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lovSubIntegrationTypeId, true), gettype($lovSubIntegrationTypeId)), __LINE__);
        }
        if (is_null($lovSubIntegrationTypeId) || (is_array($lovSubIntegrationTypeId) && empty($lovSubIntegrationTypeId))) {
            unset($this->LovSubIntegrationTypeId);
        } else {
            $this->LovSubIntegrationTypeId = $lovSubIntegrationTypeId;
        }
        return $this;
    }
    /**
     * Get Param1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParam1()
    {
        return isset($this->Param1) ? $this->Param1 : null;
    }
    /**
     * Set Param1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $param1
     * @return \StructType\CustomerIntegrationModel
     */
    public function setParam1($param1 = null)
    {
        // validation for constraint: string
        if (!is_null($param1) && !is_string($param1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($param1, true), gettype($param1)), __LINE__);
        }
        if (is_null($param1) || (is_array($param1) && empty($param1))) {
            unset($this->Param1);
        } else {
            $this->Param1 = $param1;
        }
        return $this;
    }
    /**
     * Get Param2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParam2()
    {
        return isset($this->Param2) ? $this->Param2 : null;
    }
    /**
     * Set Param2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $param2
     * @return \StructType\CustomerIntegrationModel
     */
    public function setParam2($param2 = null)
    {
        // validation for constraint: string
        if (!is_null($param2) && !is_string($param2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($param2, true), gettype($param2)), __LINE__);
        }
        if (is_null($param2) || (is_array($param2) && empty($param2))) {
            unset($this->Param2);
        } else {
            $this->Param2 = $param2;
        }
        return $this;
    }
    /**
     * Get Param3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParam3()
    {
        return isset($this->Param3) ? $this->Param3 : null;
    }
    /**
     * Set Param3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $param3
     * @return \StructType\CustomerIntegrationModel
     */
    public function setParam3($param3 = null)
    {
        // validation for constraint: string
        if (!is_null($param3) && !is_string($param3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($param3, true), gettype($param3)), __LINE__);
        }
        if (is_null($param3) || (is_array($param3) && empty($param3))) {
            unset($this->Param3);
        } else {
            $this->Param3 = $param3;
        }
        return $this;
    }
    /**
     * Get Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->Password) ? $this->Password : null;
    }
    /**
     * Set Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \StructType\CustomerIntegrationModel
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->Password);
        } else {
            $this->Password = $password;
        }
        return $this;
    }
    /**
     * Get UnitCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnitCode()
    {
        return isset($this->UnitCode) ? $this->UnitCode : null;
    }
    /**
     * Set UnitCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unitCode
     * @return \StructType\CustomerIntegrationModel
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitCode, true), gettype($unitCode)), __LINE__);
        }
        if (is_null($unitCode) || (is_array($unitCode) && empty($unitCode))) {
            unset($this->UnitCode);
        } else {
            $this->UnitCode = $unitCode;
        }
        return $this;
    }
    /**
     * Get UseAutoParser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUseAutoParser()
    {
        return isset($this->UseAutoParser) ? $this->UseAutoParser : null;
    }
    /**
     * Set UseAutoParser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $useAutoParser
     * @return \StructType\CustomerIntegrationModel
     */
    public function setUseAutoParser($useAutoParser = null)
    {
        // validation for constraint: string
        if (!is_null($useAutoParser) && !is_string($useAutoParser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useAutoParser, true), gettype($useAutoParser)), __LINE__);
        }
        if (is_null($useAutoParser) || (is_array($useAutoParser) && empty($useAutoParser))) {
            unset($this->UseAutoParser);
        } else {
            $this->UseAutoParser = $useAutoParser;
        }
        return $this;
    }
    /**
     * Get Username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->Username) ? $this->Username : null;
    }
    /**
     * Set Username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \StructType\CustomerIntegrationModel
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->Username);
        } else {
            $this->Username = $username;
        }
        return $this;
    }
    /**
     * Get WebMethodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebMethodName()
    {
        return isset($this->WebMethodName) ? $this->WebMethodName : null;
    }
    /**
     * Set WebMethodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $webMethodName
     * @return \StructType\CustomerIntegrationModel
     */
    public function setWebMethodName($webMethodName = null)
    {
        // validation for constraint: string
        if (!is_null($webMethodName) && !is_string($webMethodName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webMethodName, true), gettype($webMethodName)), __LINE__);
        }
        if (is_null($webMethodName) || (is_array($webMethodName) && empty($webMethodName))) {
            unset($this->WebMethodName);
        } else {
            $this->WebMethodName = $webMethodName;
        }
        return $this;
    }
}
