<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountModel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AccountModel
 * @subpackage Structs
 */
class AccountModel extends AbstractStructBase
{
    /**
     * The AccountAddressList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAccountAddress
     */
    public $AccountAddressList;
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountId;
    /**
     * The ActiveVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActiveVersion;
    /**
     * The ApplicationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ApplicationId;
    /**
     * The ApplicationVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationVersion;
    /**
     * The AuditCreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditCreateDate;
    /**
     * The AuditCreateDate2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditCreateDate2;
    /**
     * The AuditCreateUnitId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditCreateUnitId;
    /**
     * The AuditCreatedBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditCreatedBy;
    /**
     * The AuditDeleted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditDeleted;
    /**
     * The AuditModifiedBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditModifiedBy;
    /**
     * The AuditModifyDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditModifyDate;
    /**
     * The AuditModifyDate2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditModifyDate2;
    /**
     * The AuditModifyUnitId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditModifyUnitId;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The ErpNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErpNo;
    /**
     * The LovAccountType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LovAccountType
     */
    public $LovAccountType;
    /**
     * The LovCustomerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LovCustomerType
     */
    public $LovCustomerType;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The TransferDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransferDate;
    /**
     * The TransferStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransferStatus;
    /**
     * Constructor method for AccountModel
     * @uses AccountModel::setAccountAddressList()
     * @uses AccountModel::setAccountId()
     * @uses AccountModel::setActiveVersion()
     * @uses AccountModel::setApplicationId()
     * @uses AccountModel::setApplicationVersion()
     * @uses AccountModel::setAuditCreateDate()
     * @uses AccountModel::setAuditCreateDate2()
     * @uses AccountModel::setAuditCreateUnitId()
     * @uses AccountModel::setAuditCreatedBy()
     * @uses AccountModel::setAuditDeleted()
     * @uses AccountModel::setAuditModifiedBy()
     * @uses AccountModel::setAuditModifyDate()
     * @uses AccountModel::setAuditModifyDate2()
     * @uses AccountModel::setAuditModifyUnitId()
     * @uses AccountModel::setCode()
     * @uses AccountModel::setErpNo()
     * @uses AccountModel::setLovAccountType()
     * @uses AccountModel::setLovCustomerType()
     * @uses AccountModel::setName()
     * @uses AccountModel::setTransferDate()
     * @uses AccountModel::setTransferStatus()
     * @param \ArrayType\ArrayOfAccountAddress $accountAddressList
     * @param string $accountId
     * @param string $activeVersion
     * @param int $applicationId
     * @param string $applicationVersion
     * @param string $auditCreateDate
     * @param string $auditCreateDate2
     * @param int $auditCreateUnitId
     * @param int $auditCreatedBy
     * @param string $auditDeleted
     * @param int $auditModifiedBy
     * @param string $auditModifyDate
     * @param string $auditModifyDate2
     * @param int $auditModifyUnitId
     * @param string $code
     * @param string $erpNo
     * @param \StructType\LovAccountType $lovAccountType
     * @param \StructType\LovCustomerType $lovCustomerType
     * @param string $name
     * @param string $transferDate
     * @param string $transferStatus
     */
    public function __construct(\ArrayType\ArrayOfAccountAddress $accountAddressList = null, $accountId = null, $activeVersion = null, $applicationId = null, $applicationVersion = null, $auditCreateDate = null, $auditCreateDate2 = null, $auditCreateUnitId = null, $auditCreatedBy = null, $auditDeleted = null, $auditModifiedBy = null, $auditModifyDate = null, $auditModifyDate2 = null, $auditModifyUnitId = null, $code = null, $erpNo = null, \StructType\LovAccountType $lovAccountType = null, \StructType\LovCustomerType $lovCustomerType = null, $name = null, $transferDate = null, $transferStatus = null)
    {
        $this
            ->setAccountAddressList($accountAddressList)
            ->setAccountId($accountId)
            ->setActiveVersion($activeVersion)
            ->setApplicationId($applicationId)
            ->setApplicationVersion($applicationVersion)
            ->setAuditCreateDate($auditCreateDate)
            ->setAuditCreateDate2($auditCreateDate2)
            ->setAuditCreateUnitId($auditCreateUnitId)
            ->setAuditCreatedBy($auditCreatedBy)
            ->setAuditDeleted($auditDeleted)
            ->setAuditModifiedBy($auditModifiedBy)
            ->setAuditModifyDate($auditModifyDate)
            ->setAuditModifyDate2($auditModifyDate2)
            ->setAuditModifyUnitId($auditModifyUnitId)
            ->setCode($code)
            ->setErpNo($erpNo)
            ->setLovAccountType($lovAccountType)
            ->setLovCustomerType($lovCustomerType)
            ->setName($name)
            ->setTransferDate($transferDate)
            ->setTransferStatus($transferStatus);
    }
    /**
     * Get AccountAddressList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAccountAddress|null
     */
    public function getAccountAddressList()
    {
        return isset($this->AccountAddressList) ? $this->AccountAddressList : null;
    }
    /**
     * Set AccountAddressList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAccountAddress $accountAddressList
     * @return \StructType\AccountModel
     */
    public function setAccountAddressList(\ArrayType\ArrayOfAccountAddress $accountAddressList = null)
    {
        if (is_null($accountAddressList) || (is_array($accountAddressList) && empty($accountAddressList))) {
            unset($this->AccountAddressList);
        } else {
            $this->AccountAddressList = $accountAddressList;
        }
        return $this;
    }
    /**
     * Get AccountId value
     * @return string|null
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param string $accountId
     * @return \StructType\AccountModel
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: string
        if (!is_null($accountId) && !is_string($accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountId, true)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get ActiveVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActiveVersion()
    {
        return isset($this->ActiveVersion) ? $this->ActiveVersion : null;
    }
    /**
     * Set ActiveVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activeVersion
     * @return \StructType\AccountModel
     */
    public function setActiveVersion($activeVersion = null)
    {
        // validation for constraint: string
        if (!is_null($activeVersion) && !is_string($activeVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activeVersion, true), gettype($activeVersion)), __LINE__);
        }
        if (is_null($activeVersion) || (is_array($activeVersion) && empty($activeVersion))) {
            unset($this->ActiveVersion);
        } else {
            $this->ActiveVersion = $activeVersion;
        }
        return $this;
    }
    /**
     * Get ApplicationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getApplicationId()
    {
        return isset($this->ApplicationId) ? $this->ApplicationId : null;
    }
    /**
     * Set ApplicationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $applicationId
     * @return \StructType\AccountModel
     */
    public function setApplicationId($applicationId = null)
    {
        // validation for constraint: int
        if (!is_null($applicationId) && !(is_int($applicationId) || ctype_digit($applicationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($applicationId, true), gettype($applicationId)), __LINE__);
        }
        if (is_null($applicationId) || (is_array($applicationId) && empty($applicationId))) {
            unset($this->ApplicationId);
        } else {
            $this->ApplicationId = $applicationId;
        }
        return $this;
    }
    /**
     * Get ApplicationVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationVersion()
    {
        return isset($this->ApplicationVersion) ? $this->ApplicationVersion : null;
    }
    /**
     * Set ApplicationVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationVersion
     * @return \StructType\AccountModel
     */
    public function setApplicationVersion($applicationVersion = null)
    {
        // validation for constraint: string
        if (!is_null($applicationVersion) && !is_string($applicationVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationVersion, true), gettype($applicationVersion)), __LINE__);
        }
        if (is_null($applicationVersion) || (is_array($applicationVersion) && empty($applicationVersion))) {
            unset($this->ApplicationVersion);
        } else {
            $this->ApplicationVersion = $applicationVersion;
        }
        return $this;
    }
    /**
     * Get AuditCreateDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditCreateDate()
    {
        return isset($this->AuditCreateDate) ? $this->AuditCreateDate : null;
    }
    /**
     * Set AuditCreateDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditCreateDate
     * @return \StructType\AccountModel
     */
    public function setAuditCreateDate($auditCreateDate = null)
    {
        // validation for constraint: string
        if (!is_null($auditCreateDate) && !is_string($auditCreateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditCreateDate, true), gettype($auditCreateDate)), __LINE__);
        }
        if (is_null($auditCreateDate) || (is_array($auditCreateDate) && empty($auditCreateDate))) {
            unset($this->AuditCreateDate);
        } else {
            $this->AuditCreateDate = $auditCreateDate;
        }
        return $this;
    }
    /**
     * Get AuditCreateDate2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditCreateDate2()
    {
        return isset($this->AuditCreateDate2) ? $this->AuditCreateDate2 : null;
    }
    /**
     * Set AuditCreateDate2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditCreateDate2
     * @return \StructType\AccountModel
     */
    public function setAuditCreateDate2($auditCreateDate2 = null)
    {
        // validation for constraint: string
        if (!is_null($auditCreateDate2) && !is_string($auditCreateDate2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditCreateDate2, true), gettype($auditCreateDate2)), __LINE__);
        }
        if (is_null($auditCreateDate2) || (is_array($auditCreateDate2) && empty($auditCreateDate2))) {
            unset($this->AuditCreateDate2);
        } else {
            $this->AuditCreateDate2 = $auditCreateDate2;
        }
        return $this;
    }
    /**
     * Get AuditCreateUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditCreateUnitId()
    {
        return isset($this->AuditCreateUnitId) ? $this->AuditCreateUnitId : null;
    }
    /**
     * Set AuditCreateUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditCreateUnitId
     * @return \StructType\AccountModel
     */
    public function setAuditCreateUnitId($auditCreateUnitId = null)
    {
        // validation for constraint: int
        if (!is_null($auditCreateUnitId) && !(is_int($auditCreateUnitId) || ctype_digit($auditCreateUnitId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditCreateUnitId, true), gettype($auditCreateUnitId)), __LINE__);
        }
        if (is_null($auditCreateUnitId) || (is_array($auditCreateUnitId) && empty($auditCreateUnitId))) {
            unset($this->AuditCreateUnitId);
        } else {
            $this->AuditCreateUnitId = $auditCreateUnitId;
        }
        return $this;
    }
    /**
     * Get AuditCreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditCreatedBy()
    {
        return isset($this->AuditCreatedBy) ? $this->AuditCreatedBy : null;
    }
    /**
     * Set AuditCreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditCreatedBy
     * @return \StructType\AccountModel
     */
    public function setAuditCreatedBy($auditCreatedBy = null)
    {
        // validation for constraint: int
        if (!is_null($auditCreatedBy) && !(is_int($auditCreatedBy) || ctype_digit($auditCreatedBy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditCreatedBy, true), gettype($auditCreatedBy)), __LINE__);
        }
        if (is_null($auditCreatedBy) || (is_array($auditCreatedBy) && empty($auditCreatedBy))) {
            unset($this->AuditCreatedBy);
        } else {
            $this->AuditCreatedBy = $auditCreatedBy;
        }
        return $this;
    }
    /**
     * Get AuditDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditDeleted()
    {
        return isset($this->AuditDeleted) ? $this->AuditDeleted : null;
    }
    /**
     * Set AuditDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditDeleted
     * @return \StructType\AccountModel
     */
    public function setAuditDeleted($auditDeleted = null)
    {
        // validation for constraint: string
        if (!is_null($auditDeleted) && !is_string($auditDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditDeleted, true), gettype($auditDeleted)), __LINE__);
        }
        if (is_null($auditDeleted) || (is_array($auditDeleted) && empty($auditDeleted))) {
            unset($this->AuditDeleted);
        } else {
            $this->AuditDeleted = $auditDeleted;
        }
        return $this;
    }
    /**
     * Get AuditModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditModifiedBy()
    {
        return isset($this->AuditModifiedBy) ? $this->AuditModifiedBy : null;
    }
    /**
     * Set AuditModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditModifiedBy
     * @return \StructType\AccountModel
     */
    public function setAuditModifiedBy($auditModifiedBy = null)
    {
        // validation for constraint: int
        if (!is_null($auditModifiedBy) && !(is_int($auditModifiedBy) || ctype_digit($auditModifiedBy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditModifiedBy, true), gettype($auditModifiedBy)), __LINE__);
        }
        if (is_null($auditModifiedBy) || (is_array($auditModifiedBy) && empty($auditModifiedBy))) {
            unset($this->AuditModifiedBy);
        } else {
            $this->AuditModifiedBy = $auditModifiedBy;
        }
        return $this;
    }
    /**
     * Get AuditModifyDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditModifyDate()
    {
        return isset($this->AuditModifyDate) ? $this->AuditModifyDate : null;
    }
    /**
     * Set AuditModifyDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditModifyDate
     * @return \StructType\AccountModel
     */
    public function setAuditModifyDate($auditModifyDate = null)
    {
        // validation for constraint: string
        if (!is_null($auditModifyDate) && !is_string($auditModifyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditModifyDate, true), gettype($auditModifyDate)), __LINE__);
        }
        if (is_null($auditModifyDate) || (is_array($auditModifyDate) && empty($auditModifyDate))) {
            unset($this->AuditModifyDate);
        } else {
            $this->AuditModifyDate = $auditModifyDate;
        }
        return $this;
    }
    /**
     * Get AuditModifyDate2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditModifyDate2()
    {
        return isset($this->AuditModifyDate2) ? $this->AuditModifyDate2 : null;
    }
    /**
     * Set AuditModifyDate2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditModifyDate2
     * @return \StructType\AccountModel
     */
    public function setAuditModifyDate2($auditModifyDate2 = null)
    {
        // validation for constraint: string
        if (!is_null($auditModifyDate2) && !is_string($auditModifyDate2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditModifyDate2, true), gettype($auditModifyDate2)), __LINE__);
        }
        if (is_null($auditModifyDate2) || (is_array($auditModifyDate2) && empty($auditModifyDate2))) {
            unset($this->AuditModifyDate2);
        } else {
            $this->AuditModifyDate2 = $auditModifyDate2;
        }
        return $this;
    }
    /**
     * Get AuditModifyUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditModifyUnitId()
    {
        return isset($this->AuditModifyUnitId) ? $this->AuditModifyUnitId : null;
    }
    /**
     * Set AuditModifyUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditModifyUnitId
     * @return \StructType\AccountModel
     */
    public function setAuditModifyUnitId($auditModifyUnitId = null)
    {
        // validation for constraint: int
        if (!is_null($auditModifyUnitId) && !(is_int($auditModifyUnitId) || ctype_digit($auditModifyUnitId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditModifyUnitId, true), gettype($auditModifyUnitId)), __LINE__);
        }
        if (is_null($auditModifyUnitId) || (is_array($auditModifyUnitId) && empty($auditModifyUnitId))) {
            unset($this->AuditModifyUnitId);
        } else {
            $this->AuditModifyUnitId = $auditModifyUnitId;
        }
        return $this;
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \StructType\AccountModel
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get ErpNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErpNo()
    {
        return isset($this->ErpNo) ? $this->ErpNo : null;
    }
    /**
     * Set ErpNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $erpNo
     * @return \StructType\AccountModel
     */
    public function setErpNo($erpNo = null)
    {
        // validation for constraint: string
        if (!is_null($erpNo) && !is_string($erpNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erpNo, true), gettype($erpNo)), __LINE__);
        }
        if (is_null($erpNo) || (is_array($erpNo) && empty($erpNo))) {
            unset($this->ErpNo);
        } else {
            $this->ErpNo = $erpNo;
        }
        return $this;
    }
    /**
     * Get LovAccountType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LovAccountType|null
     */
    public function getLovAccountType()
    {
        return isset($this->LovAccountType) ? $this->LovAccountType : null;
    }
    /**
     * Set LovAccountType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\LovAccountType $lovAccountType
     * @return \StructType\AccountModel
     */
    public function setLovAccountType(\StructType\LovAccountType $lovAccountType = null)
    {
        if (is_null($lovAccountType) || (is_array($lovAccountType) && empty($lovAccountType))) {
            unset($this->LovAccountType);
        } else {
            $this->LovAccountType = $lovAccountType;
        }
        return $this;
    }
    /**
     * Get LovCustomerType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LovCustomerType|null
     */
    public function getLovCustomerType()
    {
        return isset($this->LovCustomerType) ? $this->LovCustomerType : null;
    }
    /**
     * Set LovCustomerType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\LovCustomerType $lovCustomerType
     * @return \StructType\AccountModel
     */
    public function setLovCustomerType(\StructType\LovCustomerType $lovCustomerType = null)
    {
        if (is_null($lovCustomerType) || (is_array($lovCustomerType) && empty($lovCustomerType))) {
            unset($this->LovCustomerType);
        } else {
            $this->LovCustomerType = $lovCustomerType;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\AccountModel
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get TransferDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransferDate()
    {
        return isset($this->TransferDate) ? $this->TransferDate : null;
    }
    /**
     * Set TransferDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transferDate
     * @return \StructType\AccountModel
     */
    public function setTransferDate($transferDate = null)
    {
        // validation for constraint: string
        if (!is_null($transferDate) && !is_string($transferDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transferDate, true), gettype($transferDate)), __LINE__);
        }
        if (is_null($transferDate) || (is_array($transferDate) && empty($transferDate))) {
            unset($this->TransferDate);
        } else {
            $this->TransferDate = $transferDate;
        }
        return $this;
    }
    /**
     * Get TransferStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransferStatus()
    {
        return isset($this->TransferStatus) ? $this->TransferStatus : null;
    }
    /**
     * Set TransferStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transferStatus
     * @return \StructType\AccountModel
     */
    public function setTransferStatus($transferStatus = null)
    {
        // validation for constraint: string
        if (!is_null($transferStatus) && !is_string($transferStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transferStatus, true), gettype($transferStatus)), __LINE__);
        }
        if (is_null($transferStatus) || (is_array($transferStatus) && empty($transferStatus))) {
            unset($this->TransferStatus);
        } else {
            $this->TransferStatus = $transferStatus;
        }
        return $this;
    }
}
