<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountAddress StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AccountAddress
 * @subpackage Structs
 */
class AccountAddress extends AbstractStructBase
{
    /**
     * The Aa_Everyday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Aa_Everyday;
    /**
     * The Aa_FirstTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Aa_FirstTime;
    /**
     * The Aa_LastTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Aa_LastTime;
    /**
     * The AcceptCargo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AcceptCargo;
    /**
     * The AcceptCargoSaturday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AcceptCargoSaturday;
    /**
     * The AcceptCargoWorldwide
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AcceptCargoWorldwide;
    /**
     * The AcceptContractedShipment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AcceptContractedShipment;
    /**
     * The AcceptReceiverPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AcceptReceiverPayment;
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AccountModel
     */
    public $Account;
    /**
     * The AccountAddressCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountAddressCode;
    /**
     * The AccountAddressId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountAddressId;
    /**
     * The AccountAddressVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountAddressVersionId;
    /**
     * The Accounting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Accounting;
    /**
     * The ActiveVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActiveVersion;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Address;
    /**
     * The AddressStatusModifyDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressStatusModifyDate;
    /**
     * The ApplicationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ApplicationId;
    /**
     * The ApplicationVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationVersion;
    /**
     * The ApproveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApproveDate;
    /**
     * The ApprovedBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ApprovedBy;
    /**
     * The AuditCreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditCreateDate;
    /**
     * The AuditCreateDate2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditCreateDate2;
    /**
     * The AuditCreateUnitId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditCreateUnitId;
    /**
     * The AuditCreatedBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditCreatedBy;
    /**
     * The AuditDeleted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditDeleted;
    /**
     * The AuditModifiedBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditModifiedBy;
    /**
     * The AuditModifyDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditModifyDate;
    /**
     * The AuditModifyDate2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuditModifyDate2;
    /**
     * The AuditModifyUnitId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditModifyUnitId;
    /**
     * The Barcode_Alias
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode_Alias;
    /**
     * The BarterchequeUser
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarterchequeUser;
    /**
     * The BatchInvoice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BatchInvoice;
    /**
     * The Block
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Block;
    /**
     * The BuildingName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BuildingName;
    /**
     * The BuildingNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BuildingNumber;
    /**
     * The CollectionUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Unit
     */
    public $CollectionUnit;
    /**
     * The CourierWorkRangeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CourierWorkRangeCode;
    /**
     * The CustomerSpecialMessageText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomerSpecialMessageText;
    /**
     * The DeliverAtHub
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliverAtHub;
    /**
     * The DeliverFromHub
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliverFromHub;
    /**
     * The DoorNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DoorNumber;
    /**
     * The EInvoiceLabel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EInvoiceLabel;
    /**
     * The Email1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email1;
    /**
     * The Email2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email2;
    /**
     * The ErpNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErpNo;
    /**
     * The ExceptSelectedUnits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExceptSelectedUnits;
    /**
     * The Fax1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Fax1;
    /**
     * The Fax2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Fax2;
    /**
     * The ForceIntegrationCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForceIntegrationCode;
    /**
     * The ForceIntegrationCodeRegex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForceIntegrationCodeRegex;
    /**
     * The GeoHinterLandId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GeoHinterLandId;
    /**
     * The HintAvenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HintAvenue;
    /**
     * The HintCity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HintCity
     */
    public $HintCity;
    /**
     * The HintCountry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HintCountry
     */
    public $HintCountry;
    /**
     * The HintDistrict
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HintDistrict;
    /**
     * The HintField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HintField;
    /**
     * The HintQuarter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HintQuarter;
    /**
     * The HintStreet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HintStreet;
    /**
     * The HintTown
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HintTown
     */
    public $HintTown;
    /**
     * The HinterLandId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HinterLandId;
    /**
     * The HinterLandStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HinterLandStatus;
    /**
     * The IntegrationCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IntegrationCode;
    /**
     * The InvoiceAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvoiceAddress;
    /**
     * The InvoiceAddressVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InvoiceAddressVersionId;
    /**
     * The InvoiceTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvoiceTitle;
    /**
     * The InvoiceUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Unit
     */
    public $InvoiceUnit;
    /**
     * The LastUsedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUsedDate;
    /**
     * The LastVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastVersion;
    /**
     * The LovAddressKeyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LovAddressKeyId;
    /**
     * The LovAddressStatusId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LovAddressStatusId;
    /**
     * The LovAddressType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LovAddressType
     */
    public $LovAddressType;
    /**
     * The LovApprovedId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LovApprovedId;
    /**
     * The LovAuditCreatedVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LovAuditCreatedVersion
     */
    public $LovAuditCreatedVersion;
    /**
     * The LovIdentityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LovIdentityType
     */
    public $LovIdentityType;
    /**
     * The LovPolygonLevelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LovPolygonLevelId;
    /**
     * The LovTaxExemptReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LovTaxExemptReason
     */
    public $LovTaxExemptReason;
    /**
     * The MobilePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobilePhone;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Phone1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone1;
    /**
     * The Phone2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone2;
    /**
     * The PostCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostCode;
    /**
     * The SourceUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Unit
     */
    public $SourceUnit;
    /**
     * The TargetUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Unit
     */
    public $TargetUnit;
    /**
     * The TaxExempt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxExempt;
    /**
     * The TaxExemptreason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxExemptreason;
    /**
     * The TaxNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxNumber;
    /**
     * The TaxNumberConfidential
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxNumberConfidential;
    /**
     * The TaxOffice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxOffice;
    /**
     * The TransferDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransferDate;
    /**
     * The TransferStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransferStatus;
    /**
     * The UncertainCredit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UncertainCredit;
    /**
     * The Url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Url;
    /**
     * The UsePricelistService
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UsePricelistService;
    /**
     * The ValidAllUnits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidAllUnits;
    /**
     * The WithHolding
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WithHolding;
    /**
     * The XCoor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $XCoor;
    /**
     * The YCoor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $YCoor;
    /**
     * Constructor method for AccountAddress
     * @uses AccountAddress::setAa_Everyday()
     * @uses AccountAddress::setAa_FirstTime()
     * @uses AccountAddress::setAa_LastTime()
     * @uses AccountAddress::setAcceptCargo()
     * @uses AccountAddress::setAcceptCargoSaturday()
     * @uses AccountAddress::setAcceptCargoWorldwide()
     * @uses AccountAddress::setAcceptContractedShipment()
     * @uses AccountAddress::setAcceptReceiverPayment()
     * @uses AccountAddress::setAccount()
     * @uses AccountAddress::setAccountAddressCode()
     * @uses AccountAddress::setAccountAddressId()
     * @uses AccountAddress::setAccountAddressVersionId()
     * @uses AccountAddress::setAccounting()
     * @uses AccountAddress::setActiveVersion()
     * @uses AccountAddress::setAddress()
     * @uses AccountAddress::setAddressStatusModifyDate()
     * @uses AccountAddress::setApplicationId()
     * @uses AccountAddress::setApplicationVersion()
     * @uses AccountAddress::setApproveDate()
     * @uses AccountAddress::setApprovedBy()
     * @uses AccountAddress::setAuditCreateDate()
     * @uses AccountAddress::setAuditCreateDate2()
     * @uses AccountAddress::setAuditCreateUnitId()
     * @uses AccountAddress::setAuditCreatedBy()
     * @uses AccountAddress::setAuditDeleted()
     * @uses AccountAddress::setAuditModifiedBy()
     * @uses AccountAddress::setAuditModifyDate()
     * @uses AccountAddress::setAuditModifyDate2()
     * @uses AccountAddress::setAuditModifyUnitId()
     * @uses AccountAddress::setBarcode_Alias()
     * @uses AccountAddress::setBarterchequeUser()
     * @uses AccountAddress::setBatchInvoice()
     * @uses AccountAddress::setBlock()
     * @uses AccountAddress::setBuildingName()
     * @uses AccountAddress::setBuildingNumber()
     * @uses AccountAddress::setCollectionUnit()
     * @uses AccountAddress::setCourierWorkRangeCode()
     * @uses AccountAddress::setCustomerSpecialMessageText()
     * @uses AccountAddress::setDeliverAtHub()
     * @uses AccountAddress::setDeliverFromHub()
     * @uses AccountAddress::setDoorNumber()
     * @uses AccountAddress::setEInvoiceLabel()
     * @uses AccountAddress::setEmail1()
     * @uses AccountAddress::setEmail2()
     * @uses AccountAddress::setErpNo()
     * @uses AccountAddress::setExceptSelectedUnits()
     * @uses AccountAddress::setFax1()
     * @uses AccountAddress::setFax2()
     * @uses AccountAddress::setForceIntegrationCode()
     * @uses AccountAddress::setForceIntegrationCodeRegex()
     * @uses AccountAddress::setGeoHinterLandId()
     * @uses AccountAddress::setHintAvenue()
     * @uses AccountAddress::setHintCity()
     * @uses AccountAddress::setHintCountry()
     * @uses AccountAddress::setHintDistrict()
     * @uses AccountAddress::setHintField()
     * @uses AccountAddress::setHintQuarter()
     * @uses AccountAddress::setHintStreet()
     * @uses AccountAddress::setHintTown()
     * @uses AccountAddress::setHinterLandId()
     * @uses AccountAddress::setHinterLandStatus()
     * @uses AccountAddress::setIntegrationCode()
     * @uses AccountAddress::setInvoiceAddress()
     * @uses AccountAddress::setInvoiceAddressVersionId()
     * @uses AccountAddress::setInvoiceTitle()
     * @uses AccountAddress::setInvoiceUnit()
     * @uses AccountAddress::setLastUsedDate()
     * @uses AccountAddress::setLastVersion()
     * @uses AccountAddress::setLovAddressKeyId()
     * @uses AccountAddress::setLovAddressStatusId()
     * @uses AccountAddress::setLovAddressType()
     * @uses AccountAddress::setLovApprovedId()
     * @uses AccountAddress::setLovAuditCreatedVersion()
     * @uses AccountAddress::setLovIdentityType()
     * @uses AccountAddress::setLovPolygonLevelId()
     * @uses AccountAddress::setLovTaxExemptReason()
     * @uses AccountAddress::setMobilePhone()
     * @uses AccountAddress::setName()
     * @uses AccountAddress::setPhone1()
     * @uses AccountAddress::setPhone2()
     * @uses AccountAddress::setPostCode()
     * @uses AccountAddress::setSourceUnit()
     * @uses AccountAddress::setTargetUnit()
     * @uses AccountAddress::setTaxExempt()
     * @uses AccountAddress::setTaxExemptreason()
     * @uses AccountAddress::setTaxNumber()
     * @uses AccountAddress::setTaxNumberConfidential()
     * @uses AccountAddress::setTaxOffice()
     * @uses AccountAddress::setTransferDate()
     * @uses AccountAddress::setTransferStatus()
     * @uses AccountAddress::setUncertainCredit()
     * @uses AccountAddress::setUrl()
     * @uses AccountAddress::setUsePricelistService()
     * @uses AccountAddress::setValidAllUnits()
     * @uses AccountAddress::setWithHolding()
     * @uses AccountAddress::setXCoor()
     * @uses AccountAddress::setYCoor()
     * @param string $aa_Everyday
     * @param string $aa_FirstTime
     * @param string $aa_LastTime
     * @param string $acceptCargo
     * @param string $acceptCargoSaturday
     * @param string $acceptCargoWorldwide
     * @param string $acceptContractedShipment
     * @param string $acceptReceiverPayment
     * @param \StructType\AccountModel $account
     * @param string $accountAddressCode
     * @param string $accountAddressId
     * @param string $accountAddressVersionId
     * @param string $accounting
     * @param string $activeVersion
     * @param string $address
     * @param string $addressStatusModifyDate
     * @param int $applicationId
     * @param string $applicationVersion
     * @param string $approveDate
     * @param int $approvedBy
     * @param string $auditCreateDate
     * @param string $auditCreateDate2
     * @param int $auditCreateUnitId
     * @param int $auditCreatedBy
     * @param string $auditDeleted
     * @param int $auditModifiedBy
     * @param string $auditModifyDate
     * @param string $auditModifyDate2
     * @param int $auditModifyUnitId
     * @param string $barcode_Alias
     * @param string $barterchequeUser
     * @param string $batchInvoice
     * @param string $block
     * @param string $buildingName
     * @param string $buildingNumber
     * @param \StructType\Unit $collectionUnit
     * @param string $courierWorkRangeCode
     * @param string $customerSpecialMessageText
     * @param string $deliverAtHub
     * @param string $deliverFromHub
     * @param int $doorNumber
     * @param string $eInvoiceLabel
     * @param string $email1
     * @param string $email2
     * @param string $erpNo
     * @param string $exceptSelectedUnits
     * @param string $fax1
     * @param string $fax2
     * @param string $forceIntegrationCode
     * @param string $forceIntegrationCodeRegex
     * @param int $geoHinterLandId
     * @param string $hintAvenue
     * @param \StructType\HintCity $hintCity
     * @param \StructType\HintCountry $hintCountry
     * @param string $hintDistrict
     * @param string $hintField
     * @param string $hintQuarter
     * @param string $hintStreet
     * @param \StructType\HintTown $hintTown
     * @param string $hinterLandId
     * @param int $hinterLandStatus
     * @param string $integrationCode
     * @param string $invoiceAddress
     * @param string $invoiceAddressVersionId
     * @param string $invoiceTitle
     * @param \StructType\Unit $invoiceUnit
     * @param string $lastUsedDate
     * @param string $lastVersion
     * @param int $lovAddressKeyId
     * @param string $lovAddressStatusId
     * @param \StructType\LovAddressType $lovAddressType
     * @param int $lovApprovedId
     * @param \StructType\LovAuditCreatedVersion $lovAuditCreatedVersion
     * @param \StructType\LovIdentityType $lovIdentityType
     * @param int $lovPolygonLevelId
     * @param \StructType\LovTaxExemptReason $lovTaxExemptReason
     * @param string $mobilePhone
     * @param string $name
     * @param string $phone1
     * @param string $phone2
     * @param string $postCode
     * @param \StructType\Unit $sourceUnit
     * @param \StructType\Unit $targetUnit
     * @param string $taxExempt
     * @param string $taxExemptreason
     * @param string $taxNumber
     * @param string $taxNumberConfidential
     * @param string $taxOffice
     * @param string $transferDate
     * @param string $transferStatus
     * @param string $uncertainCredit
     * @param string $url
     * @param string $usePricelistService
     * @param string $validAllUnits
     * @param string $withHolding
     * @param string $xCoor
     * @param string $yCoor
     */
    public function __construct($aa_Everyday = null, $aa_FirstTime = null, $aa_LastTime = null, $acceptCargo = null, $acceptCargoSaturday = null, $acceptCargoWorldwide = null, $acceptContractedShipment = null, $acceptReceiverPayment = null, \StructType\AccountModel $account = null, $accountAddressCode = null, $accountAddressId = null, $accountAddressVersionId = null, $accounting = null, $activeVersion = null, $address = null, $addressStatusModifyDate = null, $applicationId = null, $applicationVersion = null, $approveDate = null, $approvedBy = null, $auditCreateDate = null, $auditCreateDate2 = null, $auditCreateUnitId = null, $auditCreatedBy = null, $auditDeleted = null, $auditModifiedBy = null, $auditModifyDate = null, $auditModifyDate2 = null, $auditModifyUnitId = null, $barcode_Alias = null, $barterchequeUser = null, $batchInvoice = null, $block = null, $buildingName = null, $buildingNumber = null, \StructType\Unit $collectionUnit = null, $courierWorkRangeCode = null, $customerSpecialMessageText = null, $deliverAtHub = null, $deliverFromHub = null, $doorNumber = null, $eInvoiceLabel = null, $email1 = null, $email2 = null, $erpNo = null, $exceptSelectedUnits = null, $fax1 = null, $fax2 = null, $forceIntegrationCode = null, $forceIntegrationCodeRegex = null, $geoHinterLandId = null, $hintAvenue = null, \StructType\HintCity $hintCity = null, \StructType\HintCountry $hintCountry = null, $hintDistrict = null, $hintField = null, $hintQuarter = null, $hintStreet = null, \StructType\HintTown $hintTown = null, $hinterLandId = null, $hinterLandStatus = null, $integrationCode = null, $invoiceAddress = null, $invoiceAddressVersionId = null, $invoiceTitle = null, \StructType\Unit $invoiceUnit = null, $lastUsedDate = null, $lastVersion = null, $lovAddressKeyId = null, $lovAddressStatusId = null, \StructType\LovAddressType $lovAddressType = null, $lovApprovedId = null, \StructType\LovAuditCreatedVersion $lovAuditCreatedVersion = null, \StructType\LovIdentityType $lovIdentityType = null, $lovPolygonLevelId = null, \StructType\LovTaxExemptReason $lovTaxExemptReason = null, $mobilePhone = null, $name = null, $phone1 = null, $phone2 = null, $postCode = null, \StructType\Unit $sourceUnit = null, \StructType\Unit $targetUnit = null, $taxExempt = null, $taxExemptreason = null, $taxNumber = null, $taxNumberConfidential = null, $taxOffice = null, $transferDate = null, $transferStatus = null, $uncertainCredit = null, $url = null, $usePricelistService = null, $validAllUnits = null, $withHolding = null, $xCoor = null, $yCoor = null)
    {
        $this
            ->setAa_Everyday($aa_Everyday)
            ->setAa_FirstTime($aa_FirstTime)
            ->setAa_LastTime($aa_LastTime)
            ->setAcceptCargo($acceptCargo)
            ->setAcceptCargoSaturday($acceptCargoSaturday)
            ->setAcceptCargoWorldwide($acceptCargoWorldwide)
            ->setAcceptContractedShipment($acceptContractedShipment)
            ->setAcceptReceiverPayment($acceptReceiverPayment)
            ->setAccount($account)
            ->setAccountAddressCode($accountAddressCode)
            ->setAccountAddressId($accountAddressId)
            ->setAccountAddressVersionId($accountAddressVersionId)
            ->setAccounting($accounting)
            ->setActiveVersion($activeVersion)
            ->setAddress($address)
            ->setAddressStatusModifyDate($addressStatusModifyDate)
            ->setApplicationId($applicationId)
            ->setApplicationVersion($applicationVersion)
            ->setApproveDate($approveDate)
            ->setApprovedBy($approvedBy)
            ->setAuditCreateDate($auditCreateDate)
            ->setAuditCreateDate2($auditCreateDate2)
            ->setAuditCreateUnitId($auditCreateUnitId)
            ->setAuditCreatedBy($auditCreatedBy)
            ->setAuditDeleted($auditDeleted)
            ->setAuditModifiedBy($auditModifiedBy)
            ->setAuditModifyDate($auditModifyDate)
            ->setAuditModifyDate2($auditModifyDate2)
            ->setAuditModifyUnitId($auditModifyUnitId)
            ->setBarcode_Alias($barcode_Alias)
            ->setBarterchequeUser($barterchequeUser)
            ->setBatchInvoice($batchInvoice)
            ->setBlock($block)
            ->setBuildingName($buildingName)
            ->setBuildingNumber($buildingNumber)
            ->setCollectionUnit($collectionUnit)
            ->setCourierWorkRangeCode($courierWorkRangeCode)
            ->setCustomerSpecialMessageText($customerSpecialMessageText)
            ->setDeliverAtHub($deliverAtHub)
            ->setDeliverFromHub($deliverFromHub)
            ->setDoorNumber($doorNumber)
            ->setEInvoiceLabel($eInvoiceLabel)
            ->setEmail1($email1)
            ->setEmail2($email2)
            ->setErpNo($erpNo)
            ->setExceptSelectedUnits($exceptSelectedUnits)
            ->setFax1($fax1)
            ->setFax2($fax2)
            ->setForceIntegrationCode($forceIntegrationCode)
            ->setForceIntegrationCodeRegex($forceIntegrationCodeRegex)
            ->setGeoHinterLandId($geoHinterLandId)
            ->setHintAvenue($hintAvenue)
            ->setHintCity($hintCity)
            ->setHintCountry($hintCountry)
            ->setHintDistrict($hintDistrict)
            ->setHintField($hintField)
            ->setHintQuarter($hintQuarter)
            ->setHintStreet($hintStreet)
            ->setHintTown($hintTown)
            ->setHinterLandId($hinterLandId)
            ->setHinterLandStatus($hinterLandStatus)
            ->setIntegrationCode($integrationCode)
            ->setInvoiceAddress($invoiceAddress)
            ->setInvoiceAddressVersionId($invoiceAddressVersionId)
            ->setInvoiceTitle($invoiceTitle)
            ->setInvoiceUnit($invoiceUnit)
            ->setLastUsedDate($lastUsedDate)
            ->setLastVersion($lastVersion)
            ->setLovAddressKeyId($lovAddressKeyId)
            ->setLovAddressStatusId($lovAddressStatusId)
            ->setLovAddressType($lovAddressType)
            ->setLovApprovedId($lovApprovedId)
            ->setLovAuditCreatedVersion($lovAuditCreatedVersion)
            ->setLovIdentityType($lovIdentityType)
            ->setLovPolygonLevelId($lovPolygonLevelId)
            ->setLovTaxExemptReason($lovTaxExemptReason)
            ->setMobilePhone($mobilePhone)
            ->setName($name)
            ->setPhone1($phone1)
            ->setPhone2($phone2)
            ->setPostCode($postCode)
            ->setSourceUnit($sourceUnit)
            ->setTargetUnit($targetUnit)
            ->setTaxExempt($taxExempt)
            ->setTaxExemptreason($taxExemptreason)
            ->setTaxNumber($taxNumber)
            ->setTaxNumberConfidential($taxNumberConfidential)
            ->setTaxOffice($taxOffice)
            ->setTransferDate($transferDate)
            ->setTransferStatus($transferStatus)
            ->setUncertainCredit($uncertainCredit)
            ->setUrl($url)
            ->setUsePricelistService($usePricelistService)
            ->setValidAllUnits($validAllUnits)
            ->setWithHolding($withHolding)
            ->setXCoor($xCoor)
            ->setYCoor($yCoor);
    }
    /**
     * Get Aa_Everyday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAa_Everyday()
    {
        return isset($this->Aa_Everyday) ? $this->Aa_Everyday : null;
    }
    /**
     * Set Aa_Everyday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aa_Everyday
     * @return \StructType\AccountAddress
     */
    public function setAa_Everyday($aa_Everyday = null)
    {
        // validation for constraint: string
        if (!is_null($aa_Everyday) && !is_string($aa_Everyday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aa_Everyday, true), gettype($aa_Everyday)), __LINE__);
        }
        if (is_null($aa_Everyday) || (is_array($aa_Everyday) && empty($aa_Everyday))) {
            unset($this->Aa_Everyday);
        } else {
            $this->Aa_Everyday = $aa_Everyday;
        }
        return $this;
    }
    /**
     * Get Aa_FirstTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAa_FirstTime()
    {
        return isset($this->Aa_FirstTime) ? $this->Aa_FirstTime : null;
    }
    /**
     * Set Aa_FirstTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aa_FirstTime
     * @return \StructType\AccountAddress
     */
    public function setAa_FirstTime($aa_FirstTime = null)
    {
        // validation for constraint: string
        if (!is_null($aa_FirstTime) && !is_string($aa_FirstTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aa_FirstTime, true), gettype($aa_FirstTime)), __LINE__);
        }
        if (is_null($aa_FirstTime) || (is_array($aa_FirstTime) && empty($aa_FirstTime))) {
            unset($this->Aa_FirstTime);
        } else {
            $this->Aa_FirstTime = $aa_FirstTime;
        }
        return $this;
    }
    /**
     * Get Aa_LastTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAa_LastTime()
    {
        return isset($this->Aa_LastTime) ? $this->Aa_LastTime : null;
    }
    /**
     * Set Aa_LastTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aa_LastTime
     * @return \StructType\AccountAddress
     */
    public function setAa_LastTime($aa_LastTime = null)
    {
        // validation for constraint: string
        if (!is_null($aa_LastTime) && !is_string($aa_LastTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aa_LastTime, true), gettype($aa_LastTime)), __LINE__);
        }
        if (is_null($aa_LastTime) || (is_array($aa_LastTime) && empty($aa_LastTime))) {
            unset($this->Aa_LastTime);
        } else {
            $this->Aa_LastTime = $aa_LastTime;
        }
        return $this;
    }
    /**
     * Get AcceptCargo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcceptCargo()
    {
        return isset($this->AcceptCargo) ? $this->AcceptCargo : null;
    }
    /**
     * Set AcceptCargo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acceptCargo
     * @return \StructType\AccountAddress
     */
    public function setAcceptCargo($acceptCargo = null)
    {
        // validation for constraint: string
        if (!is_null($acceptCargo) && !is_string($acceptCargo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptCargo, true), gettype($acceptCargo)), __LINE__);
        }
        if (is_null($acceptCargo) || (is_array($acceptCargo) && empty($acceptCargo))) {
            unset($this->AcceptCargo);
        } else {
            $this->AcceptCargo = $acceptCargo;
        }
        return $this;
    }
    /**
     * Get AcceptCargoSaturday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcceptCargoSaturday()
    {
        return isset($this->AcceptCargoSaturday) ? $this->AcceptCargoSaturday : null;
    }
    /**
     * Set AcceptCargoSaturday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acceptCargoSaturday
     * @return \StructType\AccountAddress
     */
    public function setAcceptCargoSaturday($acceptCargoSaturday = null)
    {
        // validation for constraint: string
        if (!is_null($acceptCargoSaturday) && !is_string($acceptCargoSaturday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptCargoSaturday, true), gettype($acceptCargoSaturday)), __LINE__);
        }
        if (is_null($acceptCargoSaturday) || (is_array($acceptCargoSaturday) && empty($acceptCargoSaturday))) {
            unset($this->AcceptCargoSaturday);
        } else {
            $this->AcceptCargoSaturday = $acceptCargoSaturday;
        }
        return $this;
    }
    /**
     * Get AcceptCargoWorldwide value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcceptCargoWorldwide()
    {
        return isset($this->AcceptCargoWorldwide) ? $this->AcceptCargoWorldwide : null;
    }
    /**
     * Set AcceptCargoWorldwide value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acceptCargoWorldwide
     * @return \StructType\AccountAddress
     */
    public function setAcceptCargoWorldwide($acceptCargoWorldwide = null)
    {
        // validation for constraint: string
        if (!is_null($acceptCargoWorldwide) && !is_string($acceptCargoWorldwide)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptCargoWorldwide, true), gettype($acceptCargoWorldwide)), __LINE__);
        }
        if (is_null($acceptCargoWorldwide) || (is_array($acceptCargoWorldwide) && empty($acceptCargoWorldwide))) {
            unset($this->AcceptCargoWorldwide);
        } else {
            $this->AcceptCargoWorldwide = $acceptCargoWorldwide;
        }
        return $this;
    }
    /**
     * Get AcceptContractedShipment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcceptContractedShipment()
    {
        return isset($this->AcceptContractedShipment) ? $this->AcceptContractedShipment : null;
    }
    /**
     * Set AcceptContractedShipment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acceptContractedShipment
     * @return \StructType\AccountAddress
     */
    public function setAcceptContractedShipment($acceptContractedShipment = null)
    {
        // validation for constraint: string
        if (!is_null($acceptContractedShipment) && !is_string($acceptContractedShipment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptContractedShipment, true), gettype($acceptContractedShipment)), __LINE__);
        }
        if (is_null($acceptContractedShipment) || (is_array($acceptContractedShipment) && empty($acceptContractedShipment))) {
            unset($this->AcceptContractedShipment);
        } else {
            $this->AcceptContractedShipment = $acceptContractedShipment;
        }
        return $this;
    }
    /**
     * Get AcceptReceiverPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcceptReceiverPayment()
    {
        return isset($this->AcceptReceiverPayment) ? $this->AcceptReceiverPayment : null;
    }
    /**
     * Set AcceptReceiverPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acceptReceiverPayment
     * @return \StructType\AccountAddress
     */
    public function setAcceptReceiverPayment($acceptReceiverPayment = null)
    {
        // validation for constraint: string
        if (!is_null($acceptReceiverPayment) && !is_string($acceptReceiverPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptReceiverPayment, true), gettype($acceptReceiverPayment)), __LINE__);
        }
        if (is_null($acceptReceiverPayment) || (is_array($acceptReceiverPayment) && empty($acceptReceiverPayment))) {
            unset($this->AcceptReceiverPayment);
        } else {
            $this->AcceptReceiverPayment = $acceptReceiverPayment;
        }
        return $this;
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AccountModel|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AccountModel $account
     * @return \StructType\AccountAddress
     */
    public function setAccount(\StructType\AccountModel $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get AccountAddressCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountAddressCode()
    {
        return isset($this->AccountAddressCode) ? $this->AccountAddressCode : null;
    }
    /**
     * Set AccountAddressCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountAddressCode
     * @return \StructType\AccountAddress
     */
    public function setAccountAddressCode($accountAddressCode = null)
    {
        // validation for constraint: string
        if (!is_null($accountAddressCode) && !is_string($accountAddressCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountAddressCode, true), gettype($accountAddressCode)), __LINE__);
        }
        if (is_null($accountAddressCode) || (is_array($accountAddressCode) && empty($accountAddressCode))) {
            unset($this->AccountAddressCode);
        } else {
            $this->AccountAddressCode = $accountAddressCode;
        }
        return $this;
    }
    /**
     * Get AccountAddressId value
     * @return string|null
     */
    public function getAccountAddressId()
    {
        return $this->AccountAddressId;
    }
    /**
     * Set AccountAddressId value
     * @param string $accountAddressId
     * @return \StructType\AccountAddress
     */
    public function setAccountAddressId($accountAddressId = null)
    {
        // validation for constraint: string
        if (!is_null($accountAddressId) && !is_string($accountAddressId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountAddressId, true), gettype($accountAddressId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountAddressId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountAddressId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountAddressId, true)), __LINE__);
        }
        $this->AccountAddressId = $accountAddressId;
        return $this;
    }
    /**
     * Get AccountAddressVersionId value
     * @return string|null
     */
    public function getAccountAddressVersionId()
    {
        return $this->AccountAddressVersionId;
    }
    /**
     * Set AccountAddressVersionId value
     * @param string $accountAddressVersionId
     * @return \StructType\AccountAddress
     */
    public function setAccountAddressVersionId($accountAddressVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($accountAddressVersionId) && !is_string($accountAddressVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountAddressVersionId, true), gettype($accountAddressVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountAddressVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountAddressVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountAddressVersionId, true)), __LINE__);
        }
        $this->AccountAddressVersionId = $accountAddressVersionId;
        return $this;
    }
    /**
     * Get Accounting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccounting()
    {
        return isset($this->Accounting) ? $this->Accounting : null;
    }
    /**
     * Set Accounting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accounting
     * @return \StructType\AccountAddress
     */
    public function setAccounting($accounting = null)
    {
        // validation for constraint: string
        if (!is_null($accounting) && !is_string($accounting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accounting, true), gettype($accounting)), __LINE__);
        }
        if (is_null($accounting) || (is_array($accounting) && empty($accounting))) {
            unset($this->Accounting);
        } else {
            $this->Accounting = $accounting;
        }
        return $this;
    }
    /**
     * Get ActiveVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActiveVersion()
    {
        return isset($this->ActiveVersion) ? $this->ActiveVersion : null;
    }
    /**
     * Set ActiveVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activeVersion
     * @return \StructType\AccountAddress
     */
    public function setActiveVersion($activeVersion = null)
    {
        // validation for constraint: string
        if (!is_null($activeVersion) && !is_string($activeVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activeVersion, true), gettype($activeVersion)), __LINE__);
        }
        if (is_null($activeVersion) || (is_array($activeVersion) && empty($activeVersion))) {
            unset($this->ActiveVersion);
        } else {
            $this->ActiveVersion = $activeVersion;
        }
        return $this;
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address
     * @return \StructType\AccountAddress
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get AddressStatusModifyDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressStatusModifyDate()
    {
        return isset($this->AddressStatusModifyDate) ? $this->AddressStatusModifyDate : null;
    }
    /**
     * Set AddressStatusModifyDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressStatusModifyDate
     * @return \StructType\AccountAddress
     */
    public function setAddressStatusModifyDate($addressStatusModifyDate = null)
    {
        // validation for constraint: string
        if (!is_null($addressStatusModifyDate) && !is_string($addressStatusModifyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressStatusModifyDate, true), gettype($addressStatusModifyDate)), __LINE__);
        }
        if (is_null($addressStatusModifyDate) || (is_array($addressStatusModifyDate) && empty($addressStatusModifyDate))) {
            unset($this->AddressStatusModifyDate);
        } else {
            $this->AddressStatusModifyDate = $addressStatusModifyDate;
        }
        return $this;
    }
    /**
     * Get ApplicationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getApplicationId()
    {
        return isset($this->ApplicationId) ? $this->ApplicationId : null;
    }
    /**
     * Set ApplicationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $applicationId
     * @return \StructType\AccountAddress
     */
    public function setApplicationId($applicationId = null)
    {
        // validation for constraint: int
        if (!is_null($applicationId) && !(is_int($applicationId) || ctype_digit($applicationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($applicationId, true), gettype($applicationId)), __LINE__);
        }
        if (is_null($applicationId) || (is_array($applicationId) && empty($applicationId))) {
            unset($this->ApplicationId);
        } else {
            $this->ApplicationId = $applicationId;
        }
        return $this;
    }
    /**
     * Get ApplicationVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationVersion()
    {
        return isset($this->ApplicationVersion) ? $this->ApplicationVersion : null;
    }
    /**
     * Set ApplicationVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationVersion
     * @return \StructType\AccountAddress
     */
    public function setApplicationVersion($applicationVersion = null)
    {
        // validation for constraint: string
        if (!is_null($applicationVersion) && !is_string($applicationVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationVersion, true), gettype($applicationVersion)), __LINE__);
        }
        if (is_null($applicationVersion) || (is_array($applicationVersion) && empty($applicationVersion))) {
            unset($this->ApplicationVersion);
        } else {
            $this->ApplicationVersion = $applicationVersion;
        }
        return $this;
    }
    /**
     * Get ApproveDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApproveDate()
    {
        return isset($this->ApproveDate) ? $this->ApproveDate : null;
    }
    /**
     * Set ApproveDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $approveDate
     * @return \StructType\AccountAddress
     */
    public function setApproveDate($approveDate = null)
    {
        // validation for constraint: string
        if (!is_null($approveDate) && !is_string($approveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approveDate, true), gettype($approveDate)), __LINE__);
        }
        if (is_null($approveDate) || (is_array($approveDate) && empty($approveDate))) {
            unset($this->ApproveDate);
        } else {
            $this->ApproveDate = $approveDate;
        }
        return $this;
    }
    /**
     * Get ApprovedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getApprovedBy()
    {
        return isset($this->ApprovedBy) ? $this->ApprovedBy : null;
    }
    /**
     * Set ApprovedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $approvedBy
     * @return \StructType\AccountAddress
     */
    public function setApprovedBy($approvedBy = null)
    {
        // validation for constraint: int
        if (!is_null($approvedBy) && !(is_int($approvedBy) || ctype_digit($approvedBy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($approvedBy, true), gettype($approvedBy)), __LINE__);
        }
        if (is_null($approvedBy) || (is_array($approvedBy) && empty($approvedBy))) {
            unset($this->ApprovedBy);
        } else {
            $this->ApprovedBy = $approvedBy;
        }
        return $this;
    }
    /**
     * Get AuditCreateDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditCreateDate()
    {
        return isset($this->AuditCreateDate) ? $this->AuditCreateDate : null;
    }
    /**
     * Set AuditCreateDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditCreateDate
     * @return \StructType\AccountAddress
     */
    public function setAuditCreateDate($auditCreateDate = null)
    {
        // validation for constraint: string
        if (!is_null($auditCreateDate) && !is_string($auditCreateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditCreateDate, true), gettype($auditCreateDate)), __LINE__);
        }
        if (is_null($auditCreateDate) || (is_array($auditCreateDate) && empty($auditCreateDate))) {
            unset($this->AuditCreateDate);
        } else {
            $this->AuditCreateDate = $auditCreateDate;
        }
        return $this;
    }
    /**
     * Get AuditCreateDate2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditCreateDate2()
    {
        return isset($this->AuditCreateDate2) ? $this->AuditCreateDate2 : null;
    }
    /**
     * Set AuditCreateDate2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditCreateDate2
     * @return \StructType\AccountAddress
     */
    public function setAuditCreateDate2($auditCreateDate2 = null)
    {
        // validation for constraint: string
        if (!is_null($auditCreateDate2) && !is_string($auditCreateDate2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditCreateDate2, true), gettype($auditCreateDate2)), __LINE__);
        }
        if (is_null($auditCreateDate2) || (is_array($auditCreateDate2) && empty($auditCreateDate2))) {
            unset($this->AuditCreateDate2);
        } else {
            $this->AuditCreateDate2 = $auditCreateDate2;
        }
        return $this;
    }
    /**
     * Get AuditCreateUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditCreateUnitId()
    {
        return isset($this->AuditCreateUnitId) ? $this->AuditCreateUnitId : null;
    }
    /**
     * Set AuditCreateUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditCreateUnitId
     * @return \StructType\AccountAddress
     */
    public function setAuditCreateUnitId($auditCreateUnitId = null)
    {
        // validation for constraint: int
        if (!is_null($auditCreateUnitId) && !(is_int($auditCreateUnitId) || ctype_digit($auditCreateUnitId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditCreateUnitId, true), gettype($auditCreateUnitId)), __LINE__);
        }
        if (is_null($auditCreateUnitId) || (is_array($auditCreateUnitId) && empty($auditCreateUnitId))) {
            unset($this->AuditCreateUnitId);
        } else {
            $this->AuditCreateUnitId = $auditCreateUnitId;
        }
        return $this;
    }
    /**
     * Get AuditCreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditCreatedBy()
    {
        return isset($this->AuditCreatedBy) ? $this->AuditCreatedBy : null;
    }
    /**
     * Set AuditCreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditCreatedBy
     * @return \StructType\AccountAddress
     */
    public function setAuditCreatedBy($auditCreatedBy = null)
    {
        // validation for constraint: int
        if (!is_null($auditCreatedBy) && !(is_int($auditCreatedBy) || ctype_digit($auditCreatedBy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditCreatedBy, true), gettype($auditCreatedBy)), __LINE__);
        }
        if (is_null($auditCreatedBy) || (is_array($auditCreatedBy) && empty($auditCreatedBy))) {
            unset($this->AuditCreatedBy);
        } else {
            $this->AuditCreatedBy = $auditCreatedBy;
        }
        return $this;
    }
    /**
     * Get AuditDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditDeleted()
    {
        return isset($this->AuditDeleted) ? $this->AuditDeleted : null;
    }
    /**
     * Set AuditDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditDeleted
     * @return \StructType\AccountAddress
     */
    public function setAuditDeleted($auditDeleted = null)
    {
        // validation for constraint: string
        if (!is_null($auditDeleted) && !is_string($auditDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditDeleted, true), gettype($auditDeleted)), __LINE__);
        }
        if (is_null($auditDeleted) || (is_array($auditDeleted) && empty($auditDeleted))) {
            unset($this->AuditDeleted);
        } else {
            $this->AuditDeleted = $auditDeleted;
        }
        return $this;
    }
    /**
     * Get AuditModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditModifiedBy()
    {
        return isset($this->AuditModifiedBy) ? $this->AuditModifiedBy : null;
    }
    /**
     * Set AuditModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditModifiedBy
     * @return \StructType\AccountAddress
     */
    public function setAuditModifiedBy($auditModifiedBy = null)
    {
        // validation for constraint: int
        if (!is_null($auditModifiedBy) && !(is_int($auditModifiedBy) || ctype_digit($auditModifiedBy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditModifiedBy, true), gettype($auditModifiedBy)), __LINE__);
        }
        if (is_null($auditModifiedBy) || (is_array($auditModifiedBy) && empty($auditModifiedBy))) {
            unset($this->AuditModifiedBy);
        } else {
            $this->AuditModifiedBy = $auditModifiedBy;
        }
        return $this;
    }
    /**
     * Get AuditModifyDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditModifyDate()
    {
        return isset($this->AuditModifyDate) ? $this->AuditModifyDate : null;
    }
    /**
     * Set AuditModifyDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditModifyDate
     * @return \StructType\AccountAddress
     */
    public function setAuditModifyDate($auditModifyDate = null)
    {
        // validation for constraint: string
        if (!is_null($auditModifyDate) && !is_string($auditModifyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditModifyDate, true), gettype($auditModifyDate)), __LINE__);
        }
        if (is_null($auditModifyDate) || (is_array($auditModifyDate) && empty($auditModifyDate))) {
            unset($this->AuditModifyDate);
        } else {
            $this->AuditModifyDate = $auditModifyDate;
        }
        return $this;
    }
    /**
     * Get AuditModifyDate2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuditModifyDate2()
    {
        return isset($this->AuditModifyDate2) ? $this->AuditModifyDate2 : null;
    }
    /**
     * Set AuditModifyDate2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auditModifyDate2
     * @return \StructType\AccountAddress
     */
    public function setAuditModifyDate2($auditModifyDate2 = null)
    {
        // validation for constraint: string
        if (!is_null($auditModifyDate2) && !is_string($auditModifyDate2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditModifyDate2, true), gettype($auditModifyDate2)), __LINE__);
        }
        if (is_null($auditModifyDate2) || (is_array($auditModifyDate2) && empty($auditModifyDate2))) {
            unset($this->AuditModifyDate2);
        } else {
            $this->AuditModifyDate2 = $auditModifyDate2;
        }
        return $this;
    }
    /**
     * Get AuditModifyUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditModifyUnitId()
    {
        return isset($this->AuditModifyUnitId) ? $this->AuditModifyUnitId : null;
    }
    /**
     * Set AuditModifyUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditModifyUnitId
     * @return \StructType\AccountAddress
     */
    public function setAuditModifyUnitId($auditModifyUnitId = null)
    {
        // validation for constraint: int
        if (!is_null($auditModifyUnitId) && !(is_int($auditModifyUnitId) || ctype_digit($auditModifyUnitId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditModifyUnitId, true), gettype($auditModifyUnitId)), __LINE__);
        }
        if (is_null($auditModifyUnitId) || (is_array($auditModifyUnitId) && empty($auditModifyUnitId))) {
            unset($this->AuditModifyUnitId);
        } else {
            $this->AuditModifyUnitId = $auditModifyUnitId;
        }
        return $this;
    }
    /**
     * Get Barcode_Alias value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode_Alias()
    {
        return isset($this->Barcode_Alias) ? $this->Barcode_Alias : null;
    }
    /**
     * Set Barcode_Alias value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode_Alias
     * @return \StructType\AccountAddress
     */
    public function setBarcode_Alias($barcode_Alias = null)
    {
        // validation for constraint: string
        if (!is_null($barcode_Alias) && !is_string($barcode_Alias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode_Alias, true), gettype($barcode_Alias)), __LINE__);
        }
        if (is_null($barcode_Alias) || (is_array($barcode_Alias) && empty($barcode_Alias))) {
            unset($this->Barcode_Alias);
        } else {
            $this->Barcode_Alias = $barcode_Alias;
        }
        return $this;
    }
    /**
     * Get BarterchequeUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarterchequeUser()
    {
        return isset($this->BarterchequeUser) ? $this->BarterchequeUser : null;
    }
    /**
     * Set BarterchequeUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barterchequeUser
     * @return \StructType\AccountAddress
     */
    public function setBarterchequeUser($barterchequeUser = null)
    {
        // validation for constraint: string
        if (!is_null($barterchequeUser) && !is_string($barterchequeUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barterchequeUser, true), gettype($barterchequeUser)), __LINE__);
        }
        if (is_null($barterchequeUser) || (is_array($barterchequeUser) && empty($barterchequeUser))) {
            unset($this->BarterchequeUser);
        } else {
            $this->BarterchequeUser = $barterchequeUser;
        }
        return $this;
    }
    /**
     * Get BatchInvoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchInvoice()
    {
        return isset($this->BatchInvoice) ? $this->BatchInvoice : null;
    }
    /**
     * Set BatchInvoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchInvoice
     * @return \StructType\AccountAddress
     */
    public function setBatchInvoice($batchInvoice = null)
    {
        // validation for constraint: string
        if (!is_null($batchInvoice) && !is_string($batchInvoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchInvoice, true), gettype($batchInvoice)), __LINE__);
        }
        if (is_null($batchInvoice) || (is_array($batchInvoice) && empty($batchInvoice))) {
            unset($this->BatchInvoice);
        } else {
            $this->BatchInvoice = $batchInvoice;
        }
        return $this;
    }
    /**
     * Get Block value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBlock()
    {
        return isset($this->Block) ? $this->Block : null;
    }
    /**
     * Set Block value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $block
     * @return \StructType\AccountAddress
     */
    public function setBlock($block = null)
    {
        // validation for constraint: string
        if (!is_null($block) && !is_string($block)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($block, true), gettype($block)), __LINE__);
        }
        if (is_null($block) || (is_array($block) && empty($block))) {
            unset($this->Block);
        } else {
            $this->Block = $block;
        }
        return $this;
    }
    /**
     * Get BuildingName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBuildingName()
    {
        return isset($this->BuildingName) ? $this->BuildingName : null;
    }
    /**
     * Set BuildingName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $buildingName
     * @return \StructType\AccountAddress
     */
    public function setBuildingName($buildingName = null)
    {
        // validation for constraint: string
        if (!is_null($buildingName) && !is_string($buildingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildingName, true), gettype($buildingName)), __LINE__);
        }
        if (is_null($buildingName) || (is_array($buildingName) && empty($buildingName))) {
            unset($this->BuildingName);
        } else {
            $this->BuildingName = $buildingName;
        }
        return $this;
    }
    /**
     * Get BuildingNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBuildingNumber()
    {
        return isset($this->BuildingNumber) ? $this->BuildingNumber : null;
    }
    /**
     * Set BuildingNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $buildingNumber
     * @return \StructType\AccountAddress
     */
    public function setBuildingNumber($buildingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($buildingNumber) && !is_string($buildingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildingNumber, true), gettype($buildingNumber)), __LINE__);
        }
        if (is_null($buildingNumber) || (is_array($buildingNumber) && empty($buildingNumber))) {
            unset($this->BuildingNumber);
        } else {
            $this->BuildingNumber = $buildingNumber;
        }
        return $this;
    }
    /**
     * Get CollectionUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Unit|null
     */
    public function getCollectionUnit()
    {
        return isset($this->CollectionUnit) ? $this->CollectionUnit : null;
    }
    /**
     * Set CollectionUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Unit $collectionUnit
     * @return \StructType\AccountAddress
     */
    public function setCollectionUnit(\StructType\Unit $collectionUnit = null)
    {
        if (is_null($collectionUnit) || (is_array($collectionUnit) && empty($collectionUnit))) {
            unset($this->CollectionUnit);
        } else {
            $this->CollectionUnit = $collectionUnit;
        }
        return $this;
    }
    /**
     * Get CourierWorkRangeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCourierWorkRangeCode()
    {
        return isset($this->CourierWorkRangeCode) ? $this->CourierWorkRangeCode : null;
    }
    /**
     * Set CourierWorkRangeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $courierWorkRangeCode
     * @return \StructType\AccountAddress
     */
    public function setCourierWorkRangeCode($courierWorkRangeCode = null)
    {
        // validation for constraint: string
        if (!is_null($courierWorkRangeCode) && !is_string($courierWorkRangeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($courierWorkRangeCode, true), gettype($courierWorkRangeCode)), __LINE__);
        }
        if (is_null($courierWorkRangeCode) || (is_array($courierWorkRangeCode) && empty($courierWorkRangeCode))) {
            unset($this->CourierWorkRangeCode);
        } else {
            $this->CourierWorkRangeCode = $courierWorkRangeCode;
        }
        return $this;
    }
    /**
     * Get CustomerSpecialMessageText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerSpecialMessageText()
    {
        return isset($this->CustomerSpecialMessageText) ? $this->CustomerSpecialMessageText : null;
    }
    /**
     * Set CustomerSpecialMessageText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerSpecialMessageText
     * @return \StructType\AccountAddress
     */
    public function setCustomerSpecialMessageText($customerSpecialMessageText = null)
    {
        // validation for constraint: string
        if (!is_null($customerSpecialMessageText) && !is_string($customerSpecialMessageText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerSpecialMessageText, true), gettype($customerSpecialMessageText)), __LINE__);
        }
        if (is_null($customerSpecialMessageText) || (is_array($customerSpecialMessageText) && empty($customerSpecialMessageText))) {
            unset($this->CustomerSpecialMessageText);
        } else {
            $this->CustomerSpecialMessageText = $customerSpecialMessageText;
        }
        return $this;
    }
    /**
     * Get DeliverAtHub value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliverAtHub()
    {
        return isset($this->DeliverAtHub) ? $this->DeliverAtHub : null;
    }
    /**
     * Set DeliverAtHub value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliverAtHub
     * @return \StructType\AccountAddress
     */
    public function setDeliverAtHub($deliverAtHub = null)
    {
        // validation for constraint: string
        if (!is_null($deliverAtHub) && !is_string($deliverAtHub)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliverAtHub, true), gettype($deliverAtHub)), __LINE__);
        }
        if (is_null($deliverAtHub) || (is_array($deliverAtHub) && empty($deliverAtHub))) {
            unset($this->DeliverAtHub);
        } else {
            $this->DeliverAtHub = $deliverAtHub;
        }
        return $this;
    }
    /**
     * Get DeliverFromHub value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliverFromHub()
    {
        return isset($this->DeliverFromHub) ? $this->DeliverFromHub : null;
    }
    /**
     * Set DeliverFromHub value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliverFromHub
     * @return \StructType\AccountAddress
     */
    public function setDeliverFromHub($deliverFromHub = null)
    {
        // validation for constraint: string
        if (!is_null($deliverFromHub) && !is_string($deliverFromHub)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliverFromHub, true), gettype($deliverFromHub)), __LINE__);
        }
        if (is_null($deliverFromHub) || (is_array($deliverFromHub) && empty($deliverFromHub))) {
            unset($this->DeliverFromHub);
        } else {
            $this->DeliverFromHub = $deliverFromHub;
        }
        return $this;
    }
    /**
     * Get DoorNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDoorNumber()
    {
        return isset($this->DoorNumber) ? $this->DoorNumber : null;
    }
    /**
     * Set DoorNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $doorNumber
     * @return \StructType\AccountAddress
     */
    public function setDoorNumber($doorNumber = null)
    {
        // validation for constraint: int
        if (!is_null($doorNumber) && !(is_int($doorNumber) || ctype_digit($doorNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($doorNumber, true), gettype($doorNumber)), __LINE__);
        }
        if (is_null($doorNumber) || (is_array($doorNumber) && empty($doorNumber))) {
            unset($this->DoorNumber);
        } else {
            $this->DoorNumber = $doorNumber;
        }
        return $this;
    }
    /**
     * Get EInvoiceLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEInvoiceLabel()
    {
        return isset($this->EInvoiceLabel) ? $this->EInvoiceLabel : null;
    }
    /**
     * Set EInvoiceLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eInvoiceLabel
     * @return \StructType\AccountAddress
     */
    public function setEInvoiceLabel($eInvoiceLabel = null)
    {
        // validation for constraint: string
        if (!is_null($eInvoiceLabel) && !is_string($eInvoiceLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eInvoiceLabel, true), gettype($eInvoiceLabel)), __LINE__);
        }
        if (is_null($eInvoiceLabel) || (is_array($eInvoiceLabel) && empty($eInvoiceLabel))) {
            unset($this->EInvoiceLabel);
        } else {
            $this->EInvoiceLabel = $eInvoiceLabel;
        }
        return $this;
    }
    /**
     * Get Email1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail1()
    {
        return isset($this->Email1) ? $this->Email1 : null;
    }
    /**
     * Set Email1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email1
     * @return \StructType\AccountAddress
     */
    public function setEmail1($email1 = null)
    {
        // validation for constraint: string
        if (!is_null($email1) && !is_string($email1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email1, true), gettype($email1)), __LINE__);
        }
        if (is_null($email1) || (is_array($email1) && empty($email1))) {
            unset($this->Email1);
        } else {
            $this->Email1 = $email1;
        }
        return $this;
    }
    /**
     * Get Email2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail2()
    {
        return isset($this->Email2) ? $this->Email2 : null;
    }
    /**
     * Set Email2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email2
     * @return \StructType\AccountAddress
     */
    public function setEmail2($email2 = null)
    {
        // validation for constraint: string
        if (!is_null($email2) && !is_string($email2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email2, true), gettype($email2)), __LINE__);
        }
        if (is_null($email2) || (is_array($email2) && empty($email2))) {
            unset($this->Email2);
        } else {
            $this->Email2 = $email2;
        }
        return $this;
    }
    /**
     * Get ErpNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErpNo()
    {
        return isset($this->ErpNo) ? $this->ErpNo : null;
    }
    /**
     * Set ErpNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $erpNo
     * @return \StructType\AccountAddress
     */
    public function setErpNo($erpNo = null)
    {
        // validation for constraint: string
        if (!is_null($erpNo) && !is_string($erpNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erpNo, true), gettype($erpNo)), __LINE__);
        }
        if (is_null($erpNo) || (is_array($erpNo) && empty($erpNo))) {
            unset($this->ErpNo);
        } else {
            $this->ErpNo = $erpNo;
        }
        return $this;
    }
    /**
     * Get ExceptSelectedUnits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExceptSelectedUnits()
    {
        return isset($this->ExceptSelectedUnits) ? $this->ExceptSelectedUnits : null;
    }
    /**
     * Set ExceptSelectedUnits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exceptSelectedUnits
     * @return \StructType\AccountAddress
     */
    public function setExceptSelectedUnits($exceptSelectedUnits = null)
    {
        // validation for constraint: string
        if (!is_null($exceptSelectedUnits) && !is_string($exceptSelectedUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exceptSelectedUnits, true), gettype($exceptSelectedUnits)), __LINE__);
        }
        if (is_null($exceptSelectedUnits) || (is_array($exceptSelectedUnits) && empty($exceptSelectedUnits))) {
            unset($this->ExceptSelectedUnits);
        } else {
            $this->ExceptSelectedUnits = $exceptSelectedUnits;
        }
        return $this;
    }
    /**
     * Get Fax1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax1()
    {
        return isset($this->Fax1) ? $this->Fax1 : null;
    }
    /**
     * Set Fax1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax1
     * @return \StructType\AccountAddress
     */
    public function setFax1($fax1 = null)
    {
        // validation for constraint: string
        if (!is_null($fax1) && !is_string($fax1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax1, true), gettype($fax1)), __LINE__);
        }
        if (is_null($fax1) || (is_array($fax1) && empty($fax1))) {
            unset($this->Fax1);
        } else {
            $this->Fax1 = $fax1;
        }
        return $this;
    }
    /**
     * Get Fax2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax2()
    {
        return isset($this->Fax2) ? $this->Fax2 : null;
    }
    /**
     * Set Fax2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax2
     * @return \StructType\AccountAddress
     */
    public function setFax2($fax2 = null)
    {
        // validation for constraint: string
        if (!is_null($fax2) && !is_string($fax2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax2, true), gettype($fax2)), __LINE__);
        }
        if (is_null($fax2) || (is_array($fax2) && empty($fax2))) {
            unset($this->Fax2);
        } else {
            $this->Fax2 = $fax2;
        }
        return $this;
    }
    /**
     * Get ForceIntegrationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForceIntegrationCode()
    {
        return isset($this->ForceIntegrationCode) ? $this->ForceIntegrationCode : null;
    }
    /**
     * Set ForceIntegrationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forceIntegrationCode
     * @return \StructType\AccountAddress
     */
    public function setForceIntegrationCode($forceIntegrationCode = null)
    {
        // validation for constraint: string
        if (!is_null($forceIntegrationCode) && !is_string($forceIntegrationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forceIntegrationCode, true), gettype($forceIntegrationCode)), __LINE__);
        }
        if (is_null($forceIntegrationCode) || (is_array($forceIntegrationCode) && empty($forceIntegrationCode))) {
            unset($this->ForceIntegrationCode);
        } else {
            $this->ForceIntegrationCode = $forceIntegrationCode;
        }
        return $this;
    }
    /**
     * Get ForceIntegrationCodeRegex value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForceIntegrationCodeRegex()
    {
        return isset($this->ForceIntegrationCodeRegex) ? $this->ForceIntegrationCodeRegex : null;
    }
    /**
     * Set ForceIntegrationCodeRegex value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forceIntegrationCodeRegex
     * @return \StructType\AccountAddress
     */
    public function setForceIntegrationCodeRegex($forceIntegrationCodeRegex = null)
    {
        // validation for constraint: string
        if (!is_null($forceIntegrationCodeRegex) && !is_string($forceIntegrationCodeRegex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forceIntegrationCodeRegex, true), gettype($forceIntegrationCodeRegex)), __LINE__);
        }
        if (is_null($forceIntegrationCodeRegex) || (is_array($forceIntegrationCodeRegex) && empty($forceIntegrationCodeRegex))) {
            unset($this->ForceIntegrationCodeRegex);
        } else {
            $this->ForceIntegrationCodeRegex = $forceIntegrationCodeRegex;
        }
        return $this;
    }
    /**
     * Get GeoHinterLandId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGeoHinterLandId()
    {
        return isset($this->GeoHinterLandId) ? $this->GeoHinterLandId : null;
    }
    /**
     * Set GeoHinterLandId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $geoHinterLandId
     * @return \StructType\AccountAddress
     */
    public function setGeoHinterLandId($geoHinterLandId = null)
    {
        // validation for constraint: int
        if (!is_null($geoHinterLandId) && !(is_int($geoHinterLandId) || ctype_digit($geoHinterLandId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($geoHinterLandId, true), gettype($geoHinterLandId)), __LINE__);
        }
        if (is_null($geoHinterLandId) || (is_array($geoHinterLandId) && empty($geoHinterLandId))) {
            unset($this->GeoHinterLandId);
        } else {
            $this->GeoHinterLandId = $geoHinterLandId;
        }
        return $this;
    }
    /**
     * Get HintAvenue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHintAvenue()
    {
        return isset($this->HintAvenue) ? $this->HintAvenue : null;
    }
    /**
     * Set HintAvenue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hintAvenue
     * @return \StructType\AccountAddress
     */
    public function setHintAvenue($hintAvenue = null)
    {
        // validation for constraint: string
        if (!is_null($hintAvenue) && !is_string($hintAvenue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hintAvenue, true), gettype($hintAvenue)), __LINE__);
        }
        if (is_null($hintAvenue) || (is_array($hintAvenue) && empty($hintAvenue))) {
            unset($this->HintAvenue);
        } else {
            $this->HintAvenue = $hintAvenue;
        }
        return $this;
    }
    /**
     * Get HintCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HintCity|null
     */
    public function getHintCity()
    {
        return isset($this->HintCity) ? $this->HintCity : null;
    }
    /**
     * Set HintCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\HintCity $hintCity
     * @return \StructType\AccountAddress
     */
    public function setHintCity(\StructType\HintCity $hintCity = null)
    {
        if (is_null($hintCity) || (is_array($hintCity) && empty($hintCity))) {
            unset($this->HintCity);
        } else {
            $this->HintCity = $hintCity;
        }
        return $this;
    }
    /**
     * Get HintCountry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HintCountry|null
     */
    public function getHintCountry()
    {
        return isset($this->HintCountry) ? $this->HintCountry : null;
    }
    /**
     * Set HintCountry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\HintCountry $hintCountry
     * @return \StructType\AccountAddress
     */
    public function setHintCountry(\StructType\HintCountry $hintCountry = null)
    {
        if (is_null($hintCountry) || (is_array($hintCountry) && empty($hintCountry))) {
            unset($this->HintCountry);
        } else {
            $this->HintCountry = $hintCountry;
        }
        return $this;
    }
    /**
     * Get HintDistrict value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHintDistrict()
    {
        return isset($this->HintDistrict) ? $this->HintDistrict : null;
    }
    /**
     * Set HintDistrict value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hintDistrict
     * @return \StructType\AccountAddress
     */
    public function setHintDistrict($hintDistrict = null)
    {
        // validation for constraint: string
        if (!is_null($hintDistrict) && !is_string($hintDistrict)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hintDistrict, true), gettype($hintDistrict)), __LINE__);
        }
        if (is_null($hintDistrict) || (is_array($hintDistrict) && empty($hintDistrict))) {
            unset($this->HintDistrict);
        } else {
            $this->HintDistrict = $hintDistrict;
        }
        return $this;
    }
    /**
     * Get HintField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHintField()
    {
        return isset($this->HintField) ? $this->HintField : null;
    }
    /**
     * Set HintField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hintField
     * @return \StructType\AccountAddress
     */
    public function setHintField($hintField = null)
    {
        // validation for constraint: string
        if (!is_null($hintField) && !is_string($hintField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hintField, true), gettype($hintField)), __LINE__);
        }
        if (is_null($hintField) || (is_array($hintField) && empty($hintField))) {
            unset($this->HintField);
        } else {
            $this->HintField = $hintField;
        }
        return $this;
    }
    /**
     * Get HintQuarter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHintQuarter()
    {
        return isset($this->HintQuarter) ? $this->HintQuarter : null;
    }
    /**
     * Set HintQuarter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hintQuarter
     * @return \StructType\AccountAddress
     */
    public function setHintQuarter($hintQuarter = null)
    {
        // validation for constraint: string
        if (!is_null($hintQuarter) && !is_string($hintQuarter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hintQuarter, true), gettype($hintQuarter)), __LINE__);
        }
        if (is_null($hintQuarter) || (is_array($hintQuarter) && empty($hintQuarter))) {
            unset($this->HintQuarter);
        } else {
            $this->HintQuarter = $hintQuarter;
        }
        return $this;
    }
    /**
     * Get HintStreet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHintStreet()
    {
        return isset($this->HintStreet) ? $this->HintStreet : null;
    }
    /**
     * Set HintStreet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hintStreet
     * @return \StructType\AccountAddress
     */
    public function setHintStreet($hintStreet = null)
    {
        // validation for constraint: string
        if (!is_null($hintStreet) && !is_string($hintStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hintStreet, true), gettype($hintStreet)), __LINE__);
        }
        if (is_null($hintStreet) || (is_array($hintStreet) && empty($hintStreet))) {
            unset($this->HintStreet);
        } else {
            $this->HintStreet = $hintStreet;
        }
        return $this;
    }
    /**
     * Get HintTown value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HintTown|null
     */
    public function getHintTown()
    {
        return isset($this->HintTown) ? $this->HintTown : null;
    }
    /**
     * Set HintTown value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\HintTown $hintTown
     * @return \StructType\AccountAddress
     */
    public function setHintTown(\StructType\HintTown $hintTown = null)
    {
        if (is_null($hintTown) || (is_array($hintTown) && empty($hintTown))) {
            unset($this->HintTown);
        } else {
            $this->HintTown = $hintTown;
        }
        return $this;
    }
    /**
     * Get HinterLandId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHinterLandId()
    {
        return isset($this->HinterLandId) ? $this->HinterLandId : null;
    }
    /**
     * Set HinterLandId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hinterLandId
     * @return \StructType\AccountAddress
     */
    public function setHinterLandId($hinterLandId = null)
    {
        // validation for constraint: string
        if (!is_null($hinterLandId) && !is_string($hinterLandId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hinterLandId, true), gettype($hinterLandId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hinterLandId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hinterLandId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hinterLandId, true)), __LINE__);
        }
        if (is_null($hinterLandId) || (is_array($hinterLandId) && empty($hinterLandId))) {
            unset($this->HinterLandId);
        } else {
            $this->HinterLandId = $hinterLandId;
        }
        return $this;
    }
    /**
     * Get HinterLandStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHinterLandStatus()
    {
        return isset($this->HinterLandStatus) ? $this->HinterLandStatus : null;
    }
    /**
     * Set HinterLandStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $hinterLandStatus
     * @return \StructType\AccountAddress
     */
    public function setHinterLandStatus($hinterLandStatus = null)
    {
        // validation for constraint: int
        if (!is_null($hinterLandStatus) && !(is_int($hinterLandStatus) || ctype_digit($hinterLandStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hinterLandStatus, true), gettype($hinterLandStatus)), __LINE__);
        }
        if (is_null($hinterLandStatus) || (is_array($hinterLandStatus) && empty($hinterLandStatus))) {
            unset($this->HinterLandStatus);
        } else {
            $this->HinterLandStatus = $hinterLandStatus;
        }
        return $this;
    }
    /**
     * Get IntegrationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIntegrationCode()
    {
        return isset($this->IntegrationCode) ? $this->IntegrationCode : null;
    }
    /**
     * Set IntegrationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $integrationCode
     * @return \StructType\AccountAddress
     */
    public function setIntegrationCode($integrationCode = null)
    {
        // validation for constraint: string
        if (!is_null($integrationCode) && !is_string($integrationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($integrationCode, true), gettype($integrationCode)), __LINE__);
        }
        if (is_null($integrationCode) || (is_array($integrationCode) && empty($integrationCode))) {
            unset($this->IntegrationCode);
        } else {
            $this->IntegrationCode = $integrationCode;
        }
        return $this;
    }
    /**
     * Get InvoiceAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceAddress()
    {
        return isset($this->InvoiceAddress) ? $this->InvoiceAddress : null;
    }
    /**
     * Set InvoiceAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceAddress
     * @return \StructType\AccountAddress
     */
    public function setInvoiceAddress($invoiceAddress = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceAddress) && !is_string($invoiceAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceAddress, true), gettype($invoiceAddress)), __LINE__);
        }
        if (is_null($invoiceAddress) || (is_array($invoiceAddress) && empty($invoiceAddress))) {
            unset($this->InvoiceAddress);
        } else {
            $this->InvoiceAddress = $invoiceAddress;
        }
        return $this;
    }
    /**
     * Get InvoiceAddressVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceAddressVersionId()
    {
        return isset($this->InvoiceAddressVersionId) ? $this->InvoiceAddressVersionId : null;
    }
    /**
     * Set InvoiceAddressVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceAddressVersionId
     * @return \StructType\AccountAddress
     */
    public function setInvoiceAddressVersionId($invoiceAddressVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceAddressVersionId) && !is_string($invoiceAddressVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceAddressVersionId, true), gettype($invoiceAddressVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($invoiceAddressVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $invoiceAddressVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($invoiceAddressVersionId, true)), __LINE__);
        }
        if (is_null($invoiceAddressVersionId) || (is_array($invoiceAddressVersionId) && empty($invoiceAddressVersionId))) {
            unset($this->InvoiceAddressVersionId);
        } else {
            $this->InvoiceAddressVersionId = $invoiceAddressVersionId;
        }
        return $this;
    }
    /**
     * Get InvoiceTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceTitle()
    {
        return isset($this->InvoiceTitle) ? $this->InvoiceTitle : null;
    }
    /**
     * Set InvoiceTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceTitle
     * @return \StructType\AccountAddress
     */
    public function setInvoiceTitle($invoiceTitle = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceTitle) && !is_string($invoiceTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceTitle, true), gettype($invoiceTitle)), __LINE__);
        }
        if (is_null($invoiceTitle) || (is_array($invoiceTitle) && empty($invoiceTitle))) {
            unset($this->InvoiceTitle);
        } else {
            $this->InvoiceTitle = $invoiceTitle;
        }
        return $this;
    }
    /**
     * Get InvoiceUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Unit|null
     */
    public function getInvoiceUnit()
    {
        return isset($this->InvoiceUnit) ? $this->InvoiceUnit : null;
    }
    /**
     * Set InvoiceUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Unit $invoiceUnit
     * @return \StructType\AccountAddress
     */
    public function setInvoiceUnit(\StructType\Unit $invoiceUnit = null)
    {
        if (is_null($invoiceUnit) || (is_array($invoiceUnit) && empty($invoiceUnit))) {
            unset($this->InvoiceUnit);
        } else {
            $this->InvoiceUnit = $invoiceUnit;
        }
        return $this;
    }
    /**
     * Get LastUsedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUsedDate()
    {
        return isset($this->LastUsedDate) ? $this->LastUsedDate : null;
    }
    /**
     * Set LastUsedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUsedDate
     * @return \StructType\AccountAddress
     */
    public function setLastUsedDate($lastUsedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUsedDate) && !is_string($lastUsedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUsedDate, true), gettype($lastUsedDate)), __LINE__);
        }
        if (is_null($lastUsedDate) || (is_array($lastUsedDate) && empty($lastUsedDate))) {
            unset($this->LastUsedDate);
        } else {
            $this->LastUsedDate = $lastUsedDate;
        }
        return $this;
    }
    /**
     * Get LastVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastVersion()
    {
        return isset($this->LastVersion) ? $this->LastVersion : null;
    }
    /**
     * Set LastVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastVersion
     * @return \StructType\AccountAddress
     */
    public function setLastVersion($lastVersion = null)
    {
        // validation for constraint: string
        if (!is_null($lastVersion) && !is_string($lastVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastVersion, true), gettype($lastVersion)), __LINE__);
        }
        if (is_null($lastVersion) || (is_array($lastVersion) && empty($lastVersion))) {
            unset($this->LastVersion);
        } else {
            $this->LastVersion = $lastVersion;
        }
        return $this;
    }
    /**
     * Get LovAddressKeyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLovAddressKeyId()
    {
        return isset($this->LovAddressKeyId) ? $this->LovAddressKeyId : null;
    }
    /**
     * Set LovAddressKeyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lovAddressKeyId
     * @return \StructType\AccountAddress
     */
    public function setLovAddressKeyId($lovAddressKeyId = null)
    {
        // validation for constraint: int
        if (!is_null($lovAddressKeyId) && !(is_int($lovAddressKeyId) || ctype_digit($lovAddressKeyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lovAddressKeyId, true), gettype($lovAddressKeyId)), __LINE__);
        }
        if (is_null($lovAddressKeyId) || (is_array($lovAddressKeyId) && empty($lovAddressKeyId))) {
            unset($this->LovAddressKeyId);
        } else {
            $this->LovAddressKeyId = $lovAddressKeyId;
        }
        return $this;
    }
    /**
     * Get LovAddressStatusId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLovAddressStatusId()
    {
        return isset($this->LovAddressStatusId) ? $this->LovAddressStatusId : null;
    }
    /**
     * Set LovAddressStatusId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lovAddressStatusId
     * @return \StructType\AccountAddress
     */
    public function setLovAddressStatusId($lovAddressStatusId = null)
    {
        // validation for constraint: string
        if (!is_null($lovAddressStatusId) && !is_string($lovAddressStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lovAddressStatusId, true), gettype($lovAddressStatusId)), __LINE__);
        }
        if (is_null($lovAddressStatusId) || (is_array($lovAddressStatusId) && empty($lovAddressStatusId))) {
            unset($this->LovAddressStatusId);
        } else {
            $this->LovAddressStatusId = $lovAddressStatusId;
        }
        return $this;
    }
    /**
     * Get LovAddressType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LovAddressType|null
     */
    public function getLovAddressType()
    {
        return isset($this->LovAddressType) ? $this->LovAddressType : null;
    }
    /**
     * Set LovAddressType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\LovAddressType $lovAddressType
     * @return \StructType\AccountAddress
     */
    public function setLovAddressType(\StructType\LovAddressType $lovAddressType = null)
    {
        if (is_null($lovAddressType) || (is_array($lovAddressType) && empty($lovAddressType))) {
            unset($this->LovAddressType);
        } else {
            $this->LovAddressType = $lovAddressType;
        }
        return $this;
    }
    /**
     * Get LovApprovedId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLovApprovedId()
    {
        return isset($this->LovApprovedId) ? $this->LovApprovedId : null;
    }
    /**
     * Set LovApprovedId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lovApprovedId
     * @return \StructType\AccountAddress
     */
    public function setLovApprovedId($lovApprovedId = null)
    {
        // validation for constraint: int
        if (!is_null($lovApprovedId) && !(is_int($lovApprovedId) || ctype_digit($lovApprovedId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lovApprovedId, true), gettype($lovApprovedId)), __LINE__);
        }
        if (is_null($lovApprovedId) || (is_array($lovApprovedId) && empty($lovApprovedId))) {
            unset($this->LovApprovedId);
        } else {
            $this->LovApprovedId = $lovApprovedId;
        }
        return $this;
    }
    /**
     * Get LovAuditCreatedVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LovAuditCreatedVersion|null
     */
    public function getLovAuditCreatedVersion()
    {
        return isset($this->LovAuditCreatedVersion) ? $this->LovAuditCreatedVersion : null;
    }
    /**
     * Set LovAuditCreatedVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\LovAuditCreatedVersion $lovAuditCreatedVersion
     * @return \StructType\AccountAddress
     */
    public function setLovAuditCreatedVersion(\StructType\LovAuditCreatedVersion $lovAuditCreatedVersion = null)
    {
        if (is_null($lovAuditCreatedVersion) || (is_array($lovAuditCreatedVersion) && empty($lovAuditCreatedVersion))) {
            unset($this->LovAuditCreatedVersion);
        } else {
            $this->LovAuditCreatedVersion = $lovAuditCreatedVersion;
        }
        return $this;
    }
    /**
     * Get LovIdentityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LovIdentityType|null
     */
    public function getLovIdentityType()
    {
        return isset($this->LovIdentityType) ? $this->LovIdentityType : null;
    }
    /**
     * Set LovIdentityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\LovIdentityType $lovIdentityType
     * @return \StructType\AccountAddress
     */
    public function setLovIdentityType(\StructType\LovIdentityType $lovIdentityType = null)
    {
        if (is_null($lovIdentityType) || (is_array($lovIdentityType) && empty($lovIdentityType))) {
            unset($this->LovIdentityType);
        } else {
            $this->LovIdentityType = $lovIdentityType;
        }
        return $this;
    }
    /**
     * Get LovPolygonLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLovPolygonLevelId()
    {
        return isset($this->LovPolygonLevelId) ? $this->LovPolygonLevelId : null;
    }
    /**
     * Set LovPolygonLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lovPolygonLevelId
     * @return \StructType\AccountAddress
     */
    public function setLovPolygonLevelId($lovPolygonLevelId = null)
    {
        // validation for constraint: int
        if (!is_null($lovPolygonLevelId) && !(is_int($lovPolygonLevelId) || ctype_digit($lovPolygonLevelId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lovPolygonLevelId, true), gettype($lovPolygonLevelId)), __LINE__);
        }
        if (is_null($lovPolygonLevelId) || (is_array($lovPolygonLevelId) && empty($lovPolygonLevelId))) {
            unset($this->LovPolygonLevelId);
        } else {
            $this->LovPolygonLevelId = $lovPolygonLevelId;
        }
        return $this;
    }
    /**
     * Get LovTaxExemptReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LovTaxExemptReason|null
     */
    public function getLovTaxExemptReason()
    {
        return isset($this->LovTaxExemptReason) ? $this->LovTaxExemptReason : null;
    }
    /**
     * Set LovTaxExemptReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\LovTaxExemptReason $lovTaxExemptReason
     * @return \StructType\AccountAddress
     */
    public function setLovTaxExemptReason(\StructType\LovTaxExemptReason $lovTaxExemptReason = null)
    {
        if (is_null($lovTaxExemptReason) || (is_array($lovTaxExemptReason) && empty($lovTaxExemptReason))) {
            unset($this->LovTaxExemptReason);
        } else {
            $this->LovTaxExemptReason = $lovTaxExemptReason;
        }
        return $this;
    }
    /**
     * Get MobilePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobilePhone()
    {
        return isset($this->MobilePhone) ? $this->MobilePhone : null;
    }
    /**
     * Set MobilePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobilePhone
     * @return \StructType\AccountAddress
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhone, true), gettype($mobilePhone)), __LINE__);
        }
        if (is_null($mobilePhone) || (is_array($mobilePhone) && empty($mobilePhone))) {
            unset($this->MobilePhone);
        } else {
            $this->MobilePhone = $mobilePhone;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\AccountAddress
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Phone1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone1()
    {
        return isset($this->Phone1) ? $this->Phone1 : null;
    }
    /**
     * Set Phone1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone1
     * @return \StructType\AccountAddress
     */
    public function setPhone1($phone1 = null)
    {
        // validation for constraint: string
        if (!is_null($phone1) && !is_string($phone1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone1, true), gettype($phone1)), __LINE__);
        }
        if (is_null($phone1) || (is_array($phone1) && empty($phone1))) {
            unset($this->Phone1);
        } else {
            $this->Phone1 = $phone1;
        }
        return $this;
    }
    /**
     * Get Phone2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone2()
    {
        return isset($this->Phone2) ? $this->Phone2 : null;
    }
    /**
     * Set Phone2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone2
     * @return \StructType\AccountAddress
     */
    public function setPhone2($phone2 = null)
    {
        // validation for constraint: string
        if (!is_null($phone2) && !is_string($phone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone2, true), gettype($phone2)), __LINE__);
        }
        if (is_null($phone2) || (is_array($phone2) && empty($phone2))) {
            unset($this->Phone2);
        } else {
            $this->Phone2 = $phone2;
        }
        return $this;
    }
    /**
     * Get PostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostCode()
    {
        return isset($this->PostCode) ? $this->PostCode : null;
    }
    /**
     * Set PostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postCode
     * @return \StructType\AccountAddress
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postCode, true), gettype($postCode)), __LINE__);
        }
        if (is_null($postCode) || (is_array($postCode) && empty($postCode))) {
            unset($this->PostCode);
        } else {
            $this->PostCode = $postCode;
        }
        return $this;
    }
    /**
     * Get SourceUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Unit|null
     */
    public function getSourceUnit()
    {
        return isset($this->SourceUnit) ? $this->SourceUnit : null;
    }
    /**
     * Set SourceUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Unit $sourceUnit
     * @return \StructType\AccountAddress
     */
    public function setSourceUnit(\StructType\Unit $sourceUnit = null)
    {
        if (is_null($sourceUnit) || (is_array($sourceUnit) && empty($sourceUnit))) {
            unset($this->SourceUnit);
        } else {
            $this->SourceUnit = $sourceUnit;
        }
        return $this;
    }
    /**
     * Get TargetUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Unit|null
     */
    public function getTargetUnit()
    {
        return isset($this->TargetUnit) ? $this->TargetUnit : null;
    }
    /**
     * Set TargetUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Unit $targetUnit
     * @return \StructType\AccountAddress
     */
    public function setTargetUnit(\StructType\Unit $targetUnit = null)
    {
        if (is_null($targetUnit) || (is_array($targetUnit) && empty($targetUnit))) {
            unset($this->TargetUnit);
        } else {
            $this->TargetUnit = $targetUnit;
        }
        return $this;
    }
    /**
     * Get TaxExempt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxExempt()
    {
        return isset($this->TaxExempt) ? $this->TaxExempt : null;
    }
    /**
     * Set TaxExempt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxExempt
     * @return \StructType\AccountAddress
     */
    public function setTaxExempt($taxExempt = null)
    {
        // validation for constraint: string
        if (!is_null($taxExempt) && !is_string($taxExempt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxExempt, true), gettype($taxExempt)), __LINE__);
        }
        if (is_null($taxExempt) || (is_array($taxExempt) && empty($taxExempt))) {
            unset($this->TaxExempt);
        } else {
            $this->TaxExempt = $taxExempt;
        }
        return $this;
    }
    /**
     * Get TaxExemptreason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxExemptreason()
    {
        return isset($this->TaxExemptreason) ? $this->TaxExemptreason : null;
    }
    /**
     * Set TaxExemptreason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxExemptreason
     * @return \StructType\AccountAddress
     */
    public function setTaxExemptreason($taxExemptreason = null)
    {
        // validation for constraint: string
        if (!is_null($taxExemptreason) && !is_string($taxExemptreason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxExemptreason, true), gettype($taxExemptreason)), __LINE__);
        }
        if (is_null($taxExemptreason) || (is_array($taxExemptreason) && empty($taxExemptreason))) {
            unset($this->TaxExemptreason);
        } else {
            $this->TaxExemptreason = $taxExemptreason;
        }
        return $this;
    }
    /**
     * Get TaxNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxNumber()
    {
        return isset($this->TaxNumber) ? $this->TaxNumber : null;
    }
    /**
     * Set TaxNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxNumber
     * @return \StructType\AccountAddress
     */
    public function setTaxNumber($taxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxNumber) && !is_string($taxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxNumber, true), gettype($taxNumber)), __LINE__);
        }
        if (is_null($taxNumber) || (is_array($taxNumber) && empty($taxNumber))) {
            unset($this->TaxNumber);
        } else {
            $this->TaxNumber = $taxNumber;
        }
        return $this;
    }
    /**
     * Get TaxNumberConfidential value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxNumberConfidential()
    {
        return isset($this->TaxNumberConfidential) ? $this->TaxNumberConfidential : null;
    }
    /**
     * Set TaxNumberConfidential value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxNumberConfidential
     * @return \StructType\AccountAddress
     */
    public function setTaxNumberConfidential($taxNumberConfidential = null)
    {
        // validation for constraint: string
        if (!is_null($taxNumberConfidential) && !is_string($taxNumberConfidential)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxNumberConfidential, true), gettype($taxNumberConfidential)), __LINE__);
        }
        if (is_null($taxNumberConfidential) || (is_array($taxNumberConfidential) && empty($taxNumberConfidential))) {
            unset($this->TaxNumberConfidential);
        } else {
            $this->TaxNumberConfidential = $taxNumberConfidential;
        }
        return $this;
    }
    /**
     * Get TaxOffice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxOffice()
    {
        return isset($this->TaxOffice) ? $this->TaxOffice : null;
    }
    /**
     * Set TaxOffice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxOffice
     * @return \StructType\AccountAddress
     */
    public function setTaxOffice($taxOffice = null)
    {
        // validation for constraint: string
        if (!is_null($taxOffice) && !is_string($taxOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxOffice, true), gettype($taxOffice)), __LINE__);
        }
        if (is_null($taxOffice) || (is_array($taxOffice) && empty($taxOffice))) {
            unset($this->TaxOffice);
        } else {
            $this->TaxOffice = $taxOffice;
        }
        return $this;
    }
    /**
     * Get TransferDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransferDate()
    {
        return isset($this->TransferDate) ? $this->TransferDate : null;
    }
    /**
     * Set TransferDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transferDate
     * @return \StructType\AccountAddress
     */
    public function setTransferDate($transferDate = null)
    {
        // validation for constraint: string
        if (!is_null($transferDate) && !is_string($transferDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transferDate, true), gettype($transferDate)), __LINE__);
        }
        if (is_null($transferDate) || (is_array($transferDate) && empty($transferDate))) {
            unset($this->TransferDate);
        } else {
            $this->TransferDate = $transferDate;
        }
        return $this;
    }
    /**
     * Get TransferStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransferStatus()
    {
        return isset($this->TransferStatus) ? $this->TransferStatus : null;
    }
    /**
     * Set TransferStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transferStatus
     * @return \StructType\AccountAddress
     */
    public function setTransferStatus($transferStatus = null)
    {
        // validation for constraint: string
        if (!is_null($transferStatus) && !is_string($transferStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transferStatus, true), gettype($transferStatus)), __LINE__);
        }
        if (is_null($transferStatus) || (is_array($transferStatus) && empty($transferStatus))) {
            unset($this->TransferStatus);
        } else {
            $this->TransferStatus = $transferStatus;
        }
        return $this;
    }
    /**
     * Get UncertainCredit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUncertainCredit()
    {
        return isset($this->UncertainCredit) ? $this->UncertainCredit : null;
    }
    /**
     * Set UncertainCredit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uncertainCredit
     * @return \StructType\AccountAddress
     */
    public function setUncertainCredit($uncertainCredit = null)
    {
        // validation for constraint: string
        if (!is_null($uncertainCredit) && !is_string($uncertainCredit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uncertainCredit, true), gettype($uncertainCredit)), __LINE__);
        }
        if (is_null($uncertainCredit) || (is_array($uncertainCredit) && empty($uncertainCredit))) {
            unset($this->UncertainCredit);
        } else {
            $this->UncertainCredit = $uncertainCredit;
        }
        return $this;
    }
    /**
     * Get Url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl()
    {
        return isset($this->Url) ? $this->Url : null;
    }
    /**
     * Set Url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url
     * @return \StructType\AccountAddress
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        if (is_null($url) || (is_array($url) && empty($url))) {
            unset($this->Url);
        } else {
            $this->Url = $url;
        }
        return $this;
    }
    /**
     * Get UsePricelistService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsePricelistService()
    {
        return isset($this->UsePricelistService) ? $this->UsePricelistService : null;
    }
    /**
     * Set UsePricelistService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $usePricelistService
     * @return \StructType\AccountAddress
     */
    public function setUsePricelistService($usePricelistService = null)
    {
        // validation for constraint: string
        if (!is_null($usePricelistService) && !is_string($usePricelistService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usePricelistService, true), gettype($usePricelistService)), __LINE__);
        }
        if (is_null($usePricelistService) || (is_array($usePricelistService) && empty($usePricelistService))) {
            unset($this->UsePricelistService);
        } else {
            $this->UsePricelistService = $usePricelistService;
        }
        return $this;
    }
    /**
     * Get ValidAllUnits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidAllUnits()
    {
        return isset($this->ValidAllUnits) ? $this->ValidAllUnits : null;
    }
    /**
     * Set ValidAllUnits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validAllUnits
     * @return \StructType\AccountAddress
     */
    public function setValidAllUnits($validAllUnits = null)
    {
        // validation for constraint: string
        if (!is_null($validAllUnits) && !is_string($validAllUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validAllUnits, true), gettype($validAllUnits)), __LINE__);
        }
        if (is_null($validAllUnits) || (is_array($validAllUnits) && empty($validAllUnits))) {
            unset($this->ValidAllUnits);
        } else {
            $this->ValidAllUnits = $validAllUnits;
        }
        return $this;
    }
    /**
     * Get WithHolding value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWithHolding()
    {
        return isset($this->WithHolding) ? $this->WithHolding : null;
    }
    /**
     * Set WithHolding value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $withHolding
     * @return \StructType\AccountAddress
     */
    public function setWithHolding($withHolding = null)
    {
        // validation for constraint: string
        if (!is_null($withHolding) && !is_string($withHolding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($withHolding, true), gettype($withHolding)), __LINE__);
        }
        if (is_null($withHolding) || (is_array($withHolding) && empty($withHolding))) {
            unset($this->WithHolding);
        } else {
            $this->WithHolding = $withHolding;
        }
        return $this;
    }
    /**
     * Get XCoor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXCoor()
    {
        return isset($this->XCoor) ? $this->XCoor : null;
    }
    /**
     * Set XCoor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xCoor
     * @return \StructType\AccountAddress
     */
    public function setXCoor($xCoor = null)
    {
        // validation for constraint: string
        if (!is_null($xCoor) && !is_string($xCoor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xCoor, true), gettype($xCoor)), __LINE__);
        }
        if (is_null($xCoor) || (is_array($xCoor) && empty($xCoor))) {
            unset($this->XCoor);
        } else {
            $this->XCoor = $xCoor;
        }
        return $this;
    }
    /**
     * Get YCoor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getYCoor()
    {
        return isset($this->YCoor) ? $this->YCoor : null;
    }
    /**
     * Set YCoor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $yCoor
     * @return \StructType\AccountAddress
     */
    public function setYCoor($yCoor = null)
    {
        // validation for constraint: string
        if (!is_null($yCoor) && !is_string($yCoor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($yCoor, true), gettype($yCoor)), __LINE__);
        }
        if (is_null($yCoor) || (is_array($yCoor) && empty($yCoor))) {
            unset($this->YCoor);
        } else {
            $this->YCoor = $yCoor;
        }
        return $this;
    }
}
