<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save ServiceType
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SaveOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveOrder $parameters
     * @return \StructType\SaveOrderResponse|bool
     */
    public function SaveOrder(\StructType\SaveOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveOrderHeader
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveOrderHeader $parameters
     * @return \StructType\SaveOrderHeaderResponse|bool
     */
    public function SaveOrderHeader(\StructType\SaveOrderHeader $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveOrderHeader($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveOrderHeaderMPOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveOrderHeaderMPOrder $parameters
     * @return \StructType\SaveOrderHeaderMPOrderResponse|bool
     */
    public function SaveOrderHeaderMPOrder(\StructType\SaveOrderHeaderMPOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveOrderHeaderMPOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SaveOrderHeaderMPOrderResponse|\StructType\SaveOrderHeaderResponse|\StructType\SaveOrderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
