<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Aras ServiceType
 * @subpackage Services
 */
class Aras extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ArasMPOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ArasMPOrder $parameters
     * @return \StructType\ArasMPOrderResponse|bool
     */
    public function ArasMPOrder(\StructType\ArasMPOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ArasMPOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ArasMPOrderUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ArasMPOrderUpdate $parameters
     * @return \StructType\ArasMPOrderUpdateResponse|bool
     */
    public function ArasMPOrderUpdate(\StructType\ArasMPOrderUpdate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ArasMPOrderUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ArasMPOrderDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ArasMPOrderDelete $parameters
     * @return \StructType\ArasMPOrderDeleteResponse|bool
     */
    public function ArasMPOrderDelete(\StructType\ArasMPOrderDelete $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ArasMPOrderDelete($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ArasMPOrderGetOrderListByOrderCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ArasMPOrderGetOrderListByOrderCode $parameters
     * @return \StructType\ArasMPOrderGetOrderListByOrderCodeResponse|bool
     */
    public function ArasMPOrderGetOrderListByOrderCode(\StructType\ArasMPOrderGetOrderListByOrderCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ArasMPOrderGetOrderListByOrderCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ArasMPOrderDeleteResponse|\StructType\ArasMPOrderGetOrderListByOrderCodeResponse|\StructType\ArasMPOrderResponse|\StructType\ArasMPOrderUpdateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
