<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MPAddressInfoViewModel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MPAddressInfoViewModel
 * @subpackage Structs
 */
class MPAddressInfoViewModel extends AbstractStructBase
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Address;
    /**
     * The AddressId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressId;
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CityName;
    /**
     * The DoorNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DoorNumber;
    /**
     * The HintAvenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HintAvenue;
    /**
     * The HintDistrict
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HintDistrict;
    /**
     * The HintQuarter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HintQuarter;
    /**
     * The HintStreet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HintStreet;
    /**
     * The MobilePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobilePhone;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PhoneNumber;
    /**
     * The TaxNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxNumber;
    /**
     * The TaxOffice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxOffice;
    /**
     * The TownName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TownName;
    /**
     * Constructor method for MPAddressInfoViewModel
     * @uses MPAddressInfoViewModel::setAddress()
     * @uses MPAddressInfoViewModel::setAddressId()
     * @uses MPAddressInfoViewModel::setCityName()
     * @uses MPAddressInfoViewModel::setDoorNumber()
     * @uses MPAddressInfoViewModel::setHintAvenue()
     * @uses MPAddressInfoViewModel::setHintDistrict()
     * @uses MPAddressInfoViewModel::setHintQuarter()
     * @uses MPAddressInfoViewModel::setHintStreet()
     * @uses MPAddressInfoViewModel::setMobilePhone()
     * @uses MPAddressInfoViewModel::setName()
     * @uses MPAddressInfoViewModel::setPhoneNumber()
     * @uses MPAddressInfoViewModel::setTaxNumber()
     * @uses MPAddressInfoViewModel::setTaxOffice()
     * @uses MPAddressInfoViewModel::setTownName()
     * @param string $address
     * @param string $addressId
     * @param string $cityName
     * @param string $doorNumber
     * @param string $hintAvenue
     * @param string $hintDistrict
     * @param string $hintQuarter
     * @param string $hintStreet
     * @param string $mobilePhone
     * @param string $name
     * @param string $phoneNumber
     * @param string $taxNumber
     * @param string $taxOffice
     * @param string $townName
     */
    public function __construct($address = null, $addressId = null, $cityName = null, $doorNumber = null, $hintAvenue = null, $hintDistrict = null, $hintQuarter = null, $hintStreet = null, $mobilePhone = null, $name = null, $phoneNumber = null, $taxNumber = null, $taxOffice = null, $townName = null)
    {
        $this
            ->setAddress($address)
            ->setAddressId($addressId)
            ->setCityName($cityName)
            ->setDoorNumber($doorNumber)
            ->setHintAvenue($hintAvenue)
            ->setHintDistrict($hintDistrict)
            ->setHintQuarter($hintQuarter)
            ->setHintStreet($hintStreet)
            ->setMobilePhone($mobilePhone)
            ->setName($name)
            ->setPhoneNumber($phoneNumber)
            ->setTaxNumber($taxNumber)
            ->setTaxOffice($taxOffice)
            ->setTownName($townName);
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address
     * @return \StructType\MPAddressInfoViewModel
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get AddressId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressId()
    {
        return isset($this->AddressId) ? $this->AddressId : null;
    }
    /**
     * Set AddressId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressId
     * @return \StructType\MPAddressInfoViewModel
     */
    public function setAddressId($addressId = null)
    {
        // validation for constraint: string
        if (!is_null($addressId) && !is_string($addressId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressId, true), gettype($addressId)), __LINE__);
        }
        if (is_null($addressId) || (is_array($addressId) && empty($addressId))) {
            unset($this->AddressId);
        } else {
            $this->AddressId = $addressId;
        }
        return $this;
    }
    /**
     * Get CityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCityName()
    {
        return isset($this->CityName) ? $this->CityName : null;
    }
    /**
     * Set CityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cityName
     * @return \StructType\MPAddressInfoViewModel
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        if (is_null($cityName) || (is_array($cityName) && empty($cityName))) {
            unset($this->CityName);
        } else {
            $this->CityName = $cityName;
        }
        return $this;
    }
    /**
     * Get DoorNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoorNumber()
    {
        return isset($this->DoorNumber) ? $this->DoorNumber : null;
    }
    /**
     * Set DoorNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doorNumber
     * @return \StructType\MPAddressInfoViewModel
     */
    public function setDoorNumber($doorNumber = null)
    {
        // validation for constraint: string
        if (!is_null($doorNumber) && !is_string($doorNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doorNumber, true), gettype($doorNumber)), __LINE__);
        }
        if (is_null($doorNumber) || (is_array($doorNumber) && empty($doorNumber))) {
            unset($this->DoorNumber);
        } else {
            $this->DoorNumber = $doorNumber;
        }
        return $this;
    }
    /**
     * Get HintAvenue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHintAvenue()
    {
        return isset($this->HintAvenue) ? $this->HintAvenue : null;
    }
    /**
     * Set HintAvenue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hintAvenue
     * @return \StructType\MPAddressInfoViewModel
     */
    public function setHintAvenue($hintAvenue = null)
    {
        // validation for constraint: string
        if (!is_null($hintAvenue) && !is_string($hintAvenue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hintAvenue, true), gettype($hintAvenue)), __LINE__);
        }
        if (is_null($hintAvenue) || (is_array($hintAvenue) && empty($hintAvenue))) {
            unset($this->HintAvenue);
        } else {
            $this->HintAvenue = $hintAvenue;
        }
        return $this;
    }
    /**
     * Get HintDistrict value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHintDistrict()
    {
        return isset($this->HintDistrict) ? $this->HintDistrict : null;
    }
    /**
     * Set HintDistrict value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hintDistrict
     * @return \StructType\MPAddressInfoViewModel
     */
    public function setHintDistrict($hintDistrict = null)
    {
        // validation for constraint: string
        if (!is_null($hintDistrict) && !is_string($hintDistrict)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hintDistrict, true), gettype($hintDistrict)), __LINE__);
        }
        if (is_null($hintDistrict) || (is_array($hintDistrict) && empty($hintDistrict))) {
            unset($this->HintDistrict);
        } else {
            $this->HintDistrict = $hintDistrict;
        }
        return $this;
    }
    /**
     * Get HintQuarter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHintQuarter()
    {
        return isset($this->HintQuarter) ? $this->HintQuarter : null;
    }
    /**
     * Set HintQuarter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hintQuarter
     * @return \StructType\MPAddressInfoViewModel
     */
    public function setHintQuarter($hintQuarter = null)
    {
        // validation for constraint: string
        if (!is_null($hintQuarter) && !is_string($hintQuarter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hintQuarter, true), gettype($hintQuarter)), __LINE__);
        }
        if (is_null($hintQuarter) || (is_array($hintQuarter) && empty($hintQuarter))) {
            unset($this->HintQuarter);
        } else {
            $this->HintQuarter = $hintQuarter;
        }
        return $this;
    }
    /**
     * Get HintStreet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHintStreet()
    {
        return isset($this->HintStreet) ? $this->HintStreet : null;
    }
    /**
     * Set HintStreet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hintStreet
     * @return \StructType\MPAddressInfoViewModel
     */
    public function setHintStreet($hintStreet = null)
    {
        // validation for constraint: string
        if (!is_null($hintStreet) && !is_string($hintStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hintStreet, true), gettype($hintStreet)), __LINE__);
        }
        if (is_null($hintStreet) || (is_array($hintStreet) && empty($hintStreet))) {
            unset($this->HintStreet);
        } else {
            $this->HintStreet = $hintStreet;
        }
        return $this;
    }
    /**
     * Get MobilePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobilePhone()
    {
        return isset($this->MobilePhone) ? $this->MobilePhone : null;
    }
    /**
     * Set MobilePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobilePhone
     * @return \StructType\MPAddressInfoViewModel
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhone, true), gettype($mobilePhone)), __LINE__);
        }
        if (is_null($mobilePhone) || (is_array($mobilePhone) && empty($mobilePhone))) {
            unset($this->MobilePhone);
        } else {
            $this->MobilePhone = $mobilePhone;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\MPAddressInfoViewModel
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get PhoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return isset($this->PhoneNumber) ? $this->PhoneNumber : null;
    }
    /**
     * Set PhoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phoneNumber
     * @return \StructType\MPAddressInfoViewModel
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        if (is_null($phoneNumber) || (is_array($phoneNumber) && empty($phoneNumber))) {
            unset($this->PhoneNumber);
        } else {
            $this->PhoneNumber = $phoneNumber;
        }
        return $this;
    }
    /**
     * Get TaxNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxNumber()
    {
        return isset($this->TaxNumber) ? $this->TaxNumber : null;
    }
    /**
     * Set TaxNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxNumber
     * @return \StructType\MPAddressInfoViewModel
     */
    public function setTaxNumber($taxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxNumber) && !is_string($taxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxNumber, true), gettype($taxNumber)), __LINE__);
        }
        if (is_null($taxNumber) || (is_array($taxNumber) && empty($taxNumber))) {
            unset($this->TaxNumber);
        } else {
            $this->TaxNumber = $taxNumber;
        }
        return $this;
    }
    /**
     * Get TaxOffice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxOffice()
    {
        return isset($this->TaxOffice) ? $this->TaxOffice : null;
    }
    /**
     * Set TaxOffice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxOffice
     * @return \StructType\MPAddressInfoViewModel
     */
    public function setTaxOffice($taxOffice = null)
    {
        // validation for constraint: string
        if (!is_null($taxOffice) && !is_string($taxOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxOffice, true), gettype($taxOffice)), __LINE__);
        }
        if (is_null($taxOffice) || (is_array($taxOffice) && empty($taxOffice))) {
            unset($this->TaxOffice);
        } else {
            $this->TaxOffice = $taxOffice;
        }
        return $this;
    }
    /**
     * Get TownName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTownName()
    {
        return isset($this->TownName) ? $this->TownName : null;
    }
    /**
     * Set TownName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $townName
     * @return \StructType\MPAddressInfoViewModel
     */
    public function setTownName($townName = null)
    {
        // validation for constraint: string
        if (!is_null($townName) && !is_string($townName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($townName, true), gettype($townName)), __LINE__);
        }
        if (is_null($townName) || (is_array($townName) && empty($townName))) {
            unset($this->TownName);
        } else {
            $this->TownName = $townName;
        }
        return $this;
    }
}
