<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Proizvod StructType
 * @subpackage Structs
 */
class Proizvod extends AbstractStructBase
{
    /**
     * The sifra
     * @var string
     */
    public $sifra;
    /**
     * The tip
     * @var string
     */
    public $tip;
    /**
     * The atributi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ListaAtributaProizvoda
     */
    public $atributi;
    /**
     * The listaZamjenskihProizvoda
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ListaSifri
     */
    public $listaZamjenskihProizvoda;
    /**
     * Constructor method for Proizvod
     * @uses Proizvod::setSifra()
     * @uses Proizvod::setTip()
     * @uses Proizvod::setAtributi()
     * @uses Proizvod::setListaZamjenskihProizvoda()
     * @param string $sifra
     * @param string $tip
     * @param \StructType\ListaAtributaProizvoda $atributi
     * @param \StructType\ListaSifri $listaZamjenskihProizvoda
     */
    public function __construct($sifra = null, $tip = null, \StructType\ListaAtributaProizvoda $atributi = null, \StructType\ListaSifri $listaZamjenskihProizvoda = null)
    {
        $this
            ->setSifra($sifra)
            ->setTip($tip)
            ->setAtributi($atributi)
            ->setListaZamjenskihProizvoda($listaZamjenskihProizvoda);
    }
    /**
     * Get sifra value
     * @return string|null
     */
    public function getSifra()
    {
        return $this->sifra;
    }
    /**
     * Set sifra value
     * @param string $sifra
     * @return \StructType\Proizvod
     */
    public function setSifra($sifra = null)
    {
        // validation for constraint: string
        if (!is_null($sifra) && !is_string($sifra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifra, true), gettype($sifra)), __LINE__);
        }
        $this->sifra = $sifra;
        return $this;
    }
    /**
     * Get tip value
     * @return string|null
     */
    public function getTip()
    {
        return $this->tip;
    }
    /**
     * Set tip value
     * @param string $tip
     * @return \StructType\Proizvod
     */
    public function setTip($tip = null)
    {
        // validation for constraint: string
        if (!is_null($tip) && !is_string($tip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tip, true), gettype($tip)), __LINE__);
        }
        $this->tip = $tip;
        return $this;
    }
    /**
     * Get atributi value
     * @return \StructType\ListaAtributaProizvoda|null
     */
    public function getAtributi()
    {
        return $this->atributi;
    }
    /**
     * Set atributi value
     * @param \StructType\ListaAtributaProizvoda $atributi
     * @return \StructType\Proizvod
     */
    public function setAtributi(\StructType\ListaAtributaProizvoda $atributi = null)
    {
        $this->atributi = $atributi;
        return $this;
    }
    /**
     * Get listaZamjenskihProizvoda value
     * @return \StructType\ListaSifri|null
     */
    public function getListaZamjenskihProizvoda()
    {
        return $this->listaZamjenskihProizvoda;
    }
    /**
     * Set listaZamjenskihProizvoda value
     * @param \StructType\ListaSifri $listaZamjenskihProizvoda
     * @return \StructType\Proizvod
     */
    public function setListaZamjenskihProizvoda(\StructType\ListaSifri $listaZamjenskihProizvoda = null)
    {
        $this->listaZamjenskihProizvoda = $listaZamjenskihProizvoda;
        return $this;
    }
}
