<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NaruceniProizvod StructType
 * @subpackage Structs
 */
class NaruceniProizvod extends AbstractStructBase
{
    /**
     * The produkt
     * @var string
     */
    public $produkt;
    /**
     * The narucenaKolicina
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $narucenaKolicina;
    /**
     * The otpremljenaKolicina
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $otpremljenaKolicina;
    /**
     * Constructor method for NaruceniProizvod
     * @uses NaruceniProizvod::setProdukt()
     * @uses NaruceniProizvod::setNarucenaKolicina()
     * @uses NaruceniProizvod::setOtpremljenaKolicina()
     * @param string $produkt
     * @param int $narucenaKolicina
     * @param int $otpremljenaKolicina
     */
    public function __construct($produkt = null, $narucenaKolicina = null, $otpremljenaKolicina = null)
    {
        $this
            ->setProdukt($produkt)
            ->setNarucenaKolicina($narucenaKolicina)
            ->setOtpremljenaKolicina($otpremljenaKolicina);
    }
    /**
     * Get produkt value
     * @return string|null
     */
    public function getProdukt()
    {
        return $this->produkt;
    }
    /**
     * Set produkt value
     * @param string $produkt
     * @return \StructType\NaruceniProizvod
     */
    public function setProdukt($produkt = null)
    {
        // validation for constraint: string
        if (!is_null($produkt) && !is_string($produkt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($produkt, true), gettype($produkt)), __LINE__);
        }
        $this->produkt = $produkt;
        return $this;
    }
    /**
     * Get narucenaKolicina value
     * @return int|null
     */
    public function getNarucenaKolicina()
    {
        return $this->narucenaKolicina;
    }
    /**
     * Set narucenaKolicina value
     * @param int $narucenaKolicina
     * @return \StructType\NaruceniProizvod
     */
    public function setNarucenaKolicina($narucenaKolicina = null)
    {
        // validation for constraint: int
        if (!is_null($narucenaKolicina) && !(is_int($narucenaKolicina) || ctype_digit($narucenaKolicina))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($narucenaKolicina, true), gettype($narucenaKolicina)), __LINE__);
        }
        $this->narucenaKolicina = $narucenaKolicina;
        return $this;
    }
    /**
     * Get otpremljenaKolicina value
     * @return int|null
     */
    public function getOtpremljenaKolicina()
    {
        return $this->otpremljenaKolicina;
    }
    /**
     * Set otpremljenaKolicina value
     * @param int $otpremljenaKolicina
     * @return \StructType\NaruceniProizvod
     */
    public function setOtpremljenaKolicina($otpremljenaKolicina = null)
    {
        // validation for constraint: int
        if (!is_null($otpremljenaKolicina) && !(is_int($otpremljenaKolicina) || ctype_digit($otpremljenaKolicina))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($otpremljenaKolicina, true), gettype($otpremljenaKolicina)), __LINE__);
        }
        $this->otpremljenaKolicina = $otpremljenaKolicina;
        return $this;
    }
}
