<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListaZaRekalkulaciju StructType
 * @subpackage Structs
 */
class ListaZaRekalkulaciju extends AbstractStructBase
{
    /**
     * The proizvodi
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProizvodZaRekalkulacijuCijeneIKolicine[]
     */
    public $proizvodi;
    /**
     * Constructor method for ListaZaRekalkulaciju
     * @uses ListaZaRekalkulaciju::setProizvodi()
     * @param \StructType\ProizvodZaRekalkulacijuCijeneIKolicine[] $proizvodi
     */
    public function __construct(array $proizvodi = array())
    {
        $this
            ->setProizvodi($proizvodi);
    }
    /**
     * Get proizvodi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProizvodZaRekalkulacijuCijeneIKolicine[]|null
     */
    public function getProizvodi()
    {
        return isset($this->proizvodi) ? $this->proizvodi : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProizvodi method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProizvodi method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProizvodiForArrayConstraintsFromSetProizvodi(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listaZaRekalkulacijuProizvodiItem) {
            // validation for constraint: itemType
            if (!$listaZaRekalkulacijuProizvodiItem instanceof \StructType\ProizvodZaRekalkulacijuCijeneIKolicine) {
                $invalidValues[] = is_object($listaZaRekalkulacijuProizvodiItem) ? get_class($listaZaRekalkulacijuProizvodiItem) : sprintf('%s(%s)', gettype($listaZaRekalkulacijuProizvodiItem), var_export($listaZaRekalkulacijuProizvodiItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The proizvodi property can only contain items of type \StructType\ProizvodZaRekalkulacijuCijeneIKolicine, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set proizvodi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProizvodZaRekalkulacijuCijeneIKolicine[] $proizvodi
     * @return \StructType\ListaZaRekalkulaciju
     */
    public function setProizvodi(array $proizvodi = array())
    {
        // validation for constraint: array
        if ('' !== ($proizvodiArrayErrorMessage = self::validateProizvodiForArrayConstraintsFromSetProizvodi($proizvodi))) {
            throw new \InvalidArgumentException($proizvodiArrayErrorMessage, __LINE__);
        }
        if (is_null($proizvodi) || (is_array($proizvodi) && empty($proizvodi))) {
            unset($this->proizvodi);
        } else {
            $this->proizvodi = $proizvodi;
        }
        return $this;
    }
    /**
     * Add item to proizvodi value
     * @throws \InvalidArgumentException
     * @param \StructType\ProizvodZaRekalkulacijuCijeneIKolicine $item
     * @return \StructType\ListaZaRekalkulaciju
     */
    public function addToProizvodi(\StructType\ProizvodZaRekalkulacijuCijeneIKolicine $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProizvodZaRekalkulacijuCijeneIKolicine) {
            throw new \InvalidArgumentException(sprintf('The proizvodi property can only contain items of type \StructType\ProizvodZaRekalkulacijuCijeneIKolicine, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->proizvodi[] = $item;
        return $this;
    }
}
