<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListaPoslovnica StructType
 * @subpackage Structs
 */
class ListaPoslovnica extends AbstractStructBase
{
    /**
     * The poslovnica
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Poslovnica[]
     */
    public $poslovnica;
    /**
     * Constructor method for ListaPoslovnica
     * @uses ListaPoslovnica::setPoslovnica()
     * @param \StructType\Poslovnica[] $poslovnica
     */
    public function __construct(array $poslovnica = array())
    {
        $this
            ->setPoslovnica($poslovnica);
    }
    /**
     * Get poslovnica value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Poslovnica[]|null
     */
    public function getPoslovnica()
    {
        return isset($this->poslovnica) ? $this->poslovnica : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPoslovnica method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPoslovnica method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePoslovnicaForArrayConstraintsFromSetPoslovnica(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listaPoslovnicaPoslovnicaItem) {
            // validation for constraint: itemType
            if (!$listaPoslovnicaPoslovnicaItem instanceof \StructType\Poslovnica) {
                $invalidValues[] = is_object($listaPoslovnicaPoslovnicaItem) ? get_class($listaPoslovnicaPoslovnicaItem) : sprintf('%s(%s)', gettype($listaPoslovnicaPoslovnicaItem), var_export($listaPoslovnicaPoslovnicaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The poslovnica property can only contain items of type \StructType\Poslovnica, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set poslovnica value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Poslovnica[] $poslovnica
     * @return \StructType\ListaPoslovnica
     */
    public function setPoslovnica(array $poslovnica = array())
    {
        // validation for constraint: array
        if ('' !== ($poslovnicaArrayErrorMessage = self::validatePoslovnicaForArrayConstraintsFromSetPoslovnica($poslovnica))) {
            throw new \InvalidArgumentException($poslovnicaArrayErrorMessage, __LINE__);
        }
        if (is_null($poslovnica) || (is_array($poslovnica) && empty($poslovnica))) {
            unset($this->poslovnica);
        } else {
            $this->poslovnica = $poslovnica;
        }
        return $this;
    }
    /**
     * Add item to poslovnica value
     * @throws \InvalidArgumentException
     * @param \StructType\Poslovnica $item
     * @return \StructType\ListaPoslovnica
     */
    public function addToPoslovnica(\StructType\Poslovnica $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Poslovnica) {
            throw new \InvalidArgumentException(sprintf('The poslovnica property can only contain items of type \StructType\Poslovnica, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->poslovnica[] = $item;
        return $this;
    }
}
