<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for grad StructType
 * @subpackage Structs
 */
class Grad extends AbstractStructBase
{
    /**
     * The nazivGrada
     * @var string
     */
    public $nazivGrada;
    /**
     * The postanskiBroj
     * @var int
     */
    public $postanskiBroj;
    /**
     * The sifraOpcine
     * @var int
     */
    public $sifraOpcine;
    /**
     * The ListaSkola
     * @var \StructType\ListaSkola
     */
    public $ListaSkola;
    /**
     * Constructor method for grad
     * @uses Grad::setNazivGrada()
     * @uses Grad::setPostanskiBroj()
     * @uses Grad::setSifraOpcine()
     * @uses Grad::setListaSkola()
     * @param string $nazivGrada
     * @param int $postanskiBroj
     * @param int $sifraOpcine
     * @param \StructType\ListaSkola $listaSkola
     */
    public function __construct($nazivGrada = null, $postanskiBroj = null, $sifraOpcine = null, \StructType\ListaSkola $listaSkola = null)
    {
        $this
            ->setNazivGrada($nazivGrada)
            ->setPostanskiBroj($postanskiBroj)
            ->setSifraOpcine($sifraOpcine)
            ->setListaSkola($listaSkola);
    }
    /**
     * Get nazivGrada value
     * @return string|null
     */
    public function getNazivGrada()
    {
        return $this->nazivGrada;
    }
    /**
     * Set nazivGrada value
     * @param string $nazivGrada
     * @return \StructType\Grad
     */
    public function setNazivGrada($nazivGrada = null)
    {
        // validation for constraint: string
        if (!is_null($nazivGrada) && !is_string($nazivGrada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazivGrada, true), gettype($nazivGrada)), __LINE__);
        }
        $this->nazivGrada = $nazivGrada;
        return $this;
    }
    /**
     * Get postanskiBroj value
     * @return int|null
     */
    public function getPostanskiBroj()
    {
        return $this->postanskiBroj;
    }
    /**
     * Set postanskiBroj value
     * @param int $postanskiBroj
     * @return \StructType\Grad
     */
    public function setPostanskiBroj($postanskiBroj = null)
    {
        // validation for constraint: int
        if (!is_null($postanskiBroj) && !(is_int($postanskiBroj) || ctype_digit($postanskiBroj))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($postanskiBroj, true), gettype($postanskiBroj)), __LINE__);
        }
        $this->postanskiBroj = $postanskiBroj;
        return $this;
    }
    /**
     * Get sifraOpcine value
     * @return int|null
     */
    public function getSifraOpcine()
    {
        return $this->sifraOpcine;
    }
    /**
     * Set sifraOpcine value
     * @param int $sifraOpcine
     * @return \StructType\Grad
     */
    public function setSifraOpcine($sifraOpcine = null)
    {
        // validation for constraint: int
        if (!is_null($sifraOpcine) && !(is_int($sifraOpcine) || ctype_digit($sifraOpcine))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sifraOpcine, true), gettype($sifraOpcine)), __LINE__);
        }
        $this->sifraOpcine = $sifraOpcine;
        return $this;
    }
    /**
     * Get ListaSkola value
     * @return \StructType\ListaSkola|null
     */
    public function getListaSkola()
    {
        return $this->ListaSkola;
    }
    /**
     * Set ListaSkola value
     * @param \StructType\ListaSkola $listaSkola
     * @return \StructType\Grad
     */
    public function setListaSkola(\StructType\ListaSkola $listaSkola = null)
    {
        $this->ListaSkola = $listaSkola;
        return $this;
    }
}
