<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Provjera ServiceType
 * @subpackage Services
 */
class Provjera extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named provjeraBona
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProvjeraBona $parameters
     * @return \StructType\ProvjeraBonaResponse|bool
     */
    public function provjeraBona(\StructType\ProvjeraBona $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->provjeraBona($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProvjeraBonaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
