<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Posalji ServiceType
 * @subpackage Services
 */
class Posalji extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named posaljiNalog
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PosaljiNalog $parameters
     * @return \StructType\PosaljiNalogResponse|bool
     */
    public function posaljiNalog(\StructType\PosaljiNalog $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->posaljiNalog($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PosaljiNalogResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
