<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for skola StructType
 * @subpackage Structs
 */
class Skola extends AbstractStructBase
{
    /**
     * The sifraSkole
     * @var string
     */
    public $sifraSkole;
    /**
     * The nazivSkole
     * @var string
     */
    public $nazivSkole;
    /**
     * The ulica
     * @var string
     */
    public $ulica;
    /**
     * The webAdresa
     * @var string
     */
    public $webAdresa;
    /**
     * The email
     * @var string
     */
    public $email;
    /**
     * The ListaRazreda
     * @var \StructType\ListaRazreda
     */
    public $ListaRazreda;
    /**
     * Constructor method for skola
     * @uses Skola::setSifraSkole()
     * @uses Skola::setNazivSkole()
     * @uses Skola::setUlica()
     * @uses Skola::setWebAdresa()
     * @uses Skola::setEmail()
     * @uses Skola::setListaRazreda()
     * @param string $sifraSkole
     * @param string $nazivSkole
     * @param string $ulica
     * @param string $webAdresa
     * @param string $email
     * @param \StructType\ListaRazreda $listaRazreda
     */
    public function __construct($sifraSkole = null, $nazivSkole = null, $ulica = null, $webAdresa = null, $email = null, \StructType\ListaRazreda $listaRazreda = null)
    {
        $this
            ->setSifraSkole($sifraSkole)
            ->setNazivSkole($nazivSkole)
            ->setUlica($ulica)
            ->setWebAdresa($webAdresa)
            ->setEmail($email)
            ->setListaRazreda($listaRazreda);
    }
    /**
     * Get sifraSkole value
     * @return string|null
     */
    public function getSifraSkole()
    {
        return $this->sifraSkole;
    }
    /**
     * Set sifraSkole value
     * @param string $sifraSkole
     * @return \StructType\Skola
     */
    public function setSifraSkole($sifraSkole = null)
    {
        // validation for constraint: string
        if (!is_null($sifraSkole) && !is_string($sifraSkole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifraSkole, true), gettype($sifraSkole)), __LINE__);
        }
        $this->sifraSkole = $sifraSkole;
        return $this;
    }
    /**
     * Get nazivSkole value
     * @return string|null
     */
    public function getNazivSkole()
    {
        return $this->nazivSkole;
    }
    /**
     * Set nazivSkole value
     * @param string $nazivSkole
     * @return \StructType\Skola
     */
    public function setNazivSkole($nazivSkole = null)
    {
        // validation for constraint: string
        if (!is_null($nazivSkole) && !is_string($nazivSkole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazivSkole, true), gettype($nazivSkole)), __LINE__);
        }
        $this->nazivSkole = $nazivSkole;
        return $this;
    }
    /**
     * Get ulica value
     * @return string|null
     */
    public function getUlica()
    {
        return $this->ulica;
    }
    /**
     * Set ulica value
     * @param string $ulica
     * @return \StructType\Skola
     */
    public function setUlica($ulica = null)
    {
        // validation for constraint: string
        if (!is_null($ulica) && !is_string($ulica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ulica, true), gettype($ulica)), __LINE__);
        }
        $this->ulica = $ulica;
        return $this;
    }
    /**
     * Get webAdresa value
     * @return string|null
     */
    public function getWebAdresa()
    {
        return $this->webAdresa;
    }
    /**
     * Set webAdresa value
     * @param string $webAdresa
     * @return \StructType\Skola
     */
    public function setWebAdresa($webAdresa = null)
    {
        // validation for constraint: string
        if (!is_null($webAdresa) && !is_string($webAdresa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webAdresa, true), gettype($webAdresa)), __LINE__);
        }
        $this->webAdresa = $webAdresa;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Skola
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get ListaRazreda value
     * @return \StructType\ListaRazreda|null
     */
    public function getListaRazreda()
    {
        return $this->ListaRazreda;
    }
    /**
     * Set ListaRazreda value
     * @param \StructType\ListaRazreda $listaRazreda
     * @return \StructType\Skola
     */
    public function setListaRazreda(\StructType\ListaRazreda $listaRazreda = null)
    {
        $this->ListaRazreda = $listaRazreda;
        return $this;
    }
}
