<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for razred StructType
 * @subpackage Structs
 */
class Razred extends AbstractStructBase
{
    /**
     * The nazivRazreda
     * @var string
     */
    public $nazivRazreda;
    /**
     * The ListaSmjerova
     * @var \StructType\ListaSmjerova
     */
    public $ListaSmjerova;
    /**
     * Constructor method for razred
     * @uses Razred::setNazivRazreda()
     * @uses Razred::setListaSmjerova()
     * @param string $nazivRazreda
     * @param \StructType\ListaSmjerova $listaSmjerova
     */
    public function __construct($nazivRazreda = null, \StructType\ListaSmjerova $listaSmjerova = null)
    {
        $this
            ->setNazivRazreda($nazivRazreda)
            ->setListaSmjerova($listaSmjerova);
    }
    /**
     * Get nazivRazreda value
     * @return string|null
     */
    public function getNazivRazreda()
    {
        return $this->nazivRazreda;
    }
    /**
     * Set nazivRazreda value
     * @param string $nazivRazreda
     * @return \StructType\Razred
     */
    public function setNazivRazreda($nazivRazreda = null)
    {
        // validation for constraint: string
        if (!is_null($nazivRazreda) && !is_string($nazivRazreda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazivRazreda, true), gettype($nazivRazreda)), __LINE__);
        }
        $this->nazivRazreda = $nazivRazreda;
        return $this;
    }
    /**
     * Get ListaSmjerova value
     * @return \StructType\ListaSmjerova|null
     */
    public function getListaSmjerova()
    {
        return $this->ListaSmjerova;
    }
    /**
     * Set ListaSmjerova value
     * @param \StructType\ListaSmjerova $listaSmjerova
     * @return \StructType\Razred
     */
    public function setListaSmjerova(\StructType\ListaSmjerova $listaSmjerova = null)
    {
        $this->ListaSmjerova = $listaSmjerova;
        return $this;
    }
}
