<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Poslovnica StructType
 * @subpackage Structs
 */
class Poslovnica extends AbstractStructBase
{
    /**
     * The sifraPoslovnice
     * @var string
     */
    public $sifraPoslovnice;
    /**
     * The nazivPoslovnice
     * @var string
     */
    public $nazivPoslovnice;
    /**
     * The pttBroj
     * @var string
     */
    public $pttBroj;
    /**
     * The nazivMjesta
     * @var string
     */
    public $nazivMjesta;
    /**
     * The ulica
     * @var string
     */
    public $ulica;
    /**
     * The telefon
     * @var string
     */
    public $telefon;
    /**
     * The fax
     * @var string
     */
    public $fax;
    /**
     * Constructor method for Poslovnica
     * @uses Poslovnica::setSifraPoslovnice()
     * @uses Poslovnica::setNazivPoslovnice()
     * @uses Poslovnica::setPttBroj()
     * @uses Poslovnica::setNazivMjesta()
     * @uses Poslovnica::setUlica()
     * @uses Poslovnica::setTelefon()
     * @uses Poslovnica::setFax()
     * @param string $sifraPoslovnice
     * @param string $nazivPoslovnice
     * @param string $pttBroj
     * @param string $nazivMjesta
     * @param string $ulica
     * @param string $telefon
     * @param string $fax
     */
    public function __construct($sifraPoslovnice = null, $nazivPoslovnice = null, $pttBroj = null, $nazivMjesta = null, $ulica = null, $telefon = null, $fax = null)
    {
        $this
            ->setSifraPoslovnice($sifraPoslovnice)
            ->setNazivPoslovnice($nazivPoslovnice)
            ->setPttBroj($pttBroj)
            ->setNazivMjesta($nazivMjesta)
            ->setUlica($ulica)
            ->setTelefon($telefon)
            ->setFax($fax);
    }
    /**
     * Get sifraPoslovnice value
     * @return string|null
     */
    public function getSifraPoslovnice()
    {
        return $this->sifraPoslovnice;
    }
    /**
     * Set sifraPoslovnice value
     * @param string $sifraPoslovnice
     * @return \StructType\Poslovnica
     */
    public function setSifraPoslovnice($sifraPoslovnice = null)
    {
        // validation for constraint: string
        if (!is_null($sifraPoslovnice) && !is_string($sifraPoslovnice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifraPoslovnice, true), gettype($sifraPoslovnice)), __LINE__);
        }
        $this->sifraPoslovnice = $sifraPoslovnice;
        return $this;
    }
    /**
     * Get nazivPoslovnice value
     * @return string|null
     */
    public function getNazivPoslovnice()
    {
        return $this->nazivPoslovnice;
    }
    /**
     * Set nazivPoslovnice value
     * @param string $nazivPoslovnice
     * @return \StructType\Poslovnica
     */
    public function setNazivPoslovnice($nazivPoslovnice = null)
    {
        // validation for constraint: string
        if (!is_null($nazivPoslovnice) && !is_string($nazivPoslovnice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazivPoslovnice, true), gettype($nazivPoslovnice)), __LINE__);
        }
        $this->nazivPoslovnice = $nazivPoslovnice;
        return $this;
    }
    /**
     * Get pttBroj value
     * @return string|null
     */
    public function getPttBroj()
    {
        return $this->pttBroj;
    }
    /**
     * Set pttBroj value
     * @param string $pttBroj
     * @return \StructType\Poslovnica
     */
    public function setPttBroj($pttBroj = null)
    {
        // validation for constraint: string
        if (!is_null($pttBroj) && !is_string($pttBroj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pttBroj, true), gettype($pttBroj)), __LINE__);
        }
        $this->pttBroj = $pttBroj;
        return $this;
    }
    /**
     * Get nazivMjesta value
     * @return string|null
     */
    public function getNazivMjesta()
    {
        return $this->nazivMjesta;
    }
    /**
     * Set nazivMjesta value
     * @param string $nazivMjesta
     * @return \StructType\Poslovnica
     */
    public function setNazivMjesta($nazivMjesta = null)
    {
        // validation for constraint: string
        if (!is_null($nazivMjesta) && !is_string($nazivMjesta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazivMjesta, true), gettype($nazivMjesta)), __LINE__);
        }
        $this->nazivMjesta = $nazivMjesta;
        return $this;
    }
    /**
     * Get ulica value
     * @return string|null
     */
    public function getUlica()
    {
        return $this->ulica;
    }
    /**
     * Set ulica value
     * @param string $ulica
     * @return \StructType\Poslovnica
     */
    public function setUlica($ulica = null)
    {
        // validation for constraint: string
        if (!is_null($ulica) && !is_string($ulica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ulica, true), gettype($ulica)), __LINE__);
        }
        $this->ulica = $ulica;
        return $this;
    }
    /**
     * Get telefon value
     * @return string|null
     */
    public function getTelefon()
    {
        return $this->telefon;
    }
    /**
     * Set telefon value
     * @param string $telefon
     * @return \StructType\Poslovnica
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: string
        if (!is_null($telefon) && !is_string($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefon, true), gettype($telefon)), __LINE__);
        }
        $this->telefon = $telefon;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\Poslovnica
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
}
