<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Partner StructType
 * @subpackage Structs
 */
class Partner extends AbstractStructBase
{
    /**
     * The tip
     * @var string
     */
    public $tip;
    /**
     * The sifra
     * @var string
     */
    public $sifra;
    /**
     * The naziv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $naziv;
    /**
     * The oib
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $oib;
    /**
     * The ulica
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ulica;
    /**
     * The postanskiBroj
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $postanskiBroj;
    /**
     * The mjesto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mjesto;
    /**
     * The drzava
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $drzava;
    /**
     * The telefon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $telefon;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The poreznoOslobodjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $poreznoOslobodjene;
    /**
     * The listaDostavnihMjesta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ListaDostavnihMjesta
     */
    public $listaDostavnihMjesta;
    /**
     * The lozinkaZaPrvuPrijavu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lozinkaZaPrvuPrijavu;
    /**
     * The b2bProdukti
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $b2bProdukti;
    /**
     * Constructor method for Partner
     * @uses Partner::setTip()
     * @uses Partner::setSifra()
     * @uses Partner::setNaziv()
     * @uses Partner::setOib()
     * @uses Partner::setUlica()
     * @uses Partner::setPostanskiBroj()
     * @uses Partner::setMjesto()
     * @uses Partner::setDrzava()
     * @uses Partner::setTelefon()
     * @uses Partner::setFax()
     * @uses Partner::setEmail()
     * @uses Partner::setPoreznoOslobodjene()
     * @uses Partner::setListaDostavnihMjesta()
     * @uses Partner::setLozinkaZaPrvuPrijavu()
     * @uses Partner::setB2bProdukti()
     * @param string $tip
     * @param string $sifra
     * @param string $naziv
     * @param string $oib
     * @param string $ulica
     * @param int $postanskiBroj
     * @param string $mjesto
     * @param string $drzava
     * @param string $telefon
     * @param string $fax
     * @param string $email
     * @param string $poreznoOslobodjene
     * @param \StructType\ListaDostavnihMjesta $listaDostavnihMjesta
     * @param string $lozinkaZaPrvuPrijavu
     * @param string $b2bProdukti
     */
    public function __construct($tip = null, $sifra = null, $naziv = null, $oib = null, $ulica = null, $postanskiBroj = null, $mjesto = null, $drzava = null, $telefon = null, $fax = null, $email = null, $poreznoOslobodjene = null, \StructType\ListaDostavnihMjesta $listaDostavnihMjesta = null, $lozinkaZaPrvuPrijavu = null, $b2bProdukti = null)
    {
        $this
            ->setTip($tip)
            ->setSifra($sifra)
            ->setNaziv($naziv)
            ->setOib($oib)
            ->setUlica($ulica)
            ->setPostanskiBroj($postanskiBroj)
            ->setMjesto($mjesto)
            ->setDrzava($drzava)
            ->setTelefon($telefon)
            ->setFax($fax)
            ->setEmail($email)
            ->setPoreznoOslobodjene($poreznoOslobodjene)
            ->setListaDostavnihMjesta($listaDostavnihMjesta)
            ->setLozinkaZaPrvuPrijavu($lozinkaZaPrvuPrijavu)
            ->setB2bProdukti($b2bProdukti);
    }
    /**
     * Get tip value
     * @return string|null
     */
    public function getTip()
    {
        return $this->tip;
    }
    /**
     * Set tip value
     * @param string $tip
     * @return \StructType\Partner
     */
    public function setTip($tip = null)
    {
        // validation for constraint: string
        if (!is_null($tip) && !is_string($tip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tip, true), gettype($tip)), __LINE__);
        }
        $this->tip = $tip;
        return $this;
    }
    /**
     * Get sifra value
     * @return string|null
     */
    public function getSifra()
    {
        return $this->sifra;
    }
    /**
     * Set sifra value
     * @param string $sifra
     * @return \StructType\Partner
     */
    public function setSifra($sifra = null)
    {
        // validation for constraint: string
        if (!is_null($sifra) && !is_string($sifra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifra, true), gettype($sifra)), __LINE__);
        }
        $this->sifra = $sifra;
        return $this;
    }
    /**
     * Get naziv value
     * @return string|null
     */
    public function getNaziv()
    {
        return $this->naziv;
    }
    /**
     * Set naziv value
     * @param string $naziv
     * @return \StructType\Partner
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        $this->naziv = $naziv;
        return $this;
    }
    /**
     * Get oib value
     * @return string|null
     */
    public function getOib()
    {
        return $this->oib;
    }
    /**
     * Set oib value
     * @param string $oib
     * @return \StructType\Partner
     */
    public function setOib($oib = null)
    {
        // validation for constraint: string
        if (!is_null($oib) && !is_string($oib)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oib, true), gettype($oib)), __LINE__);
        }
        $this->oib = $oib;
        return $this;
    }
    /**
     * Get ulica value
     * @return string|null
     */
    public function getUlica()
    {
        return $this->ulica;
    }
    /**
     * Set ulica value
     * @param string $ulica
     * @return \StructType\Partner
     */
    public function setUlica($ulica = null)
    {
        // validation for constraint: string
        if (!is_null($ulica) && !is_string($ulica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ulica, true), gettype($ulica)), __LINE__);
        }
        $this->ulica = $ulica;
        return $this;
    }
    /**
     * Get postanskiBroj value
     * @return int|null
     */
    public function getPostanskiBroj()
    {
        return $this->postanskiBroj;
    }
    /**
     * Set postanskiBroj value
     * @param int $postanskiBroj
     * @return \StructType\Partner
     */
    public function setPostanskiBroj($postanskiBroj = null)
    {
        // validation for constraint: int
        if (!is_null($postanskiBroj) && !(is_int($postanskiBroj) || ctype_digit($postanskiBroj))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($postanskiBroj, true), gettype($postanskiBroj)), __LINE__);
        }
        $this->postanskiBroj = $postanskiBroj;
        return $this;
    }
    /**
     * Get mjesto value
     * @return string|null
     */
    public function getMjesto()
    {
        return $this->mjesto;
    }
    /**
     * Set mjesto value
     * @param string $mjesto
     * @return \StructType\Partner
     */
    public function setMjesto($mjesto = null)
    {
        // validation for constraint: string
        if (!is_null($mjesto) && !is_string($mjesto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mjesto, true), gettype($mjesto)), __LINE__);
        }
        $this->mjesto = $mjesto;
        return $this;
    }
    /**
     * Get drzava value
     * @return string|null
     */
    public function getDrzava()
    {
        return $this->drzava;
    }
    /**
     * Set drzava value
     * @param string $drzava
     * @return \StructType\Partner
     */
    public function setDrzava($drzava = null)
    {
        // validation for constraint: string
        if (!is_null($drzava) && !is_string($drzava)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($drzava, true), gettype($drzava)), __LINE__);
        }
        $this->drzava = $drzava;
        return $this;
    }
    /**
     * Get telefon value
     * @return string|null
     */
    public function getTelefon()
    {
        return $this->telefon;
    }
    /**
     * Set telefon value
     * @param string $telefon
     * @return \StructType\Partner
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: string
        if (!is_null($telefon) && !is_string($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefon, true), gettype($telefon)), __LINE__);
        }
        $this->telefon = $telefon;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\Partner
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Partner
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get poreznoOslobodjene value
     * @return string|null
     */
    public function getPoreznoOslobodjene()
    {
        return $this->poreznoOslobodjene;
    }
    /**
     * Set poreznoOslobodjene value
     * @param string $poreznoOslobodjene
     * @return \StructType\Partner
     */
    public function setPoreznoOslobodjene($poreznoOslobodjene = null)
    {
        // validation for constraint: string
        if (!is_null($poreznoOslobodjene) && !is_string($poreznoOslobodjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poreznoOslobodjene, true), gettype($poreznoOslobodjene)), __LINE__);
        }
        $this->poreznoOslobodjene = $poreznoOslobodjene;
        return $this;
    }
    /**
     * Get listaDostavnihMjesta value
     * @return \StructType\ListaDostavnihMjesta|null
     */
    public function getListaDostavnihMjesta()
    {
        return $this->listaDostavnihMjesta;
    }
    /**
     * Set listaDostavnihMjesta value
     * @param \StructType\ListaDostavnihMjesta $listaDostavnihMjesta
     * @return \StructType\Partner
     */
    public function setListaDostavnihMjesta(\StructType\ListaDostavnihMjesta $listaDostavnihMjesta = null)
    {
        $this->listaDostavnihMjesta = $listaDostavnihMjesta;
        return $this;
    }
    /**
     * Get lozinkaZaPrvuPrijavu value
     * @return string|null
     */
    public function getLozinkaZaPrvuPrijavu()
    {
        return $this->lozinkaZaPrvuPrijavu;
    }
    /**
     * Set lozinkaZaPrvuPrijavu value
     * @param string $lozinkaZaPrvuPrijavu
     * @return \StructType\Partner
     */
    public function setLozinkaZaPrvuPrijavu($lozinkaZaPrvuPrijavu = null)
    {
        // validation for constraint: string
        if (!is_null($lozinkaZaPrvuPrijavu) && !is_string($lozinkaZaPrvuPrijavu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lozinkaZaPrvuPrijavu, true), gettype($lozinkaZaPrvuPrijavu)), __LINE__);
        }
        $this->lozinkaZaPrvuPrijavu = $lozinkaZaPrvuPrijavu;
        return $this;
    }
    /**
     * Get b2bProdukti value
     * @return string|null
     */
    public function getB2bProdukti()
    {
        return $this->b2bProdukti;
    }
    /**
     * Set b2bProdukti value
     * @param string $b2bProdukti
     * @return \StructType\Partner
     */
    public function setB2bProdukti($b2bProdukti = null)
    {
        // validation for constraint: string
        if (!is_null($b2bProdukti) && !is_string($b2bProdukti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($b2bProdukti, true), gettype($b2bProdukti)), __LINE__);
        }
        $this->b2bProdukti = $b2bProdukti;
        return $this;
    }
}
