<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListaSmjerova StructType
 * @subpackage Structs
 */
class ListaSmjerova extends AbstractStructBase
{
    /**
     * The smjer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Smjer[]
     */
    public $smjer;
    /**
     * Constructor method for ListaSmjerova
     * @uses ListaSmjerova::setSmjer()
     * @param \StructType\Smjer[] $smjer
     */
    public function __construct(array $smjer = array())
    {
        $this
            ->setSmjer($smjer);
    }
    /**
     * Get smjer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Smjer[]|null
     */
    public function getSmjer()
    {
        return isset($this->smjer) ? $this->smjer : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSmjer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSmjer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSmjerForArrayConstraintsFromSetSmjer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listaSmjerovaSmjerItem) {
            // validation for constraint: itemType
            if (!$listaSmjerovaSmjerItem instanceof \StructType\Smjer) {
                $invalidValues[] = is_object($listaSmjerovaSmjerItem) ? get_class($listaSmjerovaSmjerItem) : sprintf('%s(%s)', gettype($listaSmjerovaSmjerItem), var_export($listaSmjerovaSmjerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The smjer property can only contain items of type \StructType\Smjer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set smjer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Smjer[] $smjer
     * @return \StructType\ListaSmjerova
     */
    public function setSmjer(array $smjer = array())
    {
        // validation for constraint: array
        if ('' !== ($smjerArrayErrorMessage = self::validateSmjerForArrayConstraintsFromSetSmjer($smjer))) {
            throw new \InvalidArgumentException($smjerArrayErrorMessage, __LINE__);
        }
        if (is_null($smjer) || (is_array($smjer) && empty($smjer))) {
            unset($this->smjer);
        } else {
            $this->smjer = $smjer;
        }
        return $this;
    }
    /**
     * Add item to smjer value
     * @throws \InvalidArgumentException
     * @param \StructType\Smjer $item
     * @return \StructType\ListaSmjerova
     */
    public function addToSmjer(\StructType\Smjer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Smjer) {
            throw new \InvalidArgumentException(sprintf('The smjer property can only contain items of type \StructType\Smjer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->smjer[] = $item;
        return $this;
    }
}
