<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListaLopClanova StructType
 * @subpackage Structs
 */
class ListaLopClanova extends AbstractStructBase
{
    /**
     * The lopClan
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LopClan[]
     */
    public $lopClan;
    /**
     * Constructor method for ListaLopClanova
     * @uses ListaLopClanova::setLopClan()
     * @param \StructType\LopClan[] $lopClan
     */
    public function __construct(array $lopClan = array())
    {
        $this
            ->setLopClan($lopClan);
    }
    /**
     * Get lopClan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LopClan[]|null
     */
    public function getLopClan()
    {
        return isset($this->lopClan) ? $this->lopClan : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLopClan method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLopClan method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLopClanForArrayConstraintsFromSetLopClan(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listaLopClanovaLopClanItem) {
            // validation for constraint: itemType
            if (!$listaLopClanovaLopClanItem instanceof \StructType\LopClan) {
                $invalidValues[] = is_object($listaLopClanovaLopClanItem) ? get_class($listaLopClanovaLopClanItem) : sprintf('%s(%s)', gettype($listaLopClanovaLopClanItem), var_export($listaLopClanovaLopClanItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The lopClan property can only contain items of type \StructType\LopClan, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set lopClan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LopClan[] $lopClan
     * @return \StructType\ListaLopClanova
     */
    public function setLopClan(array $lopClan = array())
    {
        // validation for constraint: array
        if ('' !== ($lopClanArrayErrorMessage = self::validateLopClanForArrayConstraintsFromSetLopClan($lopClan))) {
            throw new \InvalidArgumentException($lopClanArrayErrorMessage, __LINE__);
        }
        if (is_null($lopClan) || (is_array($lopClan) && empty($lopClan))) {
            unset($this->lopClan);
        } else {
            $this->lopClan = $lopClan;
        }
        return $this;
    }
    /**
     * Add item to lopClan value
     * @throws \InvalidArgumentException
     * @param \StructType\LopClan $item
     * @return \StructType\ListaLopClanova
     */
    public function addToLopClan(\StructType\LopClan $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LopClan) {
            throw new \InvalidArgumentException(sprintf('The lopClan property can only contain items of type \StructType\LopClan, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->lopClan[] = $item;
        return $this;
    }
}
