<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListaGradova StructType
 * @subpackage Structs
 */
class ListaGradova extends AbstractStructBase
{
    /**
     * The grad
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Grad[]
     */
    public $grad;
    /**
     * Constructor method for ListaGradova
     * @uses ListaGradova::setGrad()
     * @param \StructType\Grad[] $grad
     */
    public function __construct(array $grad = array())
    {
        $this
            ->setGrad($grad);
    }
    /**
     * Get grad value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Grad[]|null
     */
    public function getGrad()
    {
        return isset($this->grad) ? $this->grad : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGrad method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGrad method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGradForArrayConstraintsFromSetGrad(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listaGradovaGradItem) {
            // validation for constraint: itemType
            if (!$listaGradovaGradItem instanceof \StructType\Grad) {
                $invalidValues[] = is_object($listaGradovaGradItem) ? get_class($listaGradovaGradItem) : sprintf('%s(%s)', gettype($listaGradovaGradItem), var_export($listaGradovaGradItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The grad property can only contain items of type \StructType\Grad, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set grad value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Grad[] $grad
     * @return \StructType\ListaGradova
     */
    public function setGrad(array $grad = array())
    {
        // validation for constraint: array
        if ('' !== ($gradArrayErrorMessage = self::validateGradForArrayConstraintsFromSetGrad($grad))) {
            throw new \InvalidArgumentException($gradArrayErrorMessage, __LINE__);
        }
        if (is_null($grad) || (is_array($grad) && empty($grad))) {
            unset($this->grad);
        } else {
            $this->grad = $grad;
        }
        return $this;
    }
    /**
     * Add item to grad value
     * @throws \InvalidArgumentException
     * @param \StructType\Grad $item
     * @return \StructType\ListaGradova
     */
    public function addToGrad(\StructType\Grad $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Grad) {
            throw new \InvalidArgumentException(sprintf('The grad property can only contain items of type \StructType\Grad, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->grad[] = $item;
        return $this;
    }
}
