<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListaAkcija StructType
 * @subpackage Structs
 */
class ListaAkcija extends AbstractStructBase
{
    /**
     * The akcija
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ERPAkcija[]
     */
    public $akcija;
    /**
     * Constructor method for ListaAkcija
     * @uses ListaAkcija::setAkcija()
     * @param \StructType\ERPAkcija[] $akcija
     */
    public function __construct(array $akcija = array())
    {
        $this
            ->setAkcija($akcija);
    }
    /**
     * Get akcija value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ERPAkcija[]|null
     */
    public function getAkcija()
    {
        return isset($this->akcija) ? $this->akcija : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAkcija method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAkcija method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAkcijaForArrayConstraintsFromSetAkcija(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listaAkcijaAkcijaItem) {
            // validation for constraint: itemType
            if (!$listaAkcijaAkcijaItem instanceof \StructType\ERPAkcija) {
                $invalidValues[] = is_object($listaAkcijaAkcijaItem) ? get_class($listaAkcijaAkcijaItem) : sprintf('%s(%s)', gettype($listaAkcijaAkcijaItem), var_export($listaAkcijaAkcijaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The akcija property can only contain items of type \StructType\ERPAkcija, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set akcija value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ERPAkcija[] $akcija
     * @return \StructType\ListaAkcija
     */
    public function setAkcija(array $akcija = array())
    {
        // validation for constraint: array
        if ('' !== ($akcijaArrayErrorMessage = self::validateAkcijaForArrayConstraintsFromSetAkcija($akcija))) {
            throw new \InvalidArgumentException($akcijaArrayErrorMessage, __LINE__);
        }
        if (is_null($akcija) || (is_array($akcija) && empty($akcija))) {
            unset($this->akcija);
        } else {
            $this->akcija = $akcija;
        }
        return $this;
    }
    /**
     * Add item to akcija value
     * @throws \InvalidArgumentException
     * @param \StructType\ERPAkcija $item
     * @return \StructType\ListaAkcija
     */
    public function addToAkcija(\StructType\ERPAkcija $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ERPAkcija) {
            throw new \InvalidArgumentException(sprintf('The akcija property can only contain items of type \StructType\ERPAkcija, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->akcija[] = $item;
        return $this;
    }
}
