<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Kategorija StructType
 * @subpackage Structs
 */
class Kategorija extends AbstractStructBase
{
    /**
     * The sifra
     * @var string
     */
    public $sifra;
    /**
     * The naziv
     * @var string
     */
    public $naziv;
    /**
     * The nadKategorija
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nadKategorija;
    /**
     * The listaSifriProizvoda
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ListaSifri
     */
    public $listaSifriProizvoda;
    /**
     * Constructor method for Kategorija
     * @uses Kategorija::setSifra()
     * @uses Kategorija::setNaziv()
     * @uses Kategorija::setNadKategorija()
     * @uses Kategorija::setListaSifriProizvoda()
     * @param string $sifra
     * @param string $naziv
     * @param string $nadKategorija
     * @param \StructType\ListaSifri $listaSifriProizvoda
     */
    public function __construct($sifra = null, $naziv = null, $nadKategorija = null, \StructType\ListaSifri $listaSifriProizvoda = null)
    {
        $this
            ->setSifra($sifra)
            ->setNaziv($naziv)
            ->setNadKategorija($nadKategorija)
            ->setListaSifriProizvoda($listaSifriProizvoda);
    }
    /**
     * Get sifra value
     * @return string|null
     */
    public function getSifra()
    {
        return $this->sifra;
    }
    /**
     * Set sifra value
     * @param string $sifra
     * @return \StructType\Kategorija
     */
    public function setSifra($sifra = null)
    {
        // validation for constraint: string
        if (!is_null($sifra) && !is_string($sifra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifra, true), gettype($sifra)), __LINE__);
        }
        $this->sifra = $sifra;
        return $this;
    }
    /**
     * Get naziv value
     * @return string|null
     */
    public function getNaziv()
    {
        return $this->naziv;
    }
    /**
     * Set naziv value
     * @param string $naziv
     * @return \StructType\Kategorija
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        $this->naziv = $naziv;
        return $this;
    }
    /**
     * Get nadKategorija value
     * @return string|null
     */
    public function getNadKategorija()
    {
        return $this->nadKategorija;
    }
    /**
     * Set nadKategorija value
     * @param string $nadKategorija
     * @return \StructType\Kategorija
     */
    public function setNadKategorija($nadKategorija = null)
    {
        // validation for constraint: string
        if (!is_null($nadKategorija) && !is_string($nadKategorija)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nadKategorija, true), gettype($nadKategorija)), __LINE__);
        }
        $this->nadKategorija = $nadKategorija;
        return $this;
    }
    /**
     * Get listaSifriProizvoda value
     * @return \StructType\ListaSifri|null
     */
    public function getListaSifriProizvoda()
    {
        return $this->listaSifriProizvoda;
    }
    /**
     * Set listaSifriProizvoda value
     * @param \StructType\ListaSifri $listaSifriProizvoda
     * @return \StructType\Kategorija
     */
    public function setListaSifriProizvoda(\StructType\ListaSifri $listaSifriProizvoda = null)
    {
        $this->listaSifriProizvoda = $listaSifriProizvoda;
        return $this;
    }
}
