<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AtributProizvoda StructType
 * @subpackage Structs
 */
class AtributProizvoda extends AbstractStructBase
{
    /**
     * The sifra
     * @var string
     */
    public $sifra;
    /**
     * The vrijednost
     * @var string
     */
    public $vrijednost;
    /**
     * The tip
     * @var string
     */
    public $tip;
    /**
     * Constructor method for AtributProizvoda
     * @uses AtributProizvoda::setSifra()
     * @uses AtributProizvoda::setVrijednost()
     * @uses AtributProizvoda::setTip()
     * @param string $sifra
     * @param string $vrijednost
     * @param string $tip
     */
    public function __construct($sifra = null, $vrijednost = null, $tip = null)
    {
        $this
            ->setSifra($sifra)
            ->setVrijednost($vrijednost)
            ->setTip($tip);
    }
    /**
     * Get sifra value
     * @return string|null
     */
    public function getSifra()
    {
        return $this->sifra;
    }
    /**
     * Set sifra value
     * @param string $sifra
     * @return \StructType\AtributProizvoda
     */
    public function setSifra($sifra = null)
    {
        // validation for constraint: string
        if (!is_null($sifra) && !is_string($sifra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifra, true), gettype($sifra)), __LINE__);
        }
        $this->sifra = $sifra;
        return $this;
    }
    /**
     * Get vrijednost value
     * @return string|null
     */
    public function getVrijednost()
    {
        return $this->vrijednost;
    }
    /**
     * Set vrijednost value
     * @param string $vrijednost
     * @return \StructType\AtributProizvoda
     */
    public function setVrijednost($vrijednost = null)
    {
        // validation for constraint: string
        if (!is_null($vrijednost) && !is_string($vrijednost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vrijednost, true), gettype($vrijednost)), __LINE__);
        }
        $this->vrijednost = $vrijednost;
        return $this;
    }
    /**
     * Get tip value
     * @return string|null
     */
    public function getTip()
    {
        return $this->tip;
    }
    /**
     * Set tip value
     * @param string $tip
     * @return \StructType\AtributProizvoda
     */
    public function setTip($tip = null)
    {
        // validation for constraint: string
        if (!is_null($tip) && !is_string($tip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tip, true), gettype($tip)), __LINE__);
        }
        $this->tip = $tip;
        return $this;
    }
}
