<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Storno ServiceType
 * @subpackage Services
 */
class Storno extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named stornoNaloga
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\StornoNaloga $parameters
     * @return \StructType\StornoNalogaResponse|bool
     */
    public function stornoNaloga(\StructType\StornoNaloga $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->stornoNaloga($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\StornoNalogaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
