<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Spremi ServiceType
 * @subpackage Services
 */
class Spremi extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named spremiLopClana
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SpremiLopClana $parameters
     * @return \StructType\SpremiLopClanaResponse|bool
     */
    public function spremiLopClana(\StructType\SpremiLopClana $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->spremiLopClana($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SpremiLopClanaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
