<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for zupanija StructType
 * @subpackage Structs
 */
class Zupanija extends AbstractStructBase
{
    /**
     * The nazivZupanije
     * @var string
     */
    public $nazivZupanije;
    /**
     * The ListaGradova
     * @var \StructType\ListaGradova
     */
    public $ListaGradova;
    /**
     * Constructor method for zupanija
     * @uses Zupanija::setNazivZupanije()
     * @uses Zupanija::setListaGradova()
     * @param string $nazivZupanije
     * @param \StructType\ListaGradova $listaGradova
     */
    public function __construct($nazivZupanije = null, \StructType\ListaGradova $listaGradova = null)
    {
        $this
            ->setNazivZupanije($nazivZupanije)
            ->setListaGradova($listaGradova);
    }
    /**
     * Get nazivZupanije value
     * @return string|null
     */
    public function getNazivZupanije()
    {
        return $this->nazivZupanije;
    }
    /**
     * Set nazivZupanije value
     * @param string $nazivZupanije
     * @return \StructType\Zupanija
     */
    public function setNazivZupanije($nazivZupanije = null)
    {
        // validation for constraint: string
        if (!is_null($nazivZupanije) && !is_string($nazivZupanije)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazivZupanije, true), gettype($nazivZupanije)), __LINE__);
        }
        $this->nazivZupanije = $nazivZupanije;
        return $this;
    }
    /**
     * Get ListaGradova value
     * @return \StructType\ListaGradova|null
     */
    public function getListaGradova()
    {
        return $this->ListaGradova;
    }
    /**
     * Set ListaGradova value
     * @param \StructType\ListaGradova $listaGradova
     * @return \StructType\Zupanija
     */
    public function setListaGradova(\StructType\ListaGradova $listaGradova = null)
    {
        $this->ListaGradova = $listaGradova;
        return $this;
    }
}
