<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpremiLopClanaRequest StructType
 * @subpackage Structs
 */
class SpremiLopClanaRequest extends AbstractStructBase
{
    /**
     * The vlasnik
     * @var string
     */
    public $vlasnik;
    /**
     * The lopClan
     * @var string
     */
    public $lopClan;
    /**
     * The ime
     * @var string
     */
    public $ime;
    /**
     * The prezime
     * @var string
     */
    public $prezime;
    /**
     * The adresa
     * @var string
     */
    public $adresa;
    /**
     * The telefon
     * @var string
     */
    public $telefon;
    /**
     * The sifraPartnera
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sifraPartnera;
    /**
     * The prezIme
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $prezIme;
    /**
     * The vrstaLopClana
     * @var string
     */
    public $vrstaLopClana;
    /**
     * The mjesto
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $mjesto;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The radnik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $radnik;
    /**
     * The kontrolniBroj
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $kontrolniBroj;
    /**
     * Constructor method for SpremiLopClanaRequest
     * @uses SpremiLopClanaRequest::setVlasnik()
     * @uses SpremiLopClanaRequest::setLopClan()
     * @uses SpremiLopClanaRequest::setIme()
     * @uses SpremiLopClanaRequest::setPrezime()
     * @uses SpremiLopClanaRequest::setAdresa()
     * @uses SpremiLopClanaRequest::setTelefon()
     * @uses SpremiLopClanaRequest::setSifraPartnera()
     * @uses SpremiLopClanaRequest::setPrezIme_1()
     * @uses SpremiLopClanaRequest::setVrstaLopClana()
     * @uses SpremiLopClanaRequest::setMjesto()
     * @uses SpremiLopClanaRequest::setEmail()
     * @uses SpremiLopClanaRequest::setRadnik()
     * @uses SpremiLopClanaRequest::setKontrolniBroj()
     * @param string $vlasnik
     * @param string $lopClan
     * @param string $ime
     * @param string $prezime
     * @param string $adresa
     * @param string $telefon
     * @param string $sifraPartnera
     * @param string $prezIme
     * @param string $vrstaLopClana
     * @param int $mjesto
     * @param string $email
     * @param string $radnik
     * @param string $kontrolniBroj
     */
    public function __construct($vlasnik = null, $lopClan = null, $ime = null, $prezime = null, $adresa = null, $telefon = null, $sifraPartnera = null, $prezIme_1 = null, $vrstaLopClana = null, $mjesto = null, $email = null, $radnik = null, $kontrolniBroj = null)
    {
        $this
            ->setVlasnik($vlasnik)
            ->setLopClan($lopClan)
            ->setIme($ime)
            ->setPrezime($prezime)
            ->setAdresa($adresa)
            ->setTelefon($telefon)
            ->setSifraPartnera($sifraPartnera)
            ->setPrezIme_1($prezIme_1)
            ->setVrstaLopClana($vrstaLopClana)
            ->setMjesto($mjesto)
            ->setEmail($email)
            ->setRadnik($radnik)
            ->setKontrolniBroj($kontrolniBroj);
    }
    /**
     * Get vlasnik value
     * @return string|null
     */
    public function getVlasnik()
    {
        return $this->vlasnik;
    }
    /**
     * Set vlasnik value
     * @param string $vlasnik
     * @return \StructType\SpremiLopClanaRequest
     */
    public function setVlasnik($vlasnik = null)
    {
        // validation for constraint: string
        if (!is_null($vlasnik) && !is_string($vlasnik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vlasnik, true), gettype($vlasnik)), __LINE__);
        }
        $this->vlasnik = $vlasnik;
        return $this;
    }
    /**
     * Get lopClan value
     * @return string|null
     */
    public function getLopClan()
    {
        return $this->lopClan;
    }
    /**
     * Set lopClan value
     * @param string $lopClan
     * @return \StructType\SpremiLopClanaRequest
     */
    public function setLopClan($lopClan = null)
    {
        // validation for constraint: string
        if (!is_null($lopClan) && !is_string($lopClan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lopClan, true), gettype($lopClan)), __LINE__);
        }
        $this->lopClan = $lopClan;
        return $this;
    }
    /**
     * Get ime value
     * @return string|null
     */
    public function getIme()
    {
        return $this->ime;
    }
    /**
     * Set ime value
     * @param string $ime
     * @return \StructType\SpremiLopClanaRequest
     */
    public function setIme($ime = null)
    {
        // validation for constraint: string
        if (!is_null($ime) && !is_string($ime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ime, true), gettype($ime)), __LINE__);
        }
        $this->ime = $ime;
        return $this;
    }
    /**
     * Get prezime value
     * @return string|null
     */
    public function getPrezime()
    {
        return $this->prezime;
    }
    /**
     * Set prezime value
     * @param string $prezime
     * @return \StructType\SpremiLopClanaRequest
     */
    public function setPrezime($prezime = null)
    {
        // validation for constraint: string
        if (!is_null($prezime) && !is_string($prezime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prezime, true), gettype($prezime)), __LINE__);
        }
        $this->prezime = $prezime;
        return $this;
    }
    /**
     * Get adresa value
     * @return string|null
     */
    public function getAdresa()
    {
        return $this->adresa;
    }
    /**
     * Set adresa value
     * @param string $adresa
     * @return \StructType\SpremiLopClanaRequest
     */
    public function setAdresa($adresa = null)
    {
        // validation for constraint: string
        if (!is_null($adresa) && !is_string($adresa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresa, true), gettype($adresa)), __LINE__);
        }
        $this->adresa = $adresa;
        return $this;
    }
    /**
     * Get telefon value
     * @return string|null
     */
    public function getTelefon()
    {
        return $this->telefon;
    }
    /**
     * Set telefon value
     * @param string $telefon
     * @return \StructType\SpremiLopClanaRequest
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: string
        if (!is_null($telefon) && !is_string($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefon, true), gettype($telefon)), __LINE__);
        }
        $this->telefon = $telefon;
        return $this;
    }
    /**
     * Get sifraPartnera value
     * @return string|null
     */
    public function getSifraPartnera()
    {
        return $this->sifraPartnera;
    }
    /**
     * Set sifraPartnera value
     * @param string $sifraPartnera
     * @return \StructType\SpremiLopClanaRequest
     */
    public function setSifraPartnera($sifraPartnera = null)
    {
        // validation for constraint: string
        if (!is_null($sifraPartnera) && !is_string($sifraPartnera)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifraPartnera, true), gettype($sifraPartnera)), __LINE__);
        }
        $this->sifraPartnera = $sifraPartnera;
        return $this;
    }
    /**
     * Get prezIme value
     * @return string|null
     */
    public function getPrezIme_1()
    {
        return $this->prezIme;
    }
    /**
     * Set prezIme value
     * @param string $prezIme
     * @return \StructType\SpremiLopClanaRequest
     */
    public function setPrezIme_1($prezIme_1 = null)
    {
        // validation for constraint: string
        if (!is_null($prezIme_1) && !is_string($prezIme_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prezIme_1, true), gettype($prezIme_1)), __LINE__);
        }
        $this->prezIme = $prezIme_1;
        return $this;
    }
    /**
     * Get vrstaLopClana value
     * @return string|null
     */
    public function getVrstaLopClana()
    {
        return $this->vrstaLopClana;
    }
    /**
     * Set vrstaLopClana value
     * @param string $vrstaLopClana
     * @return \StructType\SpremiLopClanaRequest
     */
    public function setVrstaLopClana($vrstaLopClana = null)
    {
        // validation for constraint: string
        if (!is_null($vrstaLopClana) && !is_string($vrstaLopClana)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vrstaLopClana, true), gettype($vrstaLopClana)), __LINE__);
        }
        $this->vrstaLopClana = $vrstaLopClana;
        return $this;
    }
    /**
     * Get mjesto value
     * @return int|null
     */
    public function getMjesto()
    {
        return $this->mjesto;
    }
    /**
     * Set mjesto value
     * @param int $mjesto
     * @return \StructType\SpremiLopClanaRequest
     */
    public function setMjesto($mjesto = null)
    {
        // validation for constraint: int
        if (!is_null($mjesto) && !(is_int($mjesto) || ctype_digit($mjesto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mjesto, true), gettype($mjesto)), __LINE__);
        }
        $this->mjesto = $mjesto;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\SpremiLopClanaRequest
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get radnik value
     * @return string|null
     */
    public function getRadnik()
    {
        return $this->radnik;
    }
    /**
     * Set radnik value
     * @param string $radnik
     * @return \StructType\SpremiLopClanaRequest
     */
    public function setRadnik($radnik = null)
    {
        // validation for constraint: string
        if (!is_null($radnik) && !is_string($radnik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($radnik, true), gettype($radnik)), __LINE__);
        }
        $this->radnik = $radnik;
        return $this;
    }
    /**
     * Get kontrolniBroj value
     * @return string|null
     */
    public function getKontrolniBroj()
    {
        return $this->kontrolniBroj;
    }
    /**
     * Set kontrolniBroj value
     * @param string $kontrolniBroj
     * @return \StructType\SpremiLopClanaRequest
     */
    public function setKontrolniBroj($kontrolniBroj = null)
    {
        // validation for constraint: string
        if (!is_null($kontrolniBroj) && !is_string($kontrolniBroj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kontrolniBroj, true), gettype($kontrolniBroj)), __LINE__);
        }
        $this->kontrolniBroj = $kontrolniBroj;
        return $this;
    }
}
