<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for slikaProizvoda StructType
 * @subpackage Structs
 */
class SlikaProizvoda extends AbstractStructBase
{
    /**
     * The sifraProizvoda
     * @var string
     */
    public $sifraProizvoda;
    /**
     * The slika
     * @var string
     */
    public $slika;
    /**
     * Constructor method for slikaProizvoda
     * @uses SlikaProizvoda::setSifraProizvoda()
     * @uses SlikaProizvoda::setSlika()
     * @param string $sifraProizvoda
     * @param string $slika
     */
    public function __construct($sifraProizvoda = null, $slika = null)
    {
        $this
            ->setSifraProizvoda($sifraProizvoda)
            ->setSlika($slika);
    }
    /**
     * Get sifraProizvoda value
     * @return string|null
     */
    public function getSifraProizvoda()
    {
        return $this->sifraProizvoda;
    }
    /**
     * Set sifraProizvoda value
     * @param string $sifraProizvoda
     * @return \StructType\SlikaProizvoda
     */
    public function setSifraProizvoda($sifraProizvoda = null)
    {
        // validation for constraint: string
        if (!is_null($sifraProizvoda) && !is_string($sifraProizvoda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifraProizvoda, true), gettype($sifraProizvoda)), __LINE__);
        }
        $this->sifraProizvoda = $sifraProizvoda;
        return $this;
    }
    /**
     * Get slika value
     * @return string|null
     */
    public function getSlika()
    {
        return $this->slika;
    }
    /**
     * Set slika value
     * @param string $slika
     * @return \StructType\SlikaProizvoda
     */
    public function setSlika($slika = null)
    {
        // validation for constraint: string
        if (!is_null($slika) && !is_string($slika)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($slika, true), gettype($slika)), __LINE__);
        }
        $this->slika = $slika;
        return $this;
    }
}
