<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RekalkulirajNarudzbu StructType
 * @subpackage Structs
 */
class RekalkulirajNarudzbu extends AbstractStructBase
{
    /**
     * The vlasnik
     * @var string
     */
    public $vlasnik;
    /**
     * The sifraPartnera
     * @var string
     */
    public $sifraPartnera;
    /**
     * The sifraIzvora
     * @var int
     */
    public $sifraIzvora;
    /**
     * The tipListe
     * @var string
     */
    public $tipListe;
    /**
     * The dostavnoMjesto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dostavnoMjesto;
    /**
     * The listaProizvodaZaRekalkulaciju
     * @var \StructType\ListaZaRekalkulaciju
     */
    public $listaProizvodaZaRekalkulaciju;
    /**
     * Constructor method for RekalkulirajNarudzbu
     * @uses RekalkulirajNarudzbu::setVlasnik()
     * @uses RekalkulirajNarudzbu::setSifraPartnera()
     * @uses RekalkulirajNarudzbu::setSifraIzvora()
     * @uses RekalkulirajNarudzbu::setTipListe()
     * @uses RekalkulirajNarudzbu::setDostavnoMjesto()
     * @uses RekalkulirajNarudzbu::setListaProizvodaZaRekalkulaciju()
     * @param string $vlasnik
     * @param string $sifraPartnera
     * @param int $sifraIzvora
     * @param string $tipListe
     * @param string $dostavnoMjesto
     * @param \StructType\ListaZaRekalkulaciju $listaProizvodaZaRekalkulaciju
     */
    public function __construct($vlasnik = null, $sifraPartnera = null, $sifraIzvora = null, $tipListe = null, $dostavnoMjesto = null, \StructType\ListaZaRekalkulaciju $listaProizvodaZaRekalkulaciju = null)
    {
        $this
            ->setVlasnik($vlasnik)
            ->setSifraPartnera($sifraPartnera)
            ->setSifraIzvora($sifraIzvora)
            ->setTipListe($tipListe)
            ->setDostavnoMjesto($dostavnoMjesto)
            ->setListaProizvodaZaRekalkulaciju($listaProizvodaZaRekalkulaciju);
    }
    /**
     * Get vlasnik value
     * @return string|null
     */
    public function getVlasnik()
    {
        return $this->vlasnik;
    }
    /**
     * Set vlasnik value
     * @param string $vlasnik
     * @return \StructType\RekalkulirajNarudzbu
     */
    public function setVlasnik($vlasnik = null)
    {
        // validation for constraint: string
        if (!is_null($vlasnik) && !is_string($vlasnik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vlasnik, true), gettype($vlasnik)), __LINE__);
        }
        $this->vlasnik = $vlasnik;
        return $this;
    }
    /**
     * Get sifraPartnera value
     * @return string|null
     */
    public function getSifraPartnera()
    {
        return $this->sifraPartnera;
    }
    /**
     * Set sifraPartnera value
     * @param string $sifraPartnera
     * @return \StructType\RekalkulirajNarudzbu
     */
    public function setSifraPartnera($sifraPartnera = null)
    {
        // validation for constraint: string
        if (!is_null($sifraPartnera) && !is_string($sifraPartnera)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifraPartnera, true), gettype($sifraPartnera)), __LINE__);
        }
        $this->sifraPartnera = $sifraPartnera;
        return $this;
    }
    /**
     * Get sifraIzvora value
     * @return int|null
     */
    public function getSifraIzvora()
    {
        return $this->sifraIzvora;
    }
    /**
     * Set sifraIzvora value
     * @param int $sifraIzvora
     * @return \StructType\RekalkulirajNarudzbu
     */
    public function setSifraIzvora($sifraIzvora = null)
    {
        // validation for constraint: int
        if (!is_null($sifraIzvora) && !(is_int($sifraIzvora) || ctype_digit($sifraIzvora))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sifraIzvora, true), gettype($sifraIzvora)), __LINE__);
        }
        $this->sifraIzvora = $sifraIzvora;
        return $this;
    }
    /**
     * Get tipListe value
     * @return string|null
     */
    public function getTipListe()
    {
        return $this->tipListe;
    }
    /**
     * Set tipListe value
     * @param string $tipListe
     * @return \StructType\RekalkulirajNarudzbu
     */
    public function setTipListe($tipListe = null)
    {
        // validation for constraint: string
        if (!is_null($tipListe) && !is_string($tipListe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipListe, true), gettype($tipListe)), __LINE__);
        }
        $this->tipListe = $tipListe;
        return $this;
    }
    /**
     * Get dostavnoMjesto value
     * @return string|null
     */
    public function getDostavnoMjesto()
    {
        return $this->dostavnoMjesto;
    }
    /**
     * Set dostavnoMjesto value
     * @param string $dostavnoMjesto
     * @return \StructType\RekalkulirajNarudzbu
     */
    public function setDostavnoMjesto($dostavnoMjesto = null)
    {
        // validation for constraint: string
        if (!is_null($dostavnoMjesto) && !is_string($dostavnoMjesto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dostavnoMjesto, true), gettype($dostavnoMjesto)), __LINE__);
        }
        $this->dostavnoMjesto = $dostavnoMjesto;
        return $this;
    }
    /**
     * Get listaProizvodaZaRekalkulaciju value
     * @return \StructType\ListaZaRekalkulaciju|null
     */
    public function getListaProizvodaZaRekalkulaciju()
    {
        return $this->listaProizvodaZaRekalkulaciju;
    }
    /**
     * Set listaProizvodaZaRekalkulaciju value
     * @param \StructType\ListaZaRekalkulaciju $listaProizvodaZaRekalkulaciju
     * @return \StructType\RekalkulirajNarudzbu
     */
    public function setListaProizvodaZaRekalkulaciju(\StructType\ListaZaRekalkulaciju $listaProizvodaZaRekalkulaciju = null)
    {
        $this->listaProizvodaZaRekalkulaciju = $listaProizvodaZaRekalkulaciju;
        return $this;
    }
}
