<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NoveCijene StructType
 * @subpackage Structs
 */
class NoveCijene extends AbstractStructBase
{
    /**
     * The noveCijene
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RekalkuliranaCijenaIKolicina[]
     */
    public $noveCijene;
    /**
     * The rezultatAkcije
     * @var int
     */
    public $rezultatAkcije;
    /**
     * Constructor method for NoveCijene
     * @uses NoveCijene::setNoveCijene()
     * @uses NoveCijene::setRezultatAkcije()
     * @param \StructType\RekalkuliranaCijenaIKolicina[] $noveCijene
     * @param int $rezultatAkcije
     */
    public function __construct(array $noveCijene = array(), $rezultatAkcije = null)
    {
        $this
            ->setNoveCijene($noveCijene)
            ->setRezultatAkcije($rezultatAkcije);
    }
    /**
     * Get noveCijene value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RekalkuliranaCijenaIKolicina[]|null
     */
    public function getNoveCijene()
    {
        return isset($this->noveCijene) ? $this->noveCijene : null;
    }
    /**
     * This method is responsible for validating the values passed to the setNoveCijene method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNoveCijene method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNoveCijeneForArrayConstraintsFromSetNoveCijene(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $noveCijeneNoveCijeneItem) {
            // validation for constraint: itemType
            if (!$noveCijeneNoveCijeneItem instanceof \StructType\RekalkuliranaCijenaIKolicina) {
                $invalidValues[] = is_object($noveCijeneNoveCijeneItem) ? get_class($noveCijeneNoveCijeneItem) : sprintf('%s(%s)', gettype($noveCijeneNoveCijeneItem), var_export($noveCijeneNoveCijeneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The noveCijene property can only contain items of type \StructType\RekalkuliranaCijenaIKolicina, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set noveCijene value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RekalkuliranaCijenaIKolicina[] $noveCijene
     * @return \StructType\NoveCijene
     */
    public function setNoveCijene(array $noveCijene = array())
    {
        // validation for constraint: array
        if ('' !== ($noveCijeneArrayErrorMessage = self::validateNoveCijeneForArrayConstraintsFromSetNoveCijene($noveCijene))) {
            throw new \InvalidArgumentException($noveCijeneArrayErrorMessage, __LINE__);
        }
        if (is_null($noveCijene) || (is_array($noveCijene) && empty($noveCijene))) {
            unset($this->noveCijene);
        } else {
            $this->noveCijene = $noveCijene;
        }
        return $this;
    }
    /**
     * Add item to noveCijene value
     * @throws \InvalidArgumentException
     * @param \StructType\RekalkuliranaCijenaIKolicina $item
     * @return \StructType\NoveCijene
     */
    public function addToNoveCijene(\StructType\RekalkuliranaCijenaIKolicina $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RekalkuliranaCijenaIKolicina) {
            throw new \InvalidArgumentException(sprintf('The noveCijene property can only contain items of type \StructType\RekalkuliranaCijenaIKolicina, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->noveCijene[] = $item;
        return $this;
    }
    /**
     * Get rezultatAkcije value
     * @return int|null
     */
    public function getRezultatAkcije()
    {
        return $this->rezultatAkcije;
    }
    /**
     * Set rezultatAkcije value
     * @param int $rezultatAkcije
     * @return \StructType\NoveCijene
     */
    public function setRezultatAkcije($rezultatAkcije = null)
    {
        // validation for constraint: int
        if (!is_null($rezultatAkcije) && !(is_int($rezultatAkcije) || ctype_digit($rezultatAkcije))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rezultatAkcije, true), gettype($rezultatAkcije)), __LINE__);
        }
        $this->rezultatAkcije = $rezultatAkcije;
        return $this;
    }
}
