<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NalogZaglavlje StructType
 * @subpackage Structs
 */
class NalogZaglavlje extends AbstractStructBase
{
    /**
     * The vanjskiIdentifikator
     * @var string
     */
    public $vanjskiIdentifikator;
    /**
     * The OIB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OIB;
    /**
     * The imeKupcaNaplata
     * @var string
     */
    public $imeKupcaNaplata;
    /**
     * The adresaNaplata
     * @var string
     */
    public $adresaNaplata;
    /**
     * The telefonNaplata
     * @var string
     */
    public $telefonNaplata;
    /**
     * The imeFirmeNaplata
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $imeFirmeNaplata;
    /**
     * The imeKupcaDostava
     * @var string
     */
    public $imeKupcaDostava;
    /**
     * The adresaDostava
     * @var string
     */
    public $adresaDostava;
    /**
     * The telefonDostava
     * @var string
     */
    public $telefonDostava;
    /**
     * The imeFirmeDostava
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $imeFirmeDostava;
    /**
     * The OIBR1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OIBR1;
    /**
     * The imeR1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $imeR1;
    /**
     * The adresaR1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $adresaR1;
    /**
     * The ukupniIznos
     * @var float
     */
    public $ukupniIznos;
    /**
     * The nacinPlacanja
     * @var string
     */
    public $nacinPlacanja;
    /**
     * The sifraPoslovnice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sifraPoslovnice;
    /**
     * The sifraPartnera
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sifraPartnera;
    /**
     * The dostavoMjesto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dostavoMjesto;
    /**
     * The sifraIzvora
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sifraIzvora;
    /**
     * The tipListe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipListe;
    /**
     * The tipKanalaProdaje
     * @var string
     */
    public $tipKanalaProdaje;
    /**
     * The kanalProdaje
     * @var string
     */
    public $kanalProdaje;
    /**
     * The vlasnik
     * @var string
     */
    public $vlasnik;
    /**
     * The brojOdobrenja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $brojOdobrenja;
    /**
     * The brojRata
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $brojRata;
    /**
     * The tipNaloga
     * @var string
     */
    public $tipNaloga;
    /**
     * The napomena
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $napomena;
    /**
     * The lopClan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lopClan;
    /**
     * The kolekcijaStavke
     * @var \ArrayType\ArrayOfNalogStavke
     */
    public $kolekcijaStavke;
    /**
     * The kolekcijaNaciniPlacanja
     * @var \ArrayType\ArrayOfNaciniPlacanja
     */
    public $kolekcijaNaciniPlacanja;
    /**
     * The kolekcijaDodatniPodaci
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDodatniPodaci
     */
    public $kolekcijaDodatniPodaci;
    /**
     * Constructor method for NalogZaglavlje
     * @uses NalogZaglavlje::setVanjskiIdentifikator()
     * @uses NalogZaglavlje::setOIB()
     * @uses NalogZaglavlje::setImeKupcaNaplata()
     * @uses NalogZaglavlje::setAdresaNaplata()
     * @uses NalogZaglavlje::setTelefonNaplata()
     * @uses NalogZaglavlje::setImeFirmeNaplata()
     * @uses NalogZaglavlje::setImeKupcaDostava()
     * @uses NalogZaglavlje::setAdresaDostava()
     * @uses NalogZaglavlje::setTelefonDostava()
     * @uses NalogZaglavlje::setImeFirmeDostava()
     * @uses NalogZaglavlje::setOIBR1()
     * @uses NalogZaglavlje::setImeR1()
     * @uses NalogZaglavlje::setAdresaR1()
     * @uses NalogZaglavlje::setUkupniIznos()
     * @uses NalogZaglavlje::setNacinPlacanja()
     * @uses NalogZaglavlje::setSifraPoslovnice()
     * @uses NalogZaglavlje::setSifraPartnera()
     * @uses NalogZaglavlje::setDostavoMjesto()
     * @uses NalogZaglavlje::setSifraIzvora()
     * @uses NalogZaglavlje::setTipListe()
     * @uses NalogZaglavlje::setTipKanalaProdaje()
     * @uses NalogZaglavlje::setKanalProdaje()
     * @uses NalogZaglavlje::setVlasnik()
     * @uses NalogZaglavlje::setBrojOdobrenja()
     * @uses NalogZaglavlje::setBrojRata()
     * @uses NalogZaglavlje::setTipNaloga()
     * @uses NalogZaglavlje::setNapomena()
     * @uses NalogZaglavlje::setLopClan()
     * @uses NalogZaglavlje::setKolekcijaStavke()
     * @uses NalogZaglavlje::setKolekcijaNaciniPlacanja()
     * @uses NalogZaglavlje::setKolekcijaDodatniPodaci()
     * @param string $vanjskiIdentifikator
     * @param string $oIB
     * @param string $imeKupcaNaplata
     * @param string $adresaNaplata
     * @param string $telefonNaplata
     * @param string $imeFirmeNaplata
     * @param string $imeKupcaDostava
     * @param string $adresaDostava
     * @param string $telefonDostava
     * @param string $imeFirmeDostava
     * @param string $oIBR1
     * @param string $imeR1
     * @param string $adresaR1
     * @param float $ukupniIznos
     * @param string $nacinPlacanja
     * @param string $sifraPoslovnice
     * @param string $sifraPartnera
     * @param string $dostavoMjesto
     * @param int $sifraIzvora
     * @param string $tipListe
     * @param string $tipKanalaProdaje
     * @param string $kanalProdaje
     * @param string $vlasnik
     * @param string $brojOdobrenja
     * @param int $brojRata
     * @param string $tipNaloga
     * @param string $napomena
     * @param string $lopClan
     * @param \ArrayType\ArrayOfNalogStavke $kolekcijaStavke
     * @param \ArrayType\ArrayOfNaciniPlacanja $kolekcijaNaciniPlacanja
     * @param \ArrayType\ArrayOfDodatniPodaci $kolekcijaDodatniPodaci
     */
    public function __construct($vanjskiIdentifikator = null, $oIB = null, $imeKupcaNaplata = null, $adresaNaplata = null, $telefonNaplata = null, $imeFirmeNaplata = null, $imeKupcaDostava = null, $adresaDostava = null, $telefonDostava = null, $imeFirmeDostava = null, $oIBR1 = null, $imeR1 = null, $adresaR1 = null, $ukupniIznos = null, $nacinPlacanja = null, $sifraPoslovnice = null, $sifraPartnera = null, $dostavoMjesto = null, $sifraIzvora = null, $tipListe = null, $tipKanalaProdaje = null, $kanalProdaje = null, $vlasnik = null, $brojOdobrenja = null, $brojRata = null, $tipNaloga = null, $napomena = null, $lopClan = null, \ArrayType\ArrayOfNalogStavke $kolekcijaStavke = null, \ArrayType\ArrayOfNaciniPlacanja $kolekcijaNaciniPlacanja = null, \ArrayType\ArrayOfDodatniPodaci $kolekcijaDodatniPodaci = null)
    {
        $this
            ->setVanjskiIdentifikator($vanjskiIdentifikator)
            ->setOIB($oIB)
            ->setImeKupcaNaplata($imeKupcaNaplata)
            ->setAdresaNaplata($adresaNaplata)
            ->setTelefonNaplata($telefonNaplata)
            ->setImeFirmeNaplata($imeFirmeNaplata)
            ->setImeKupcaDostava($imeKupcaDostava)
            ->setAdresaDostava($adresaDostava)
            ->setTelefonDostava($telefonDostava)
            ->setImeFirmeDostava($imeFirmeDostava)
            ->setOIBR1($oIBR1)
            ->setImeR1($imeR1)
            ->setAdresaR1($adresaR1)
            ->setUkupniIznos($ukupniIznos)
            ->setNacinPlacanja($nacinPlacanja)
            ->setSifraPoslovnice($sifraPoslovnice)
            ->setSifraPartnera($sifraPartnera)
            ->setDostavoMjesto($dostavoMjesto)
            ->setSifraIzvora($sifraIzvora)
            ->setTipListe($tipListe)
            ->setTipKanalaProdaje($tipKanalaProdaje)
            ->setKanalProdaje($kanalProdaje)
            ->setVlasnik($vlasnik)
            ->setBrojOdobrenja($brojOdobrenja)
            ->setBrojRata($brojRata)
            ->setTipNaloga($tipNaloga)
            ->setNapomena($napomena)
            ->setLopClan($lopClan)
            ->setKolekcijaStavke($kolekcijaStavke)
            ->setKolekcijaNaciniPlacanja($kolekcijaNaciniPlacanja)
            ->setKolekcijaDodatniPodaci($kolekcijaDodatniPodaci);
    }
    /**
     * Get vanjskiIdentifikator value
     * @return string|null
     */
    public function getVanjskiIdentifikator()
    {
        return $this->vanjskiIdentifikator;
    }
    /**
     * Set vanjskiIdentifikator value
     * @param string $vanjskiIdentifikator
     * @return \StructType\NalogZaglavlje
     */
    public function setVanjskiIdentifikator($vanjskiIdentifikator = null)
    {
        // validation for constraint: string
        if (!is_null($vanjskiIdentifikator) && !is_string($vanjskiIdentifikator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vanjskiIdentifikator, true), gettype($vanjskiIdentifikator)), __LINE__);
        }
        $this->vanjskiIdentifikator = $vanjskiIdentifikator;
        return $this;
    }
    /**
     * Get OIB value
     * @return string|null
     */
    public function getOIB()
    {
        return $this->OIB;
    }
    /**
     * Set OIB value
     * @param string $oIB
     * @return \StructType\NalogZaglavlje
     */
    public function setOIB($oIB = null)
    {
        // validation for constraint: string
        if (!is_null($oIB) && !is_string($oIB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oIB, true), gettype($oIB)), __LINE__);
        }
        $this->OIB = $oIB;
        return $this;
    }
    /**
     * Get imeKupcaNaplata value
     * @return string|null
     */
    public function getImeKupcaNaplata()
    {
        return $this->imeKupcaNaplata;
    }
    /**
     * Set imeKupcaNaplata value
     * @param string $imeKupcaNaplata
     * @return \StructType\NalogZaglavlje
     */
    public function setImeKupcaNaplata($imeKupcaNaplata = null)
    {
        // validation for constraint: string
        if (!is_null($imeKupcaNaplata) && !is_string($imeKupcaNaplata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imeKupcaNaplata, true), gettype($imeKupcaNaplata)), __LINE__);
        }
        $this->imeKupcaNaplata = $imeKupcaNaplata;
        return $this;
    }
    /**
     * Get adresaNaplata value
     * @return string|null
     */
    public function getAdresaNaplata()
    {
        return $this->adresaNaplata;
    }
    /**
     * Set adresaNaplata value
     * @param string $adresaNaplata
     * @return \StructType\NalogZaglavlje
     */
    public function setAdresaNaplata($adresaNaplata = null)
    {
        // validation for constraint: string
        if (!is_null($adresaNaplata) && !is_string($adresaNaplata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresaNaplata, true), gettype($adresaNaplata)), __LINE__);
        }
        $this->adresaNaplata = $adresaNaplata;
        return $this;
    }
    /**
     * Get telefonNaplata value
     * @return string|null
     */
    public function getTelefonNaplata()
    {
        return $this->telefonNaplata;
    }
    /**
     * Set telefonNaplata value
     * @param string $telefonNaplata
     * @return \StructType\NalogZaglavlje
     */
    public function setTelefonNaplata($telefonNaplata = null)
    {
        // validation for constraint: string
        if (!is_null($telefonNaplata) && !is_string($telefonNaplata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefonNaplata, true), gettype($telefonNaplata)), __LINE__);
        }
        $this->telefonNaplata = $telefonNaplata;
        return $this;
    }
    /**
     * Get imeFirmeNaplata value
     * @return string|null
     */
    public function getImeFirmeNaplata()
    {
        return $this->imeFirmeNaplata;
    }
    /**
     * Set imeFirmeNaplata value
     * @param string $imeFirmeNaplata
     * @return \StructType\NalogZaglavlje
     */
    public function setImeFirmeNaplata($imeFirmeNaplata = null)
    {
        // validation for constraint: string
        if (!is_null($imeFirmeNaplata) && !is_string($imeFirmeNaplata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imeFirmeNaplata, true), gettype($imeFirmeNaplata)), __LINE__);
        }
        $this->imeFirmeNaplata = $imeFirmeNaplata;
        return $this;
    }
    /**
     * Get imeKupcaDostava value
     * @return string|null
     */
    public function getImeKupcaDostava()
    {
        return $this->imeKupcaDostava;
    }
    /**
     * Set imeKupcaDostava value
     * @param string $imeKupcaDostava
     * @return \StructType\NalogZaglavlje
     */
    public function setImeKupcaDostava($imeKupcaDostava = null)
    {
        // validation for constraint: string
        if (!is_null($imeKupcaDostava) && !is_string($imeKupcaDostava)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imeKupcaDostava, true), gettype($imeKupcaDostava)), __LINE__);
        }
        $this->imeKupcaDostava = $imeKupcaDostava;
        return $this;
    }
    /**
     * Get adresaDostava value
     * @return string|null
     */
    public function getAdresaDostava()
    {
        return $this->adresaDostava;
    }
    /**
     * Set adresaDostava value
     * @param string $adresaDostava
     * @return \StructType\NalogZaglavlje
     */
    public function setAdresaDostava($adresaDostava = null)
    {
        // validation for constraint: string
        if (!is_null($adresaDostava) && !is_string($adresaDostava)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresaDostava, true), gettype($adresaDostava)), __LINE__);
        }
        $this->adresaDostava = $adresaDostava;
        return $this;
    }
    /**
     * Get telefonDostava value
     * @return string|null
     */
    public function getTelefonDostava()
    {
        return $this->telefonDostava;
    }
    /**
     * Set telefonDostava value
     * @param string $telefonDostava
     * @return \StructType\NalogZaglavlje
     */
    public function setTelefonDostava($telefonDostava = null)
    {
        // validation for constraint: string
        if (!is_null($telefonDostava) && !is_string($telefonDostava)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefonDostava, true), gettype($telefonDostava)), __LINE__);
        }
        $this->telefonDostava = $telefonDostava;
        return $this;
    }
    /**
     * Get imeFirmeDostava value
     * @return string|null
     */
    public function getImeFirmeDostava()
    {
        return $this->imeFirmeDostava;
    }
    /**
     * Set imeFirmeDostava value
     * @param string $imeFirmeDostava
     * @return \StructType\NalogZaglavlje
     */
    public function setImeFirmeDostava($imeFirmeDostava = null)
    {
        // validation for constraint: string
        if (!is_null($imeFirmeDostava) && !is_string($imeFirmeDostava)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imeFirmeDostava, true), gettype($imeFirmeDostava)), __LINE__);
        }
        $this->imeFirmeDostava = $imeFirmeDostava;
        return $this;
    }
    /**
     * Get OIBR1 value
     * @return string|null
     */
    public function getOIBR1()
    {
        return $this->OIBR1;
    }
    /**
     * Set OIBR1 value
     * @param string $oIBR1
     * @return \StructType\NalogZaglavlje
     */
    public function setOIBR1($oIBR1 = null)
    {
        // validation for constraint: string
        if (!is_null($oIBR1) && !is_string($oIBR1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oIBR1, true), gettype($oIBR1)), __LINE__);
        }
        $this->OIBR1 = $oIBR1;
        return $this;
    }
    /**
     * Get imeR1 value
     * @return string|null
     */
    public function getImeR1()
    {
        return $this->imeR1;
    }
    /**
     * Set imeR1 value
     * @param string $imeR1
     * @return \StructType\NalogZaglavlje
     */
    public function setImeR1($imeR1 = null)
    {
        // validation for constraint: string
        if (!is_null($imeR1) && !is_string($imeR1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imeR1, true), gettype($imeR1)), __LINE__);
        }
        $this->imeR1 = $imeR1;
        return $this;
    }
    /**
     * Get adresaR1 value
     * @return string|null
     */
    public function getAdresaR1()
    {
        return $this->adresaR1;
    }
    /**
     * Set adresaR1 value
     * @param string $adresaR1
     * @return \StructType\NalogZaglavlje
     */
    public function setAdresaR1($adresaR1 = null)
    {
        // validation for constraint: string
        if (!is_null($adresaR1) && !is_string($adresaR1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresaR1, true), gettype($adresaR1)), __LINE__);
        }
        $this->adresaR1 = $adresaR1;
        return $this;
    }
    /**
     * Get ukupniIznos value
     * @return float|null
     */
    public function getUkupniIznos()
    {
        return $this->ukupniIznos;
    }
    /**
     * Set ukupniIznos value
     * @param float $ukupniIznos
     * @return \StructType\NalogZaglavlje
     */
    public function setUkupniIznos($ukupniIznos = null)
    {
        // validation for constraint: float
        if (!is_null($ukupniIznos) && !(is_float($ukupniIznos) || is_numeric($ukupniIznos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ukupniIznos, true), gettype($ukupniIznos)), __LINE__);
        }
        $this->ukupniIznos = $ukupniIznos;
        return $this;
    }
    /**
     * Get nacinPlacanja value
     * @return string|null
     */
    public function getNacinPlacanja()
    {
        return $this->nacinPlacanja;
    }
    /**
     * Set nacinPlacanja value
     * @param string $nacinPlacanja
     * @return \StructType\NalogZaglavlje
     */
    public function setNacinPlacanja($nacinPlacanja = null)
    {
        // validation for constraint: string
        if (!is_null($nacinPlacanja) && !is_string($nacinPlacanja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nacinPlacanja, true), gettype($nacinPlacanja)), __LINE__);
        }
        $this->nacinPlacanja = $nacinPlacanja;
        return $this;
    }
    /**
     * Get sifraPoslovnice value
     * @return string|null
     */
    public function getSifraPoslovnice()
    {
        return $this->sifraPoslovnice;
    }
    /**
     * Set sifraPoslovnice value
     * @param string $sifraPoslovnice
     * @return \StructType\NalogZaglavlje
     */
    public function setSifraPoslovnice($sifraPoslovnice = null)
    {
        // validation for constraint: string
        if (!is_null($sifraPoslovnice) && !is_string($sifraPoslovnice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifraPoslovnice, true), gettype($sifraPoslovnice)), __LINE__);
        }
        $this->sifraPoslovnice = $sifraPoslovnice;
        return $this;
    }
    /**
     * Get sifraPartnera value
     * @return string|null
     */
    public function getSifraPartnera()
    {
        return $this->sifraPartnera;
    }
    /**
     * Set sifraPartnera value
     * @param string $sifraPartnera
     * @return \StructType\NalogZaglavlje
     */
    public function setSifraPartnera($sifraPartnera = null)
    {
        // validation for constraint: string
        if (!is_null($sifraPartnera) && !is_string($sifraPartnera)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifraPartnera, true), gettype($sifraPartnera)), __LINE__);
        }
        $this->sifraPartnera = $sifraPartnera;
        return $this;
    }
    /**
     * Get dostavoMjesto value
     * @return string|null
     */
    public function getDostavoMjesto()
    {
        return $this->dostavoMjesto;
    }
    /**
     * Set dostavoMjesto value
     * @param string $dostavoMjesto
     * @return \StructType\NalogZaglavlje
     */
    public function setDostavoMjesto($dostavoMjesto = null)
    {
        // validation for constraint: string
        if (!is_null($dostavoMjesto) && !is_string($dostavoMjesto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dostavoMjesto, true), gettype($dostavoMjesto)), __LINE__);
        }
        $this->dostavoMjesto = $dostavoMjesto;
        return $this;
    }
    /**
     * Get sifraIzvora value
     * @return int|null
     */
    public function getSifraIzvora()
    {
        return $this->sifraIzvora;
    }
    /**
     * Set sifraIzvora value
     * @param int $sifraIzvora
     * @return \StructType\NalogZaglavlje
     */
    public function setSifraIzvora($sifraIzvora = null)
    {
        // validation for constraint: int
        if (!is_null($sifraIzvora) && !(is_int($sifraIzvora) || ctype_digit($sifraIzvora))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sifraIzvora, true), gettype($sifraIzvora)), __LINE__);
        }
        $this->sifraIzvora = $sifraIzvora;
        return $this;
    }
    /**
     * Get tipListe value
     * @return string|null
     */
    public function getTipListe()
    {
        return $this->tipListe;
    }
    /**
     * Set tipListe value
     * @param string $tipListe
     * @return \StructType\NalogZaglavlje
     */
    public function setTipListe($tipListe = null)
    {
        // validation for constraint: string
        if (!is_null($tipListe) && !is_string($tipListe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipListe, true), gettype($tipListe)), __LINE__);
        }
        $this->tipListe = $tipListe;
        return $this;
    }
    /**
     * Get tipKanalaProdaje value
     * @return string|null
     */
    public function getTipKanalaProdaje()
    {
        return $this->tipKanalaProdaje;
    }
    /**
     * Set tipKanalaProdaje value
     * @param string $tipKanalaProdaje
     * @return \StructType\NalogZaglavlje
     */
    public function setTipKanalaProdaje($tipKanalaProdaje = null)
    {
        // validation for constraint: string
        if (!is_null($tipKanalaProdaje) && !is_string($tipKanalaProdaje)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipKanalaProdaje, true), gettype($tipKanalaProdaje)), __LINE__);
        }
        $this->tipKanalaProdaje = $tipKanalaProdaje;
        return $this;
    }
    /**
     * Get kanalProdaje value
     * @return string|null
     */
    public function getKanalProdaje()
    {
        return $this->kanalProdaje;
    }
    /**
     * Set kanalProdaje value
     * @param string $kanalProdaje
     * @return \StructType\NalogZaglavlje
     */
    public function setKanalProdaje($kanalProdaje = null)
    {
        // validation for constraint: string
        if (!is_null($kanalProdaje) && !is_string($kanalProdaje)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kanalProdaje, true), gettype($kanalProdaje)), __LINE__);
        }
        $this->kanalProdaje = $kanalProdaje;
        return $this;
    }
    /**
     * Get vlasnik value
     * @return string|null
     */
    public function getVlasnik()
    {
        return $this->vlasnik;
    }
    /**
     * Set vlasnik value
     * @param string $vlasnik
     * @return \StructType\NalogZaglavlje
     */
    public function setVlasnik($vlasnik = null)
    {
        // validation for constraint: string
        if (!is_null($vlasnik) && !is_string($vlasnik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vlasnik, true), gettype($vlasnik)), __LINE__);
        }
        $this->vlasnik = $vlasnik;
        return $this;
    }
    /**
     * Get brojOdobrenja value
     * @return string|null
     */
    public function getBrojOdobrenja()
    {
        return $this->brojOdobrenja;
    }
    /**
     * Set brojOdobrenja value
     * @param string $brojOdobrenja
     * @return \StructType\NalogZaglavlje
     */
    public function setBrojOdobrenja($brojOdobrenja = null)
    {
        // validation for constraint: string
        if (!is_null($brojOdobrenja) && !is_string($brojOdobrenja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brojOdobrenja, true), gettype($brojOdobrenja)), __LINE__);
        }
        $this->brojOdobrenja = $brojOdobrenja;
        return $this;
    }
    /**
     * Get brojRata value
     * @return int|null
     */
    public function getBrojRata()
    {
        return $this->brojRata;
    }
    /**
     * Set brojRata value
     * @param int $brojRata
     * @return \StructType\NalogZaglavlje
     */
    public function setBrojRata($brojRata = null)
    {
        // validation for constraint: int
        if (!is_null($brojRata) && !(is_int($brojRata) || ctype_digit($brojRata))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($brojRata, true), gettype($brojRata)), __LINE__);
        }
        $this->brojRata = $brojRata;
        return $this;
    }
    /**
     * Get tipNaloga value
     * @return string|null
     */
    public function getTipNaloga()
    {
        return $this->tipNaloga;
    }
    /**
     * Set tipNaloga value
     * @param string $tipNaloga
     * @return \StructType\NalogZaglavlje
     */
    public function setTipNaloga($tipNaloga = null)
    {
        // validation for constraint: string
        if (!is_null($tipNaloga) && !is_string($tipNaloga)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipNaloga, true), gettype($tipNaloga)), __LINE__);
        }
        $this->tipNaloga = $tipNaloga;
        return $this;
    }
    /**
     * Get napomena value
     * @return string|null
     */
    public function getNapomena()
    {
        return $this->napomena;
    }
    /**
     * Set napomena value
     * @param string $napomena
     * @return \StructType\NalogZaglavlje
     */
    public function setNapomena($napomena = null)
    {
        // validation for constraint: string
        if (!is_null($napomena) && !is_string($napomena)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($napomena, true), gettype($napomena)), __LINE__);
        }
        $this->napomena = $napomena;
        return $this;
    }
    /**
     * Get lopClan value
     * @return string|null
     */
    public function getLopClan()
    {
        return $this->lopClan;
    }
    /**
     * Set lopClan value
     * @param string $lopClan
     * @return \StructType\NalogZaglavlje
     */
    public function setLopClan($lopClan = null)
    {
        // validation for constraint: string
        if (!is_null($lopClan) && !is_string($lopClan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lopClan, true), gettype($lopClan)), __LINE__);
        }
        $this->lopClan = $lopClan;
        return $this;
    }
    /**
     * Get kolekcijaStavke value
     * @return \ArrayType\ArrayOfNalogStavke|null
     */
    public function getKolekcijaStavke()
    {
        return $this->kolekcijaStavke;
    }
    /**
     * Set kolekcijaStavke value
     * @param \ArrayType\ArrayOfNalogStavke $kolekcijaStavke
     * @return \StructType\NalogZaglavlje
     */
    public function setKolekcijaStavke(\ArrayType\ArrayOfNalogStavke $kolekcijaStavke = null)
    {
        $this->kolekcijaStavke = $kolekcijaStavke;
        return $this;
    }
    /**
     * Get kolekcijaNaciniPlacanja value
     * @return \ArrayType\ArrayOfNaciniPlacanja|null
     */
    public function getKolekcijaNaciniPlacanja()
    {
        return $this->kolekcijaNaciniPlacanja;
    }
    /**
     * Set kolekcijaNaciniPlacanja value
     * @param \ArrayType\ArrayOfNaciniPlacanja $kolekcijaNaciniPlacanja
     * @return \StructType\NalogZaglavlje
     */
    public function setKolekcijaNaciniPlacanja(\ArrayType\ArrayOfNaciniPlacanja $kolekcijaNaciniPlacanja = null)
    {
        $this->kolekcijaNaciniPlacanja = $kolekcijaNaciniPlacanja;
        return $this;
    }
    /**
     * Get kolekcijaDodatniPodaci value
     * @return \ArrayType\ArrayOfDodatniPodaci|null
     */
    public function getKolekcijaDodatniPodaci()
    {
        return $this->kolekcijaDodatniPodaci;
    }
    /**
     * Set kolekcijaDodatniPodaci value
     * @param \ArrayType\ArrayOfDodatniPodaci $kolekcijaDodatniPodaci
     * @return \StructType\NalogZaglavlje
     */
    public function setKolekcijaDodatniPodaci(\ArrayType\ArrayOfDodatniPodaci $kolekcijaDodatniPodaci = null)
    {
        $this->kolekcijaDodatniPodaci = $kolekcijaDodatniPodaci;
        return $this;
    }
}
