<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NalogStavka StructType
 * @subpackage Structs
 */
class NalogStavka extends AbstractStructBase
{
    /**
     * The sifraProizvoda
     * @var string
     */
    public $sifraProizvoda;
    /**
     * The tipProizvoda
     * @var string
     */
    public $tipProizvoda;
    /**
     * The kolicina
     * @var float
     */
    public $kolicina;
    /**
     * The maloprodajnaCijena
     * @var float
     */
    public $maloprodajnaCijena;
    /**
     * The osnovnaCijena
     * @var float
     */
    public $osnovnaCijena;
    /**
     * The redniBrojNaTenderu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $redniBrojNaTenderu;
    /**
     * The kolekcijaAkcijeNaStavci
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAkcija
     */
    public $kolekcijaAkcijeNaStavci;
    /**
     * The tipFinancijskeStavke
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipFinancijskeStavke;
    /**
     * The serijskiBrojBona
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serijskiBrojBona;
    /**
     * Constructor method for NalogStavka
     * @uses NalogStavka::setSifraProizvoda()
     * @uses NalogStavka::setTipProizvoda()
     * @uses NalogStavka::setKolicina()
     * @uses NalogStavka::setMaloprodajnaCijena()
     * @uses NalogStavka::setOsnovnaCijena()
     * @uses NalogStavka::setRedniBrojNaTenderu()
     * @uses NalogStavka::setKolekcijaAkcijeNaStavci()
     * @uses NalogStavka::setTipFinancijskeStavke()
     * @uses NalogStavka::setSerijskiBrojBona()
     * @param string $sifraProizvoda
     * @param string $tipProizvoda
     * @param float $kolicina
     * @param float $maloprodajnaCijena
     * @param float $osnovnaCijena
     * @param int $redniBrojNaTenderu
     * @param \ArrayType\ArrayOfAkcija $kolekcijaAkcijeNaStavci
     * @param string $tipFinancijskeStavke
     * @param string $serijskiBrojBona
     */
    public function __construct($sifraProizvoda = null, $tipProizvoda = null, $kolicina = null, $maloprodajnaCijena = null, $osnovnaCijena = null, $redniBrojNaTenderu = null, \ArrayType\ArrayOfAkcija $kolekcijaAkcijeNaStavci = null, $tipFinancijskeStavke = null, $serijskiBrojBona = null)
    {
        $this
            ->setSifraProizvoda($sifraProizvoda)
            ->setTipProizvoda($tipProizvoda)
            ->setKolicina($kolicina)
            ->setMaloprodajnaCijena($maloprodajnaCijena)
            ->setOsnovnaCijena($osnovnaCijena)
            ->setRedniBrojNaTenderu($redniBrojNaTenderu)
            ->setKolekcijaAkcijeNaStavci($kolekcijaAkcijeNaStavci)
            ->setTipFinancijskeStavke($tipFinancijskeStavke)
            ->setSerijskiBrojBona($serijskiBrojBona);
    }
    /**
     * Get sifraProizvoda value
     * @return string|null
     */
    public function getSifraProizvoda()
    {
        return $this->sifraProizvoda;
    }
    /**
     * Set sifraProizvoda value
     * @param string $sifraProizvoda
     * @return \StructType\NalogStavka
     */
    public function setSifraProizvoda($sifraProizvoda = null)
    {
        // validation for constraint: string
        if (!is_null($sifraProizvoda) && !is_string($sifraProizvoda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifraProizvoda, true), gettype($sifraProizvoda)), __LINE__);
        }
        $this->sifraProizvoda = $sifraProizvoda;
        return $this;
    }
    /**
     * Get tipProizvoda value
     * @return string|null
     */
    public function getTipProizvoda()
    {
        return $this->tipProizvoda;
    }
    /**
     * Set tipProizvoda value
     * @param string $tipProizvoda
     * @return \StructType\NalogStavka
     */
    public function setTipProizvoda($tipProizvoda = null)
    {
        // validation for constraint: string
        if (!is_null($tipProizvoda) && !is_string($tipProizvoda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipProizvoda, true), gettype($tipProizvoda)), __LINE__);
        }
        $this->tipProizvoda = $tipProizvoda;
        return $this;
    }
    /**
     * Get kolicina value
     * @return float|null
     */
    public function getKolicina()
    {
        return $this->kolicina;
    }
    /**
     * Set kolicina value
     * @param float $kolicina
     * @return \StructType\NalogStavka
     */
    public function setKolicina($kolicina = null)
    {
        // validation for constraint: float
        if (!is_null($kolicina) && !(is_float($kolicina) || is_numeric($kolicina))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kolicina, true), gettype($kolicina)), __LINE__);
        }
        $this->kolicina = $kolicina;
        return $this;
    }
    /**
     * Get maloprodajnaCijena value
     * @return float|null
     */
    public function getMaloprodajnaCijena()
    {
        return $this->maloprodajnaCijena;
    }
    /**
     * Set maloprodajnaCijena value
     * @param float $maloprodajnaCijena
     * @return \StructType\NalogStavka
     */
    public function setMaloprodajnaCijena($maloprodajnaCijena = null)
    {
        // validation for constraint: float
        if (!is_null($maloprodajnaCijena) && !(is_float($maloprodajnaCijena) || is_numeric($maloprodajnaCijena))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maloprodajnaCijena, true), gettype($maloprodajnaCijena)), __LINE__);
        }
        $this->maloprodajnaCijena = $maloprodajnaCijena;
        return $this;
    }
    /**
     * Get osnovnaCijena value
     * @return float|null
     */
    public function getOsnovnaCijena()
    {
        return $this->osnovnaCijena;
    }
    /**
     * Set osnovnaCijena value
     * @param float $osnovnaCijena
     * @return \StructType\NalogStavka
     */
    public function setOsnovnaCijena($osnovnaCijena = null)
    {
        // validation for constraint: float
        if (!is_null($osnovnaCijena) && !(is_float($osnovnaCijena) || is_numeric($osnovnaCijena))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($osnovnaCijena, true), gettype($osnovnaCijena)), __LINE__);
        }
        $this->osnovnaCijena = $osnovnaCijena;
        return $this;
    }
    /**
     * Get redniBrojNaTenderu value
     * @return int|null
     */
    public function getRedniBrojNaTenderu()
    {
        return $this->redniBrojNaTenderu;
    }
    /**
     * Set redniBrojNaTenderu value
     * @param int $redniBrojNaTenderu
     * @return \StructType\NalogStavka
     */
    public function setRedniBrojNaTenderu($redniBrojNaTenderu = null)
    {
        // validation for constraint: int
        if (!is_null($redniBrojNaTenderu) && !(is_int($redniBrojNaTenderu) || ctype_digit($redniBrojNaTenderu))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redniBrojNaTenderu, true), gettype($redniBrojNaTenderu)), __LINE__);
        }
        $this->redniBrojNaTenderu = $redniBrojNaTenderu;
        return $this;
    }
    /**
     * Get kolekcijaAkcijeNaStavci value
     * @return \ArrayType\ArrayOfAkcija|null
     */
    public function getKolekcijaAkcijeNaStavci()
    {
        return $this->kolekcijaAkcijeNaStavci;
    }
    /**
     * Set kolekcijaAkcijeNaStavci value
     * @param \ArrayType\ArrayOfAkcija $kolekcijaAkcijeNaStavci
     * @return \StructType\NalogStavka
     */
    public function setKolekcijaAkcijeNaStavci(\ArrayType\ArrayOfAkcija $kolekcijaAkcijeNaStavci = null)
    {
        $this->kolekcijaAkcijeNaStavci = $kolekcijaAkcijeNaStavci;
        return $this;
    }
    /**
     * Get tipFinancijskeStavke value
     * @return string|null
     */
    public function getTipFinancijskeStavke()
    {
        return $this->tipFinancijskeStavke;
    }
    /**
     * Set tipFinancijskeStavke value
     * @param string $tipFinancijskeStavke
     * @return \StructType\NalogStavka
     */
    public function setTipFinancijskeStavke($tipFinancijskeStavke = null)
    {
        // validation for constraint: string
        if (!is_null($tipFinancijskeStavke) && !is_string($tipFinancijskeStavke)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipFinancijskeStavke, true), gettype($tipFinancijskeStavke)), __LINE__);
        }
        $this->tipFinancijskeStavke = $tipFinancijskeStavke;
        return $this;
    }
    /**
     * Get serijskiBrojBona value
     * @return string|null
     */
    public function getSerijskiBrojBona()
    {
        return $this->serijskiBrojBona;
    }
    /**
     * Set serijskiBrojBona value
     * @param string $serijskiBrojBona
     * @return \StructType\NalogStavka
     */
    public function setSerijskiBrojBona($serijskiBrojBona = null)
    {
        // validation for constraint: string
        if (!is_null($serijskiBrojBona) && !is_string($serijskiBrojBona)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serijskiBrojBona, true), gettype($serijskiBrojBona)), __LINE__);
        }
        $this->serijskiBrojBona = $serijskiBrojBona;
        return $this;
    }
}
