<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NacinPlacanja StructType
 * @subpackage Structs
 */
class NacinPlacanja extends AbstractStructBase
{
    /**
     * The sifraNacinPlacanja
     * @var string
     */
    public $sifraNacinPlacanja;
    /**
     * The iznos
     * @var float
     */
    public $iznos;
    /**
     * The serijskiBrojBona
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serijskiBrojBona;
    /**
     * The efuId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $efuId;
    /**
     * The brojOdobrenja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $brojOdobrenja;
    /**
     * The brojPotvrde
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $brojPotvrde;
    /**
     * The brojRata
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $brojRata;
    /**
     * Constructor method for NacinPlacanja
     * @uses NacinPlacanja::setSifraNacinPlacanja()
     * @uses NacinPlacanja::setIznos()
     * @uses NacinPlacanja::setSerijskiBrojBona()
     * @uses NacinPlacanja::setEfuId()
     * @uses NacinPlacanja::setBrojOdobrenja()
     * @uses NacinPlacanja::setBrojPotvrde()
     * @uses NacinPlacanja::setBrojRata()
     * @param string $sifraNacinPlacanja
     * @param float $iznos
     * @param string $serijskiBrojBona
     * @param int $efuId
     * @param string $brojOdobrenja
     * @param string $brojPotvrde
     * @param int $brojRata
     */
    public function __construct($sifraNacinPlacanja = null, $iznos = null, $serijskiBrojBona = null, $efuId = null, $brojOdobrenja = null, $brojPotvrde = null, $brojRata = null)
    {
        $this
            ->setSifraNacinPlacanja($sifraNacinPlacanja)
            ->setIznos($iznos)
            ->setSerijskiBrojBona($serijskiBrojBona)
            ->setEfuId($efuId)
            ->setBrojOdobrenja($brojOdobrenja)
            ->setBrojPotvrde($brojPotvrde)
            ->setBrojRata($brojRata);
    }
    /**
     * Get sifraNacinPlacanja value
     * @return string|null
     */
    public function getSifraNacinPlacanja()
    {
        return $this->sifraNacinPlacanja;
    }
    /**
     * Set sifraNacinPlacanja value
     * @param string $sifraNacinPlacanja
     * @return \StructType\NacinPlacanja
     */
    public function setSifraNacinPlacanja($sifraNacinPlacanja = null)
    {
        // validation for constraint: string
        if (!is_null($sifraNacinPlacanja) && !is_string($sifraNacinPlacanja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifraNacinPlacanja, true), gettype($sifraNacinPlacanja)), __LINE__);
        }
        $this->sifraNacinPlacanja = $sifraNacinPlacanja;
        return $this;
    }
    /**
     * Get iznos value
     * @return float|null
     */
    public function getIznos()
    {
        return $this->iznos;
    }
    /**
     * Set iznos value
     * @param float $iznos
     * @return \StructType\NacinPlacanja
     */
    public function setIznos($iznos = null)
    {
        // validation for constraint: float
        if (!is_null($iznos) && !(is_float($iznos) || is_numeric($iznos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($iznos, true), gettype($iznos)), __LINE__);
        }
        $this->iznos = $iznos;
        return $this;
    }
    /**
     * Get serijskiBrojBona value
     * @return string|null
     */
    public function getSerijskiBrojBona()
    {
        return $this->serijskiBrojBona;
    }
    /**
     * Set serijskiBrojBona value
     * @param string $serijskiBrojBona
     * @return \StructType\NacinPlacanja
     */
    public function setSerijskiBrojBona($serijskiBrojBona = null)
    {
        // validation for constraint: string
        if (!is_null($serijskiBrojBona) && !is_string($serijskiBrojBona)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serijskiBrojBona, true), gettype($serijskiBrojBona)), __LINE__);
        }
        $this->serijskiBrojBona = $serijskiBrojBona;
        return $this;
    }
    /**
     * Get efuId value
     * @return int|null
     */
    public function getEfuId()
    {
        return $this->efuId;
    }
    /**
     * Set efuId value
     * @param int $efuId
     * @return \StructType\NacinPlacanja
     */
    public function setEfuId($efuId = null)
    {
        // validation for constraint: int
        if (!is_null($efuId) && !(is_int($efuId) || ctype_digit($efuId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($efuId, true), gettype($efuId)), __LINE__);
        }
        $this->efuId = $efuId;
        return $this;
    }
    /**
     * Get brojOdobrenja value
     * @return string|null
     */
    public function getBrojOdobrenja()
    {
        return $this->brojOdobrenja;
    }
    /**
     * Set brojOdobrenja value
     * @param string $brojOdobrenja
     * @return \StructType\NacinPlacanja
     */
    public function setBrojOdobrenja($brojOdobrenja = null)
    {
        // validation for constraint: string
        if (!is_null($brojOdobrenja) && !is_string($brojOdobrenja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brojOdobrenja, true), gettype($brojOdobrenja)), __LINE__);
        }
        $this->brojOdobrenja = $brojOdobrenja;
        return $this;
    }
    /**
     * Get brojPotvrde value
     * @return string|null
     */
    public function getBrojPotvrde()
    {
        return $this->brojPotvrde;
    }
    /**
     * Set brojPotvrde value
     * @param string $brojPotvrde
     * @return \StructType\NacinPlacanja
     */
    public function setBrojPotvrde($brojPotvrde = null)
    {
        // validation for constraint: string
        if (!is_null($brojPotvrde) && !is_string($brojPotvrde)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brojPotvrde, true), gettype($brojPotvrde)), __LINE__);
        }
        $this->brojPotvrde = $brojPotvrde;
        return $this;
    }
    /**
     * Get brojRata value
     * @return int|null
     */
    public function getBrojRata()
    {
        return $this->brojRata;
    }
    /**
     * Set brojRata value
     * @param int $brojRata
     * @return \StructType\NacinPlacanja
     */
    public function setBrojRata($brojRata = null)
    {
        // validation for constraint: int
        if (!is_null($brojRata) && !(is_int($brojRata) || ctype_digit($brojRata))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($brojRata, true), gettype($brojRata)), __LINE__);
        }
        $this->brojRata = $brojRata;
        return $this;
    }
}
