<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for lopClan StructType
 * @subpackage Structs
 */
class LopClan extends AbstractStructBase
{
    /**
     * The trenutniBrojBodova
     * @var float
     */
    public $trenutniBrojBodova;
    /**
     * The lopClan
     * @var string
     */
    public $lopClan;
    /**
     * The uclanjen
     * @var string
     */
    public $uclanjen;
    /**
     * The ime
     * @var string
     */
    public $ime;
    /**
     * The prezime
     * @var string
     */
    public $prezime;
    /**
     * The adresa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $adresa;
    /**
     * The telefon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $telefon;
    /**
     * The prezIme
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $prezIme;
    /**
     * The mjesto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $mjesto;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The radnik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $radnik;
    /**
     * Constructor method for lopClan
     * @uses LopClan::setTrenutniBrojBodova()
     * @uses LopClan::setLopClan()
     * @uses LopClan::setUclanjen()
     * @uses LopClan::setIme()
     * @uses LopClan::setPrezime()
     * @uses LopClan::setAdresa()
     * @uses LopClan::setTelefon()
     * @uses LopClan::setPrezIme_1()
     * @uses LopClan::setMjesto()
     * @uses LopClan::setEmail()
     * @uses LopClan::setRadnik()
     * @param float $trenutniBrojBodova
     * @param string $lopClan
     * @param string $uclanjen
     * @param string $ime
     * @param string $prezime
     * @param string $adresa
     * @param string $telefon
     * @param string $prezIme
     * @param int $mjesto
     * @param string $email
     * @param string $radnik
     */
    public function __construct($trenutniBrojBodova = null, $lopClan = null, $uclanjen = null, $ime = null, $prezime = null, $adresa = null, $telefon = null, $prezIme_1 = null, $mjesto = null, $email = null, $radnik = null)
    {
        $this
            ->setTrenutniBrojBodova($trenutniBrojBodova)
            ->setLopClan($lopClan)
            ->setUclanjen($uclanjen)
            ->setIme($ime)
            ->setPrezime($prezime)
            ->setAdresa($adresa)
            ->setTelefon($telefon)
            ->setPrezIme_1($prezIme_1)
            ->setMjesto($mjesto)
            ->setEmail($email)
            ->setRadnik($radnik);
    }
    /**
     * Get trenutniBrojBodova value
     * @return float|null
     */
    public function getTrenutniBrojBodova()
    {
        return $this->trenutniBrojBodova;
    }
    /**
     * Set trenutniBrojBodova value
     * @param float $trenutniBrojBodova
     * @return \StructType\LopClan
     */
    public function setTrenutniBrojBodova($trenutniBrojBodova = null)
    {
        // validation for constraint: float
        if (!is_null($trenutniBrojBodova) && !(is_float($trenutniBrojBodova) || is_numeric($trenutniBrojBodova))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($trenutniBrojBodova, true), gettype($trenutniBrojBodova)), __LINE__);
        }
        $this->trenutniBrojBodova = $trenutniBrojBodova;
        return $this;
    }
    /**
     * Get lopClan value
     * @return string|null
     */
    public function getLopClan()
    {
        return $this->lopClan;
    }
    /**
     * Set lopClan value
     * @param string $lopClan
     * @return \StructType\LopClan
     */
    public function setLopClan($lopClan = null)
    {
        // validation for constraint: string
        if (!is_null($lopClan) && !is_string($lopClan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lopClan, true), gettype($lopClan)), __LINE__);
        }
        $this->lopClan = $lopClan;
        return $this;
    }
    /**
     * Get uclanjen value
     * @return string|null
     */
    public function getUclanjen()
    {
        return $this->uclanjen;
    }
    /**
     * Set uclanjen value
     * @param string $uclanjen
     * @return \StructType\LopClan
     */
    public function setUclanjen($uclanjen = null)
    {
        // validation for constraint: string
        if (!is_null($uclanjen) && !is_string($uclanjen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uclanjen, true), gettype($uclanjen)), __LINE__);
        }
        $this->uclanjen = $uclanjen;
        return $this;
    }
    /**
     * Get ime value
     * @return string|null
     */
    public function getIme()
    {
        return $this->ime;
    }
    /**
     * Set ime value
     * @param string $ime
     * @return \StructType\LopClan
     */
    public function setIme($ime = null)
    {
        // validation for constraint: string
        if (!is_null($ime) && !is_string($ime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ime, true), gettype($ime)), __LINE__);
        }
        $this->ime = $ime;
        return $this;
    }
    /**
     * Get prezime value
     * @return string|null
     */
    public function getPrezime()
    {
        return $this->prezime;
    }
    /**
     * Set prezime value
     * @param string $prezime
     * @return \StructType\LopClan
     */
    public function setPrezime($prezime = null)
    {
        // validation for constraint: string
        if (!is_null($prezime) && !is_string($prezime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prezime, true), gettype($prezime)), __LINE__);
        }
        $this->prezime = $prezime;
        return $this;
    }
    /**
     * Get adresa value
     * @return string|null
     */
    public function getAdresa()
    {
        return $this->adresa;
    }
    /**
     * Set adresa value
     * @param string $adresa
     * @return \StructType\LopClan
     */
    public function setAdresa($adresa = null)
    {
        // validation for constraint: string
        if (!is_null($adresa) && !is_string($adresa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresa, true), gettype($adresa)), __LINE__);
        }
        $this->adresa = $adresa;
        return $this;
    }
    /**
     * Get telefon value
     * @return string|null
     */
    public function getTelefon()
    {
        return $this->telefon;
    }
    /**
     * Set telefon value
     * @param string $telefon
     * @return \StructType\LopClan
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: string
        if (!is_null($telefon) && !is_string($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefon, true), gettype($telefon)), __LINE__);
        }
        $this->telefon = $telefon;
        return $this;
    }
    /**
     * Get prezIme value
     * @return string|null
     */
    public function getPrezIme_1()
    {
        return $this->prezIme;
    }
    /**
     * Set prezIme value
     * @param string $prezIme
     * @return \StructType\LopClan
     */
    public function setPrezIme_1($prezIme_1 = null)
    {
        // validation for constraint: string
        if (!is_null($prezIme_1) && !is_string($prezIme_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prezIme_1, true), gettype($prezIme_1)), __LINE__);
        }
        $this->prezIme = $prezIme_1;
        return $this;
    }
    /**
     * Get mjesto value
     * @return int|null
     */
    public function getMjesto()
    {
        return $this->mjesto;
    }
    /**
     * Set mjesto value
     * @param int $mjesto
     * @return \StructType\LopClan
     */
    public function setMjesto($mjesto = null)
    {
        // validation for constraint: int
        if (!is_null($mjesto) && !(is_int($mjesto) || ctype_digit($mjesto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mjesto, true), gettype($mjesto)), __LINE__);
        }
        $this->mjesto = $mjesto;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\LopClan
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get radnik value
     * @return string|null
     */
    public function getRadnik()
    {
        return $this->radnik;
    }
    /**
     * Set radnik value
     * @param string $radnik
     * @return \StructType\LopClan
     */
    public function setRadnik($radnik = null)
    {
        // validation for constraint: string
        if (!is_null($radnik) && !is_string($radnik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($radnik, true), gettype($radnik)), __LINE__);
        }
        $this->radnik = $radnik;
        return $this;
    }
}
