<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListaSkola StructType
 * @subpackage Structs
 */
class ListaSkola extends AbstractStructBase
{
    /**
     * The skola
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Skola[]
     */
    public $skola;
    /**
     * Constructor method for ListaSkola
     * @uses ListaSkola::setSkola()
     * @param \StructType\Skola[] $skola
     */
    public function __construct(array $skola = array())
    {
        $this
            ->setSkola($skola);
    }
    /**
     * Get skola value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Skola[]|null
     */
    public function getSkola()
    {
        return isset($this->skola) ? $this->skola : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSkola method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSkola method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSkolaForArrayConstraintsFromSetSkola(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listaSkolaSkolaItem) {
            // validation for constraint: itemType
            if (!$listaSkolaSkolaItem instanceof \StructType\Skola) {
                $invalidValues[] = is_object($listaSkolaSkolaItem) ? get_class($listaSkolaSkolaItem) : sprintf('%s(%s)', gettype($listaSkolaSkolaItem), var_export($listaSkolaSkolaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The skola property can only contain items of type \StructType\Skola, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set skola value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Skola[] $skola
     * @return \StructType\ListaSkola
     */
    public function setSkola(array $skola = array())
    {
        // validation for constraint: array
        if ('' !== ($skolaArrayErrorMessage = self::validateSkolaForArrayConstraintsFromSetSkola($skola))) {
            throw new \InvalidArgumentException($skolaArrayErrorMessage, __LINE__);
        }
        if (is_null($skola) || (is_array($skola) && empty($skola))) {
            unset($this->skola);
        } else {
            $this->skola = $skola;
        }
        return $this;
    }
    /**
     * Add item to skola value
     * @throws \InvalidArgumentException
     * @param \StructType\Skola $item
     * @return \StructType\ListaSkola
     */
    public function addToSkola(\StructType\Skola $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Skola) {
            throw new \InvalidArgumentException(sprintf('The skola property can only contain items of type \StructType\Skola, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->skola[] = $item;
        return $this;
    }
}
