<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListaProizvoda StructType
 * @subpackage Structs
 */
class ListaProizvoda extends AbstractStructBase
{
    /**
     * The proizvod
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Proizvod[]
     */
    public $proizvod;
    /**
     * Constructor method for ListaProizvoda
     * @uses ListaProizvoda::setProizvod()
     * @param \StructType\Proizvod[] $proizvod
     */
    public function __construct(array $proizvod = array())
    {
        $this
            ->setProizvod($proizvod);
    }
    /**
     * Get proizvod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Proizvod[]|null
     */
    public function getProizvod()
    {
        return isset($this->proizvod) ? $this->proizvod : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProizvod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProizvod method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProizvodForArrayConstraintsFromSetProizvod(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listaProizvodaProizvodItem) {
            // validation for constraint: itemType
            if (!$listaProizvodaProizvodItem instanceof \StructType\Proizvod) {
                $invalidValues[] = is_object($listaProizvodaProizvodItem) ? get_class($listaProizvodaProizvodItem) : sprintf('%s(%s)', gettype($listaProizvodaProizvodItem), var_export($listaProizvodaProizvodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The proizvod property can only contain items of type \StructType\Proizvod, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set proizvod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Proizvod[] $proizvod
     * @return \StructType\ListaProizvoda
     */
    public function setProizvod(array $proizvod = array())
    {
        // validation for constraint: array
        if ('' !== ($proizvodArrayErrorMessage = self::validateProizvodForArrayConstraintsFromSetProizvod($proizvod))) {
            throw new \InvalidArgumentException($proizvodArrayErrorMessage, __LINE__);
        }
        if (is_null($proizvod) || (is_array($proizvod) && empty($proizvod))) {
            unset($this->proizvod);
        } else {
            $this->proizvod = $proizvod;
        }
        return $this;
    }
    /**
     * Add item to proizvod value
     * @throws \InvalidArgumentException
     * @param \StructType\Proizvod $item
     * @return \StructType\ListaProizvoda
     */
    public function addToProizvod(\StructType\Proizvod $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Proizvod) {
            throw new \InvalidArgumentException(sprintf('The proizvod property can only contain items of type \StructType\Proizvod, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->proizvod[] = $item;
        return $this;
    }
}
