<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListaPartnera StructType
 * @subpackage Structs
 */
class ListaPartnera extends AbstractStructBase
{
    /**
     * The partner
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Partner[]
     */
    public $partner;
    /**
     * Constructor method for ListaPartnera
     * @uses ListaPartnera::setPartner()
     * @param \StructType\Partner[] $partner
     */
    public function __construct(array $partner = array())
    {
        $this
            ->setPartner($partner);
    }
    /**
     * Get partner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Partner[]|null
     */
    public function getPartner()
    {
        return isset($this->partner) ? $this->partner : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPartner method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartner method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartnerForArrayConstraintsFromSetPartner(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listaPartneraPartnerItem) {
            // validation for constraint: itemType
            if (!$listaPartneraPartnerItem instanceof \StructType\Partner) {
                $invalidValues[] = is_object($listaPartneraPartnerItem) ? get_class($listaPartneraPartnerItem) : sprintf('%s(%s)', gettype($listaPartneraPartnerItem), var_export($listaPartneraPartnerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The partner property can only contain items of type \StructType\Partner, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set partner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Partner[] $partner
     * @return \StructType\ListaPartnera
     */
    public function setPartner(array $partner = array())
    {
        // validation for constraint: array
        if ('' !== ($partnerArrayErrorMessage = self::validatePartnerForArrayConstraintsFromSetPartner($partner))) {
            throw new \InvalidArgumentException($partnerArrayErrorMessage, __LINE__);
        }
        if (is_null($partner) || (is_array($partner) && empty($partner))) {
            unset($this->partner);
        } else {
            $this->partner = $partner;
        }
        return $this;
    }
    /**
     * Add item to partner value
     * @throws \InvalidArgumentException
     * @param \StructType\Partner $item
     * @return \StructType\ListaPartnera
     */
    public function addToPartner(\StructType\Partner $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Partner) {
            throw new \InvalidArgumentException(sprintf('The partner property can only contain items of type \StructType\Partner, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->partner[] = $item;
        return $this;
    }
}
