<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ERPAkcija StructType
 * @subpackage Structs
 */
class ERPAkcija extends AbstractStructBase
{
    /**
     * The sifraAkcije
     * @var string
     */
    public $sifraAkcije;
    /**
     * The nazivAkcije
     * @var string
     */
    public $nazivAkcije;
    /**
     * The pocetakAkcije
     * @var string
     */
    public $pocetakAkcije;
    /**
     * The krajAkcije
     * @var string
     */
    public $krajAkcije;
    /**
     * Constructor method for ERPAkcija
     * @uses ERPAkcija::setSifraAkcije()
     * @uses ERPAkcija::setNazivAkcije()
     * @uses ERPAkcija::setPocetakAkcije()
     * @uses ERPAkcija::setKrajAkcije()
     * @param string $sifraAkcije
     * @param string $nazivAkcije
     * @param string $pocetakAkcije
     * @param string $krajAkcije
     */
    public function __construct($sifraAkcije = null, $nazivAkcije = null, $pocetakAkcije = null, $krajAkcije = null)
    {
        $this
            ->setSifraAkcije($sifraAkcije)
            ->setNazivAkcije($nazivAkcije)
            ->setPocetakAkcije($pocetakAkcije)
            ->setKrajAkcije($krajAkcije);
    }
    /**
     * Get sifraAkcije value
     * @return string|null
     */
    public function getSifraAkcije()
    {
        return $this->sifraAkcije;
    }
    /**
     * Set sifraAkcije value
     * @param string $sifraAkcije
     * @return \StructType\ERPAkcija
     */
    public function setSifraAkcije($sifraAkcije = null)
    {
        // validation for constraint: string
        if (!is_null($sifraAkcije) && !is_string($sifraAkcije)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifraAkcije, true), gettype($sifraAkcije)), __LINE__);
        }
        $this->sifraAkcije = $sifraAkcije;
        return $this;
    }
    /**
     * Get nazivAkcije value
     * @return string|null
     */
    public function getNazivAkcije()
    {
        return $this->nazivAkcije;
    }
    /**
     * Set nazivAkcije value
     * @param string $nazivAkcije
     * @return \StructType\ERPAkcija
     */
    public function setNazivAkcije($nazivAkcije = null)
    {
        // validation for constraint: string
        if (!is_null($nazivAkcije) && !is_string($nazivAkcije)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazivAkcije, true), gettype($nazivAkcije)), __LINE__);
        }
        $this->nazivAkcije = $nazivAkcije;
        return $this;
    }
    /**
     * Get pocetakAkcije value
     * @return string|null
     */
    public function getPocetakAkcije()
    {
        return $this->pocetakAkcije;
    }
    /**
     * Set pocetakAkcije value
     * @param string $pocetakAkcije
     * @return \StructType\ERPAkcija
     */
    public function setPocetakAkcije($pocetakAkcije = null)
    {
        // validation for constraint: string
        if (!is_null($pocetakAkcije) && !is_string($pocetakAkcije)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pocetakAkcije, true), gettype($pocetakAkcije)), __LINE__);
        }
        $this->pocetakAkcije = $pocetakAkcije;
        return $this;
    }
    /**
     * Get krajAkcije value
     * @return string|null
     */
    public function getKrajAkcije()
    {
        return $this->krajAkcije;
    }
    /**
     * Set krajAkcije value
     * @param string $krajAkcije
     * @return \StructType\ERPAkcija
     */
    public function setKrajAkcije($krajAkcije = null)
    {
        // validation for constraint: string
        if (!is_null($krajAkcije) && !is_string($krajAkcije)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($krajAkcije, true), gettype($krajAkcije)), __LINE__);
        }
        $this->krajAkcije = $krajAkcije;
        return $this;
    }
}
