<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DostavnoMjesto StructType
 * @subpackage Structs
 */
class DostavnoMjesto extends AbstractStructBase
{
    /**
     * The sifra
     * @var string
     */
    public $sifra;
    /**
     * The naziv
     * @var string
     */
    public $naziv;
    /**
     * The ulica
     * @var string
     */
    public $ulica;
    /**
     * The postanskiBroj
     * @var int
     */
    public $postanskiBroj;
    /**
     * The mjesto
     * @var string
     */
    public $mjesto;
    /**
     * The telefon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $telefon;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * Constructor method for DostavnoMjesto
     * @uses DostavnoMjesto::setSifra()
     * @uses DostavnoMjesto::setNaziv()
     * @uses DostavnoMjesto::setUlica()
     * @uses DostavnoMjesto::setPostanskiBroj()
     * @uses DostavnoMjesto::setMjesto()
     * @uses DostavnoMjesto::setTelefon()
     * @uses DostavnoMjesto::setFax()
     * @param string $sifra
     * @param string $naziv
     * @param string $ulica
     * @param int $postanskiBroj
     * @param string $mjesto
     * @param string $telefon
     * @param string $fax
     */
    public function __construct($sifra = null, $naziv = null, $ulica = null, $postanskiBroj = null, $mjesto = null, $telefon = null, $fax = null)
    {
        $this
            ->setSifra($sifra)
            ->setNaziv($naziv)
            ->setUlica($ulica)
            ->setPostanskiBroj($postanskiBroj)
            ->setMjesto($mjesto)
            ->setTelefon($telefon)
            ->setFax($fax);
    }
    /**
     * Get sifra value
     * @return string|null
     */
    public function getSifra()
    {
        return $this->sifra;
    }
    /**
     * Set sifra value
     * @param string $sifra
     * @return \StructType\DostavnoMjesto
     */
    public function setSifra($sifra = null)
    {
        // validation for constraint: string
        if (!is_null($sifra) && !is_string($sifra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifra, true), gettype($sifra)), __LINE__);
        }
        $this->sifra = $sifra;
        return $this;
    }
    /**
     * Get naziv value
     * @return string|null
     */
    public function getNaziv()
    {
        return $this->naziv;
    }
    /**
     * Set naziv value
     * @param string $naziv
     * @return \StructType\DostavnoMjesto
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        $this->naziv = $naziv;
        return $this;
    }
    /**
     * Get ulica value
     * @return string|null
     */
    public function getUlica()
    {
        return $this->ulica;
    }
    /**
     * Set ulica value
     * @param string $ulica
     * @return \StructType\DostavnoMjesto
     */
    public function setUlica($ulica = null)
    {
        // validation for constraint: string
        if (!is_null($ulica) && !is_string($ulica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ulica, true), gettype($ulica)), __LINE__);
        }
        $this->ulica = $ulica;
        return $this;
    }
    /**
     * Get postanskiBroj value
     * @return int|null
     */
    public function getPostanskiBroj()
    {
        return $this->postanskiBroj;
    }
    /**
     * Set postanskiBroj value
     * @param int $postanskiBroj
     * @return \StructType\DostavnoMjesto
     */
    public function setPostanskiBroj($postanskiBroj = null)
    {
        // validation for constraint: int
        if (!is_null($postanskiBroj) && !(is_int($postanskiBroj) || ctype_digit($postanskiBroj))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($postanskiBroj, true), gettype($postanskiBroj)), __LINE__);
        }
        $this->postanskiBroj = $postanskiBroj;
        return $this;
    }
    /**
     * Get mjesto value
     * @return string|null
     */
    public function getMjesto()
    {
        return $this->mjesto;
    }
    /**
     * Set mjesto value
     * @param string $mjesto
     * @return \StructType\DostavnoMjesto
     */
    public function setMjesto($mjesto = null)
    {
        // validation for constraint: string
        if (!is_null($mjesto) && !is_string($mjesto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mjesto, true), gettype($mjesto)), __LINE__);
        }
        $this->mjesto = $mjesto;
        return $this;
    }
    /**
     * Get telefon value
     * @return string|null
     */
    public function getTelefon()
    {
        return $this->telefon;
    }
    /**
     * Set telefon value
     * @param string $telefon
     * @return \StructType\DostavnoMjesto
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: string
        if (!is_null($telefon) && !is_string($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefon, true), gettype($telefon)), __LINE__);
        }
        $this->telefon = $telefon;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\DostavnoMjesto
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
}
