<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Atribut StructType
 * @subpackage Structs
 */
class Atribut extends AbstractStructBase
{
    /**
     * The sifra
     * @var string
     */
    public $sifra;
    /**
     * The naziv
     * @var string
     */
    public $naziv;
    /**
     * The tip
     * @var string
     */
    public $tip;
    /**
     * The domena
     * @var string
     */
    public $domena;
    /**
     * Constructor method for Atribut
     * @uses Atribut::setSifra()
     * @uses Atribut::setNaziv()
     * @uses Atribut::setTip()
     * @uses Atribut::setDomena()
     * @param string $sifra
     * @param string $naziv
     * @param string $tip
     * @param string $domena
     */
    public function __construct($sifra = null, $naziv = null, $tip = null, $domena = null)
    {
        $this
            ->setSifra($sifra)
            ->setNaziv($naziv)
            ->setTip($tip)
            ->setDomena($domena);
    }
    /**
     * Get sifra value
     * @return string|null
     */
    public function getSifra()
    {
        return $this->sifra;
    }
    /**
     * Set sifra value
     * @param string $sifra
     * @return \StructType\Atribut
     */
    public function setSifra($sifra = null)
    {
        // validation for constraint: string
        if (!is_null($sifra) && !is_string($sifra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifra, true), gettype($sifra)), __LINE__);
        }
        $this->sifra = $sifra;
        return $this;
    }
    /**
     * Get naziv value
     * @return string|null
     */
    public function getNaziv()
    {
        return $this->naziv;
    }
    /**
     * Set naziv value
     * @param string $naziv
     * @return \StructType\Atribut
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        $this->naziv = $naziv;
        return $this;
    }
    /**
     * Get tip value
     * @return string|null
     */
    public function getTip()
    {
        return $this->tip;
    }
    /**
     * Set tip value
     * @param string $tip
     * @return \StructType\Atribut
     */
    public function setTip($tip = null)
    {
        // validation for constraint: string
        if (!is_null($tip) && !is_string($tip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tip, true), gettype($tip)), __LINE__);
        }
        $this->tip = $tip;
        return $this;
    }
    /**
     * Get domena value
     * @return string|null
     */
    public function getDomena()
    {
        return $this->domena;
    }
    /**
     * Set domena value
     * @param string $domena
     * @return \StructType\Atribut
     */
    public function setDomena($domena = null)
    {
        // validation for constraint: string
        if (!is_null($domena) && !is_string($domena)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domena, true), gettype($domena)), __LINE__);
        }
        $this->domena = $domena;
        return $this;
    }
}
